/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class DynamicOpsNBT
implements DynamicOps<NBTBase> {
    public static final DynamicOpsNBT INSTANCE = new DynamicOpsNBT();
    private static final String WRAPPER_MARKER = "";

    protected DynamicOpsNBT() {
    }

    public NBTBase empty() {
        return NBTTagEnd.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> var0, NBTBase var1) {
        return (U)(switch (var1.getId()) {
            case 0 -> var0.empty();
            case 1 -> var0.createByte(((NBTNumber)var1).getAsByte());
            case 2 -> var0.createShort(((NBTNumber)var1).getAsShort());
            case 3 -> var0.createInt(((NBTNumber)var1).getAsInt());
            case 4 -> var0.createLong(((NBTNumber)var1).getAsLong());
            case 5 -> var0.createFloat(((NBTNumber)var1).getAsFloat());
            case 6 -> var0.createDouble(((NBTNumber)var1).getAsDouble());
            case 7 -> var0.createByteList(ByteBuffer.wrap(((NBTTagByteArray)var1).getAsByteArray()));
            case 8 -> var0.createString(var1.getAsString());
            case 9 -> this.convertList(var0, var1);
            case 10 -> this.convertMap(var0, var1);
            case 11 -> var0.createIntList(Arrays.stream(((NBTTagIntArray)var1).getAsIntArray()));
            case 12 -> var0.createLongList(Arrays.stream(((NBTTagLongArray)var1).getAsLongArray()));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf(var1));
        });
    }

    public DataResult<Number> getNumberValue(NBTBase var0) {
        if (var0 instanceof NBTNumber) {
            NBTNumber var1 = (NBTNumber)var0;
            return DataResult.success((Object)var1.getAsNumber());
        }
        return DataResult.error(() -> "Not a number");
    }

    public NBTBase createNumeric(Number var0) {
        return NBTTagDouble.valueOf(var0.doubleValue());
    }

    public NBTBase createByte(byte var0) {
        return NBTTagByte.valueOf(var0);
    }

    public NBTBase createShort(short var0) {
        return NBTTagShort.valueOf(var0);
    }

    public NBTBase createInt(int var0) {
        return NBTTagInt.valueOf(var0);
    }

    public NBTBase createLong(long var0) {
        return NBTTagLong.valueOf(var0);
    }

    public NBTBase createFloat(float var0) {
        return NBTTagFloat.valueOf(var0);
    }

    public NBTBase createDouble(double var0) {
        return NBTTagDouble.valueOf(var0);
    }

    public NBTBase createBoolean(boolean var0) {
        return NBTTagByte.valueOf(var0);
    }

    public DataResult<String> getStringValue(NBTBase var0) {
        if (var0 instanceof NBTTagString) {
            NBTTagString var1 = (NBTTagString)var0;
            return DataResult.success((Object)var1.getAsString());
        }
        return DataResult.error(() -> "Not a string");
    }

    public NBTBase createString(String var0) {
        return NBTTagString.valueOf(var0);
    }

    public DataResult<NBTBase> mergeToList(NBTBase var0, NBTBase var12) {
        return DynamicOpsNBT.createCollector(var0).map(var1 -> DataResult.success((Object)var1.accept(var12).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(var0), (Object)var0));
    }

    public DataResult<NBTBase> mergeToList(NBTBase var0, List<NBTBase> var12) {
        return DynamicOpsNBT.createCollector(var0).map(var1 -> DataResult.success((Object)var1.acceptAll(var12).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(var0), (Object)var0));
    }

    public DataResult<NBTBase> mergeToMap(NBTBase var0, NBTBase var1, NBTBase var2) {
        NBTTagCompound nBTTagCompound;
        if (!(var0 instanceof NBTTagCompound) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var0), (Object)var0);
        }
        if (!(var1 instanceof NBTTagString)) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(var1), (Object)var0);
        }
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var4 = (NBTTagCompound)var0;
            nBTTagCompound = var4.shallowCopy();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound var3 = nBTTagCompound;
        var3.put(var1.getAsString(), var2);
        return DataResult.success((Object)var3);
    }

    public DataResult<NBTBase> mergeToMap(NBTBase var0, MapLike<NBTBase> var1) {
        NBTTagCompound nBTTagCompound;
        Object var3;
        if (!(var0 instanceof NBTTagCompound) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var0), (Object)var0);
        }
        if (var0 instanceof NBTTagCompound) {
            var3 = (NBTTagCompound)var0;
            nBTTagCompound = ((NBTTagCompound)var3).shallowCopy();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound var2 = nBTTagCompound;
        var3 = new ArrayList();
        var1.entries().forEach(arg_0 -> DynamicOpsNBT.a((List)var3, var2, arg_0));
        if (!var3.isEmpty()) {
            return DataResult.error(() -> DynamicOpsNBT.b((List)var3), (Object)var2);
        }
        return DataResult.success((Object)var2);
    }

    public DataResult<NBTBase> mergeToMap(NBTBase var0, Map<NBTBase, NBTBase> var1) {
        NBTTagCompound nBTTagCompound;
        Object var3;
        if (!(var0 instanceof NBTTagCompound) && !(var0 instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var0), (Object)var0);
        }
        if (var0 instanceof NBTTagCompound) {
            var3 = (NBTTagCompound)var0;
            nBTTagCompound = ((NBTTagCompound)var3).shallowCopy();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound var2 = nBTTagCompound;
        var3 = new ArrayList();
        for (Map.Entry<NBTBase, NBTBase> var5 : var1.entrySet()) {
            NBTBase var6 = var5.getKey();
            if (var6 instanceof NBTTagString) {
                var2.put(var6.getAsString(), var5.getValue());
                continue;
            }
            var3.add(var6);
        }
        if (!var3.isEmpty()) {
            return DataResult.error(() -> DynamicOpsNBT.a((List)var3), (Object)var2);
        }
        return DataResult.success((Object)var2);
    }

    public DataResult<Stream<Pair<NBTBase, NBTBase>>> getMapValues(NBTBase var02) {
        if (var02 instanceof NBTTagCompound) {
            NBTTagCompound var1 = (NBTTagCompound)var02;
            return DataResult.success(var1.entrySet().stream().map(var0 -> Pair.of((Object)this.createString((String)var0.getKey()), (Object)((NBTBase)var0.getValue()))));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(var02));
    }

    public DataResult<Consumer<BiConsumer<NBTBase, NBTBase>>> getMapEntries(NBTBase var0) {
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var12 = (NBTTagCompound)var0;
            return DataResult.success(var1 -> {
                for (Map.Entry<String, NBTBase> var3 : var12.entrySet()) {
                    var1.accept(this.createString(var3.getKey()), var3.getValue());
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(var0));
    }

    public DataResult<MapLike<NBTBase>> getMap(NBTBase var0) {
        if (var0 instanceof NBTTagCompound) {
            final NBTTagCompound var1 = (NBTTagCompound)var0;
            return DataResult.success((Object)new MapLike<NBTBase>(){

                @Nullable
                public NBTBase get(NBTBase var0) {
                    return var1.get(var0.getAsString());
                }

                @Nullable
                public NBTBase get(String var0) {
                    return var1.get(var0);
                }

                public Stream<Pair<NBTBase, NBTBase>> entries() {
                    return var1.entrySet().stream().map(var0 -> Pair.of((Object)DynamicOpsNBT.this.createString((String)var0.getKey()), (Object)((NBTBase)var0.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(var1) + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.get(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.get((NBTBase)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(var0));
    }

    public NBTBase createMap(Stream<Pair<NBTBase, NBTBase>> var0) {
        NBTTagCompound var12 = new NBTTagCompound();
        var0.forEach(var1 -> var12.put(((NBTBase)var1.getFirst()).getAsString(), (NBTBase)var1.getSecond()));
        return var12;
    }

    private static NBTBase tryUnwrap(NBTTagCompound var0) {
        NBTBase var1;
        if (var0.size() == 1 && (var1 = var0.get(WRAPPER_MARKER)) != null) {
            return var1;
        }
        return var0;
    }

    public DataResult<Stream<NBTBase>> getStream(NBTBase var02) {
        if (var02 instanceof NBTTagList) {
            NBTTagList var1 = (NBTTagList)var02;
            if (var1.getElementType() == 10) {
                return DataResult.success(var1.stream().map(var0 -> DynamicOpsNBT.tryUnwrap((NBTTagCompound)var0)));
            }
            return DataResult.success(var1.stream());
        }
        if (var02 instanceof NBTList) {
            NBTList var1 = (NBTList)var02;
            return DataResult.success(var1.stream().map(var0 -> var0));
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<NBTBase>>> getList(NBTBase var0) {
        if (var0 instanceof NBTTagList) {
            NBTTagList var12 = (NBTTagList)var0;
            if (var12.getElementType() == 10) {
                return DataResult.success(var1 -> {
                    for (NBTBase var3 : var12) {
                        var1.accept(DynamicOpsNBT.tryUnwrap((NBTTagCompound)var3));
                    }
                });
            }
            return DataResult.success(var12::forEach);
        }
        if (var0 instanceof NBTList) {
            NBTList var13 = (NBTList)var0;
            return DataResult.success(var13::forEach);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(var0));
    }

    public DataResult<ByteBuffer> getByteBuffer(NBTBase var0) {
        if (var0 instanceof NBTTagByteArray) {
            NBTTagByteArray var1 = (NBTTagByteArray)var0;
            return DataResult.success((Object)ByteBuffer.wrap(var1.getAsByteArray()));
        }
        return super.getByteBuffer((Object)var0);
    }

    public NBTBase createByteList(ByteBuffer var0) {
        ByteBuffer var1 = var0.duplicate().clear();
        byte[] var2 = new byte[var0.capacity()];
        var1.get(0, var2, 0, var2.length);
        return new NBTTagByteArray(var2);
    }

    public DataResult<IntStream> getIntStream(NBTBase var0) {
        if (var0 instanceof NBTTagIntArray) {
            NBTTagIntArray var1 = (NBTTagIntArray)var0;
            return DataResult.success((Object)Arrays.stream(var1.getAsIntArray()));
        }
        return super.getIntStream((Object)var0);
    }

    public NBTBase createIntList(IntStream var0) {
        return new NBTTagIntArray(var0.toArray());
    }

    public DataResult<LongStream> getLongStream(NBTBase var0) {
        if (var0 instanceof NBTTagLongArray) {
            NBTTagLongArray var1 = (NBTTagLongArray)var0;
            return DataResult.success((Object)Arrays.stream(var1.getAsLongArray()));
        }
        return super.getLongStream((Object)var0);
    }

    public NBTBase createLongList(LongStream var0) {
        return new NBTTagLongArray(var0.toArray());
    }

    public NBTBase createList(Stream<NBTBase> var0) {
        return d.INSTANCE.acceptAll(var0).result();
    }

    public NBTBase remove(NBTBase var0, String var1) {
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var2 = (NBTTagCompound)var0;
            NBTTagCompound var3 = var2.shallowCopy();
            var3.remove(var1);
            return var3;
        }
        return var0;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<NBTBase> mapBuilder() {
        return new h(this);
    }

    private static Optional<f> createCollector(NBTBase var0) {
        if (var0 instanceof NBTTagEnd) {
            return Optional.of(d.INSTANCE);
        }
        if (var0 instanceof NBTList) {
            NBTList var1 = (NBTList)var0;
            if (var1.isEmpty()) {
                return Optional.of(d.INSTANCE);
            }
            if (var1 instanceof NBTTagList) {
                NBTTagList var2 = (NBTTagList)var1;
                return switch (var2.getElementType()) {
                    case 0 -> Optional.of(d.INSTANCE);
                    case 10 -> Optional.of(new b(var2));
                    default -> Optional.of(new c(var2));
                };
            }
            if (var1 instanceof NBTTagByteArray) {
                NBTTagByteArray var2 = (NBTTagByteArray)var1;
                return Optional.of(new a(var2.getAsByteArray()));
            }
            if (var1 instanceof NBTTagIntArray) {
                NBTTagIntArray var2 = (NBTTagIntArray)var1;
                return Optional.of(new e(var2.getAsIntArray()));
            }
            if (var1 instanceof NBTTagLongArray) {
                NBTTagLongArray var2 = (NBTTagLongArray)var1;
                return Optional.of(new g(var2.getAsLongArray()));
            }
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((NBTBase)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((NBTBase)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((NBTBase)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((NBTBase)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((NBTBase)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((NBTBase)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((NBTBase)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((NBTBase)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((NBTBase)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((NBTBase)object, (MapLike<NBTBase>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Map map) {
        return this.mergeToMap((NBTBase)object, (Map<NBTBase, NBTBase>)map);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((NBTBase)object, (NBTBase)object2, (NBTBase)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((NBTBase)object, (List<NBTBase>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((NBTBase)object, (NBTBase)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((NBTBase)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d2) {
        return this.createDouble(d2);
    }

    public /* synthetic */ Object createFloat(float f2) {
        return this.createFloat(f2);
    }

    public /* synthetic */ Object createLong(long l2) {
        return this.createLong(l2);
    }

    public /* synthetic */ Object createInt(int n2) {
        return this.createInt(n2);
    }

    public /* synthetic */ Object createShort(short s2) {
        return this.createShort(s2);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((NBTBase)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (NBTBase)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    private static /* synthetic */ String a(List var0) {
        return "some keys are not strings: " + String.valueOf(var0);
    }

    private static /* synthetic */ String b(List var0) {
        return "some keys are not strings: " + String.valueOf(var0);
    }

    private static /* synthetic */ void a(List var0, NBTTagCompound var1, Pair var2) {
        NBTBase var3 = (NBTBase)var2.getFirst();
        if (!(var3 instanceof NBTTagString)) {
            var0.add(var3);
            return;
        }
        var1.put(var3.getAsString(), (NBTBase)var2.getSecond());
    }

    static class d
    implements f {
        public static final d INSTANCE = new d();

        private d() {
        }

        @Override
        public f accept(NBTBase var0) {
            if (var0 instanceof NBTTagCompound) {
                NBTTagCompound var1 = (NBTTagCompound)var0;
                return new b().accept(var1);
            }
            if (var0 instanceof NBTTagByte) {
                NBTTagByte var1 = (NBTTagByte)var0;
                return new a(var1.getAsByte());
            }
            if (var0 instanceof NBTTagInt) {
                NBTTagInt var1 = (NBTTagInt)var0;
                return new e(var1.getAsInt());
            }
            if (var0 instanceof NBTTagLong) {
                NBTTagLong var1 = (NBTTagLong)var0;
                return new g(var1.getAsLong());
            }
            return new c(var0);
        }

        @Override
        public NBTBase result() {
            return new NBTTagList();
        }
    }

    static interface f {
        public f accept(NBTBase var1);

        default public f acceptAll(Iterable<NBTBase> var0) {
            f var1 = this;
            for (NBTBase var3 : var0) {
                var1 = var1.accept(var3);
            }
            return var1;
        }

        default public f acceptAll(Stream<NBTBase> var0) {
            return this.acceptAll(var0::iterator);
        }

        public NBTBase result();
    }

    class h
    extends RecordBuilder.AbstractStringBuilder<NBTBase, NBTTagCompound> {
        protected h(DynamicOpsNBT dynamicOpsNBT) {
            super((DynamicOps)dynamicOpsNBT);
        }

        protected NBTTagCompound initBuilder() {
            return new NBTTagCompound();
        }

        protected NBTTagCompound append(String var0, NBTBase var1, NBTTagCompound var2) {
            var2.put(var0, var1);
            return var2;
        }

        protected DataResult<NBTBase> build(NBTTagCompound var0, NBTBase var1) {
            if (var1 == null || var1 == NBTTagEnd.INSTANCE) {
                return DataResult.success((Object)var0);
            }
            if (var1 instanceof NBTTagCompound) {
                NBTTagCompound var2 = (NBTTagCompound)var1;
                NBTTagCompound var3 = var2.shallowCopy();
                for (Map.Entry<String, NBTBase> var5 : var0.entrySet()) {
                    var3.put(var5.getKey(), var5.getValue());
                }
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var1), (Object)var1);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (NBTBase)object, (NBTTagCompound)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((NBTTagCompound)object, (NBTBase)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    static class b
    implements f {
        private final NBTTagList result = new NBTTagList();

        public b() {
        }

        public b(Collection<NBTBase> var0) {
            this.result.addAll(var0);
        }

        public b(IntArrayList var02) {
            var02.forEach(var0 -> this.result.add(b.wrapElement(NBTTagInt.valueOf(var0))));
        }

        public b(ByteArrayList var02) {
            var02.forEach(var0 -> this.result.add(b.wrapElement(NBTTagByte.valueOf(var0))));
        }

        public b(LongArrayList var02) {
            var02.forEach(var0 -> this.result.add(b.wrapElement(NBTTagLong.valueOf(var0))));
        }

        private static boolean isWrapper(NBTTagCompound var0) {
            return var0.size() == 1 && var0.contains(DynamicOpsNBT.WRAPPER_MARKER);
        }

        private static NBTBase wrapIfNeeded(NBTBase var0) {
            NBTTagCompound var1;
            if (var0 instanceof NBTTagCompound && !b.isWrapper(var1 = (NBTTagCompound)var0)) {
                return var1;
            }
            return b.wrapElement(var0);
        }

        private static NBTTagCompound wrapElement(NBTBase var0) {
            NBTTagCompound var1 = new NBTTagCompound();
            var1.put(DynamicOpsNBT.WRAPPER_MARKER, var0);
            return var1;
        }

        @Override
        public f accept(NBTBase var0) {
            this.result.add(b.wrapIfNeeded(var0));
            return this;
        }

        @Override
        public NBTBase result() {
            return this.result;
        }
    }

    static class c
    implements f {
        private final NBTTagList result = new NBTTagList();

        c(NBTBase var0) {
            this.result.add(var0);
        }

        c(NBTTagList var0) {
            this.result.addAll(var0);
        }

        @Override
        public f accept(NBTBase var0) {
            if (var0.getId() != this.result.getElementType()) {
                return new b().acceptAll(this.result).accept(var0);
            }
            this.result.add(var0);
            return this;
        }

        @Override
        public NBTBase result() {
            return this.result;
        }
    }

    static class a
    implements f {
        private final ByteArrayList values = new ByteArrayList();

        public a(byte var0) {
            this.values.add(var0);
        }

        public a(byte[] var0) {
            this.values.addElements(0, var0);
        }

        @Override
        public f accept(NBTBase var0) {
            if (var0 instanceof NBTTagByte) {
                NBTTagByte var1 = (NBTTagByte)var0;
                this.values.add(var1.getAsByte());
                return this;
            }
            return new b(this.values).accept(var0);
        }

        @Override
        public NBTBase result() {
            return new NBTTagByteArray(this.values.toByteArray());
        }
    }

    static class e
    implements f {
        private final IntArrayList values = new IntArrayList();

        public e(int var0) {
            this.values.add(var0);
        }

        public e(int[] var0) {
            this.values.addElements(0, var0);
        }

        @Override
        public f accept(NBTBase var0) {
            if (var0 instanceof NBTTagInt) {
                NBTTagInt var1 = (NBTTagInt)var0;
                this.values.add(var1.getAsInt());
                return this;
            }
            return new b(this.values).accept(var0);
        }

        @Override
        public NBTBase result() {
            return new NBTTagIntArray(this.values.toIntArray());
        }
    }

    static class g
    implements f {
        private final LongArrayList values = new LongArrayList();

        public g(long var0) {
            this.values.add(var0);
        }

        public g(long[] var0) {
            this.values.addElements(0, var0);
        }

        @Override
        public f accept(NBTBase var0) {
            if (var0 instanceof NBTTagLong) {
                NBTTagLong var1 = (NBTTagLong)var0;
                this.values.add(var1.getAsLong());
                return this;
            }
            return new b(this.values).accept(var0);
        }

        @Override
        public NBTBase result() {
            return new NBTTagLongArray(this.values.toLongArray());
        }
    }
}

