/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;

public class StringTagVisitor
implements TagVisitor {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private final StringBuilder builder = new StringBuilder();

    public String visit(NBTBase var0) {
        var0.accept(this);
        return this.builder.toString();
    }

    @Override
    public void visitString(NBTTagString var0) {
        this.builder.append(NBTTagString.quoteAndEscape(var0.getAsString()));
    }

    @Override
    public void visitByte(NBTTagByte var0) {
        this.builder.append(var0.getAsNumber()).append('b');
    }

    @Override
    public void visitShort(NBTTagShort var0) {
        this.builder.append(var0.getAsNumber()).append('s');
    }

    @Override
    public void visitInt(NBTTagInt var0) {
        this.builder.append(var0.getAsNumber());
    }

    @Override
    public void visitLong(NBTTagLong var0) {
        this.builder.append(var0.getAsNumber()).append('L');
    }

    @Override
    public void visitFloat(NBTTagFloat var0) {
        this.builder.append(var0.getAsFloat()).append('f');
    }

    @Override
    public void visitDouble(NBTTagDouble var0) {
        this.builder.append(var0.getAsDouble()).append('d');
    }

    @Override
    public void visitByteArray(NBTTagByteArray var0) {
        this.builder.append("[B;");
        byte[] var1 = var0.getAsByteArray();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.builder.append(var1[var2]).append('B');
        }
        this.builder.append(']');
    }

    @Override
    public void visitIntArray(NBTTagIntArray var0) {
        this.builder.append("[I;");
        int[] var1 = var0.getAsIntArray();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.builder.append(var1[var2]);
        }
        this.builder.append(']');
    }

    @Override
    public void visitLongArray(NBTTagLongArray var0) {
        this.builder.append("[L;");
        long[] var1 = var0.getAsLongArray();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var2 != 0) {
                this.builder.append(',');
            }
            this.builder.append(var1[var2]).append('L');
        }
        this.builder.append(']');
    }

    @Override
    public void visitList(NBTTagList var0) {
        this.builder.append('[');
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            if (var1 != 0) {
                this.builder.append(',');
            }
            this.builder.append(new StringTagVisitor().visit(var0.get(var1)));
        }
        this.builder.append(']');
    }

    @Override
    public void visitCompound(NBTTagCompound var0) {
        this.builder.append('{');
        ArrayList var1 = Lists.newArrayList(var0.getAllKeys());
        Collections.sort(var1);
        for (String var3 : var1) {
            if (this.builder.length() != 1) {
                this.builder.append(',');
            }
            this.builder.append(StringTagVisitor.handleEscape(var3)).append(':').append(new StringTagVisitor().visit(var0.get(var3)));
        }
        this.builder.append('}');
    }

    protected static String handleEscape(String var0) {
        if (SIMPLE_VALUE.matcher(var0).matches()) {
            return var0;
        }
        return NBTTagString.quoteAndEscape(var0);
    }

    @Override
    public void visitEnd(NBTTagEnd var0) {
        this.builder.append("END");
    }
}

