/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.slf4j.Logger;

public class SignedMessageChain {
    static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    SignedMessageLink nextLink;
    Instant lastTimeStamp = Instant.EPOCH;

    public SignedMessageChain(UUID var0, UUID var1) {
        this.nextLink = SignedMessageLink.root(var0, var1);
    }

    public c encoder(Signer var0) {
        return var1 -> {
            SignedMessageLink var22 = this.nextLink;
            if (var22 == null) {
                return null;
            }
            this.nextLink = var22.advance();
            return new MessageSignature(var0.sign(var2 -> PlayerChatMessage.updateSignature(var2, var22, var1)));
        };
    }

    public b decoder(final ProfilePublicKey var0) {
        final SignatureValidator var1 = var0.createSignatureValidator();
        return new b(){

            @Override
            public PlayerChatMessage unpack(@Nullable MessageSignature var02, SignedMessageBody var12) throws a {
                if (var02 == null) {
                    throw new a(a.MISSING_PROFILE_KEY);
                }
                if (var0.data().hasExpired()) {
                    throw new a(a.EXPIRED_PROFILE_KEY);
                }
                SignedMessageLink var2 = SignedMessageChain.this.nextLink;
                if (var2 == null) {
                    throw new a(a.CHAIN_BROKEN);
                }
                if (var12.timeStamp().isBefore(SignedMessageChain.this.lastTimeStamp)) {
                    this.setChainBroken();
                    throw new a(a.OUT_OF_ORDER_CHAT);
                }
                SignedMessageChain.this.lastTimeStamp = var12.timeStamp();
                PlayerChatMessage var3 = new PlayerChatMessage(var2, var02, var12, null, FilterMask.PASS_THROUGH);
                if (!var3.verify(var1)) {
                    this.setChainBroken();
                    throw new a(a.INVALID_SIGNATURE);
                }
                if (var3.hasExpiredServer(Instant.now())) {
                    LOGGER.warn("Received expired chat: '{}'. Is the client/server system time unsynchronized?", (Object)var12.content());
                }
                SignedMessageChain.this.nextLink = var2.advance();
                return var3;
            }

            @Override
            public void setChainBroken() {
                SignedMessageChain.this.nextLink = null;
            }
        };
    }

    @FunctionalInterface
    public static interface c {
        public static final c UNSIGNED = var0 -> null;

        @Nullable
        public MessageSignature pack(SignedMessageBody var1);
    }

    public static class a
    extends ThrowingComponent {
        static final IChatBaseComponent MISSING_PROFILE_KEY = IChatBaseComponent.translatable("chat.disabled.missingProfileKey");
        static final IChatBaseComponent CHAIN_BROKEN = IChatBaseComponent.translatable("chat.disabled.chain_broken");
        static final IChatBaseComponent EXPIRED_PROFILE_KEY = IChatBaseComponent.translatable("chat.disabled.expiredProfileKey");
        static final IChatBaseComponent INVALID_SIGNATURE = IChatBaseComponent.translatable("chat.disabled.invalid_signature");
        static final IChatBaseComponent OUT_OF_ORDER_CHAT = IChatBaseComponent.translatable("chat.disabled.out_of_order_chat");

        public a(IChatBaseComponent var0) {
            super(var0);
        }
    }

    @FunctionalInterface
    public static interface b {
        public static b unsigned(UUID var0, BooleanSupplier var1) {
            return (var2, var3) -> {
                if (var1.getAsBoolean()) {
                    throw new a(a.MISSING_PROFILE_KEY);
                }
                return PlayerChatMessage.unsigned(var0, var3.content());
            };
        }

        public PlayerChatMessage unpack(@Nullable MessageSignature var1, SignedMessageBody var2) throws a;

        default public void setChainBroken() {
        }
    }
}

