/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.border.WorldBorder;

public class ClientboundInitializeBorderPacket
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, ClientboundInitializeBorderPacket> STREAM_CODEC = Packet.codec(ClientboundInitializeBorderPacket::write, ClientboundInitializeBorderPacket::new);
    private final double newCenterX;
    private final double newCenterZ;
    private final double oldSize;
    private final double newSize;
    private final long lerpTime;
    private final int newAbsoluteMaxSize;
    private final int warningBlocks;
    private final int warningTime;

    private ClientboundInitializeBorderPacket(PacketDataSerializer var0) {
        this.newCenterX = var0.readDouble();
        this.newCenterZ = var0.readDouble();
        this.oldSize = var0.readDouble();
        this.newSize = var0.readDouble();
        this.lerpTime = var0.readVarLong();
        this.newAbsoluteMaxSize = var0.readVarInt();
        this.warningBlocks = var0.readVarInt();
        this.warningTime = var0.readVarInt();
    }

    public ClientboundInitializeBorderPacket(WorldBorder var0) {
        this.newCenterX = var0.getCenterX();
        this.newCenterZ = var0.getCenterZ();
        this.oldSize = var0.getSize();
        this.newSize = var0.getLerpTarget();
        this.lerpTime = var0.getLerpRemainingTime();
        this.newAbsoluteMaxSize = var0.getAbsoluteMaxSize();
        this.warningBlocks = var0.getWarningBlocks();
        this.warningTime = var0.getWarningTime();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeDouble(this.newCenterX);
        var0.writeDouble(this.newCenterZ);
        var0.writeDouble(this.oldSize);
        var0.writeDouble(this.newSize);
        var0.writeVarLong(this.lerpTime);
        var0.writeVarInt(this.newAbsoluteMaxSize);
        var0.writeVarInt(this.warningBlocks);
        var0.writeVarInt(this.warningTime);
    }

    @Override
    public PacketType<ClientboundInitializeBorderPacket> type() {
        return GamePacketTypes.CLIENTBOUND_INITIALIZE_BORDER;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleInitializeBorder(this);
    }

    public double getNewCenterX() {
        return this.newCenterX;
    }

    public double getNewCenterZ() {
        return this.newCenterZ;
    }

    public double getNewSize() {
        return this.newSize;
    }

    public double getOldSize() {
        return this.oldSize;
    }

    public long getLerpTime() {
        return this.lerpTime;
    }

    public int getNewAbsoluteMaxSize() {
        return this.newAbsoluteMaxSize;
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }
}

