/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.item.ItemStack;

public class PacketPlayInWindowClick
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayInWindowClick> STREAM_CODEC = Packet.codec(PacketPlayInWindowClick::write, PacketPlayInWindowClick::new);
    private static final int MAX_SLOT_COUNT = 128;
    private static final StreamCodec<RegistryFriendlyByteBuf, Int2ObjectMap<ItemStack>> SLOTS_STREAM_CODEC = ByteBufCodecs.map(Int2ObjectOpenHashMap::new, ByteBufCodecs.SHORT.map(Short::intValue, Integer::shortValue), ItemStack.OPTIONAL_STREAM_CODEC, 128);
    private final int containerId;
    private final int stateId;
    private final int slotNum;
    private final int buttonNum;
    private final InventoryClickType clickType;
    private final ItemStack carriedItem;
    private final Int2ObjectMap<ItemStack> changedSlots;

    public PacketPlayInWindowClick(int var0, int var1, int var2, int var3, InventoryClickType var4, ItemStack var5, Int2ObjectMap<ItemStack> var6) {
        this.containerId = var0;
        this.stateId = var1;
        this.slotNum = var2;
        this.buttonNum = var3;
        this.clickType = var4;
        this.carriedItem = var5;
        this.changedSlots = Int2ObjectMaps.unmodifiable(var6);
    }

    private PacketPlayInWindowClick(RegistryFriendlyByteBuf var0) {
        this.containerId = var0.readByte();
        this.stateId = var0.readVarInt();
        this.slotNum = var0.readShort();
        this.buttonNum = var0.readByte();
        this.clickType = var0.readEnum(InventoryClickType.class);
        this.changedSlots = Int2ObjectMaps.unmodifiable((Int2ObjectMap)((Int2ObjectMap)SLOTS_STREAM_CODEC.decode(var0)));
        this.carriedItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(var0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeByte(this.containerId);
        var0.writeVarInt(this.stateId);
        var0.writeShort(this.slotNum);
        var0.writeByte(this.buttonNum);
        var0.writeEnum(this.clickType);
        SLOTS_STREAM_CODEC.encode(var0, this.changedSlots);
        ItemStack.OPTIONAL_STREAM_CODEC.encode(var0, this.carriedItem);
    }

    @Override
    public PacketType<PacketPlayInWindowClick> type() {
        return GamePacketTypes.SERVERBOUND_CONTAINER_CLICK;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleContainerClick(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getSlotNum() {
        return this.slotNum;
    }

    public int getButtonNum() {
        return this.buttonNum;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public Int2ObjectMap<ItemStack> getChangedSlots() {
        return this.changedSlots;
    }

    public InventoryClickType getClickType() {
        return this.clickType;
    }

    public int getStateId() {
        return this.stateId;
    }
}

