/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.item.trading.MerchantRecipeList;

public class PacketPlayOutOpenWindowMerchant
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutOpenWindowMerchant> STREAM_CODEC = Packet.codec(PacketPlayOutOpenWindowMerchant::write, PacketPlayOutOpenWindowMerchant::new);
    private final int containerId;
    private final MerchantRecipeList offers;
    private final int villagerLevel;
    private final int villagerXp;
    private final boolean showProgress;
    private final boolean canRestock;

    public PacketPlayOutOpenWindowMerchant(int var0, MerchantRecipeList var1, int var2, int var3, boolean var4, boolean var5) {
        this.containerId = var0;
        this.offers = var1.copy();
        this.villagerLevel = var2;
        this.villagerXp = var3;
        this.showProgress = var4;
        this.canRestock = var5;
    }

    private PacketPlayOutOpenWindowMerchant(RegistryFriendlyByteBuf var0) {
        this.containerId = var0.readVarInt();
        this.offers = (MerchantRecipeList)MerchantRecipeList.STREAM_CODEC.decode(var0);
        this.villagerLevel = var0.readVarInt();
        this.villagerXp = var0.readVarInt();
        this.showProgress = var0.readBoolean();
        this.canRestock = var0.readBoolean();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.containerId);
        MerchantRecipeList.STREAM_CODEC.encode(var0, this.offers);
        var0.writeVarInt(this.villagerLevel);
        var0.writeVarInt(this.villagerXp);
        var0.writeBoolean(this.showProgress);
        var0.writeBoolean(this.canRestock);
    }

    @Override
    public PacketType<PacketPlayOutOpenWindowMerchant> type() {
        return GamePacketTypes.CLIENTBOUND_MERCHANT_OFFERS;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMerchantOffers(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public MerchantRecipeList getOffers() {
        return this.offers;
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public boolean showProgress() {
        return this.showProgress;
    }

    public boolean canRestock() {
        return this.canRestock;
    }
}

