/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class PacketPlayOutScoreboardObjective
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutScoreboardObjective> STREAM_CODEC = Packet.codec(PacketPlayOutScoreboardObjective::write, PacketPlayOutScoreboardObjective::new);
    public static final int METHOD_ADD = 0;
    public static final int METHOD_REMOVE = 1;
    public static final int METHOD_CHANGE = 2;
    private final String objectiveName;
    private final IChatBaseComponent displayName;
    private final IScoreboardCriteria.EnumScoreboardHealthDisplay renderType;
    private final Optional<NumberFormat> numberFormat;
    private final int method;

    public PacketPlayOutScoreboardObjective(ScoreboardObjective var0, int var1) {
        this.objectiveName = var0.getName();
        this.displayName = var0.getDisplayName();
        this.renderType = var0.getRenderType();
        this.numberFormat = Optional.ofNullable(var0.numberFormat());
        this.method = var1;
    }

    private PacketPlayOutScoreboardObjective(RegistryFriendlyByteBuf var0) {
        this.objectiveName = var0.readUtf();
        this.method = var0.readByte();
        if (this.method == 0 || this.method == 2) {
            this.displayName = (IChatBaseComponent)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
            this.renderType = var0.readEnum(IScoreboardCriteria.EnumScoreboardHealthDisplay.class);
            this.numberFormat = (Optional)NumberFormatTypes.OPTIONAL_STREAM_CODEC.decode(var0);
        } else {
            this.displayName = CommonComponents.EMPTY;
            this.renderType = IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER;
            this.numberFormat = Optional.empty();
        }
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeUtf(this.objectiveName);
        var0.writeByte(this.method);
        if (this.method == 0 || this.method == 2) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.displayName);
            var0.writeEnum(this.renderType);
            NumberFormatTypes.OPTIONAL_STREAM_CODEC.encode(var0, this.numberFormat);
        }
    }

    @Override
    public PacketType<PacketPlayOutScoreboardObjective> type() {
        return GamePacketTypes.CLIENTBOUND_SET_OBJECTIVE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddObjective(this);
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    public int getMethod() {
        return this.method;
    }

    public IScoreboardCriteria.EnumScoreboardHealthDisplay getRenderType() {
        return this.renderType;
    }

    public Optional<NumberFormat> getNumberFormat() {
        return this.numberFormat;
    }
}

