/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntityExperienceOrb
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutSpawnEntityExperienceOrb> STREAM_CODEC = Packet.codec(PacketPlayOutSpawnEntityExperienceOrb::write, PacketPlayOutSpawnEntityExperienceOrb::new);
    private final int id;
    private final double x;
    private final double y;
    private final double z;
    private final int value;

    public PacketPlayOutSpawnEntityExperienceOrb(EntityExperienceOrb var0, EntityTrackerEntry var1) {
        this.id = var0.getId();
        Vec3D var2 = var1.getPositionBase();
        this.x = var2.x();
        this.y = var2.y();
        this.z = var2.z();
        this.value = var0.getValue();
    }

    private PacketPlayOutSpawnEntityExperienceOrb(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.value = var0.readShort();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeShort(this.value);
    }

    @Override
    public PacketType<PacketPlayOutSpawnEntityExperienceOrb> type() {
        return GamePacketTypes.CLIENTBOUND_ADD_EXPERIENCE_ORB;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddExperienceOrb(this);
    }

    public int getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getValue() {
        return this.value;
    }
}

