/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.resources.MinecraftKey;

public class LoginPacketTypes {
    public static final PacketType<PacketLoginOutCustomPayload> CLIENTBOUND_CUSTOM_QUERY = LoginPacketTypes.createClientbound("custom_query");
    public static final PacketType<PacketLoginOutSuccess> CLIENTBOUND_GAME_PROFILE = LoginPacketTypes.createClientbound("game_profile");
    public static final PacketType<PacketLoginOutEncryptionBegin> CLIENTBOUND_HELLO = LoginPacketTypes.createClientbound("hello");
    public static final PacketType<PacketLoginOutSetCompression> CLIENTBOUND_LOGIN_COMPRESSION = LoginPacketTypes.createClientbound("login_compression");
    public static final PacketType<PacketLoginOutDisconnect> CLIENTBOUND_LOGIN_DISCONNECT = LoginPacketTypes.createClientbound("login_disconnect");
    public static final PacketType<ServerboundCustomQueryAnswerPacket> SERVERBOUND_CUSTOM_QUERY_ANSWER = LoginPacketTypes.createServerbound("custom_query_answer");
    public static final PacketType<PacketLoginInStart> SERVERBOUND_HELLO = LoginPacketTypes.createServerbound("hello");
    public static final PacketType<PacketLoginInEncryptionBegin> SERVERBOUND_KEY = LoginPacketTypes.createServerbound("key");
    public static final PacketType<ServerboundLoginAcknowledgedPacket> SERVERBOUND_LOGIN_ACKNOWLEDGED = LoginPacketTypes.createServerbound("login_acknowledged");

    private static <T extends Packet<PacketLoginOutListener>> PacketType<T> createClientbound(String var0) {
        return new PacketType(EnumProtocolDirection.CLIENTBOUND, MinecraftKey.withDefaultNamespace(var0));
    }

    private static <T extends Packet<PacketLoginInListener>> PacketType<T> createServerbound(String var0) {
        return new PacketType(EnumProtocolDirection.SERVERBOUND, MinecraftKey.withDefaultNamespace(var0));
    }
}

