/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class AdvancementDataPlayer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PlayerList playerList;
    private final Path playerSavePath;
    private AdvancementTree tree;
    private final Map<AdvancementHolder, AdvancementProgress> progress = new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
    private final Set<AdvancementHolder> visible = new HashSet<AdvancementHolder>();
    private final Set<AdvancementHolder> progressChanged = new HashSet<AdvancementHolder>();
    private final Set<AdvancementNode> rootsToUpdate = new HashSet<AdvancementNode>();
    private EntityPlayer player;
    @Nullable
    private AdvancementHolder lastSelectedTab;
    private boolean isFirstPacket = true;
    private final Codec<a> codec;

    public AdvancementDataPlayer(DataFixer var0, PlayerList var1, AdvancementDataWorld var2, Path var3, EntityPlayer var4) {
        this.playerList = var1;
        this.playerSavePath = var3;
        this.player = var4;
        this.tree = var2.tree();
        int var5 = 1343;
        this.codec = DataFixTypes.ADVANCEMENTS.wrapCodec(a.CODEC, var0, 1343);
        this.load(var2);
    }

    public void setPlayer(EntityPlayer var0) {
        this.player = var0;
    }

    public void stopListening() {
        for (CriterionTrigger criterionTrigger : BuiltInRegistries.TRIGGER_TYPES) {
            criterionTrigger.removePlayerListeners(this);
        }
    }

    public void reload(AdvancementDataWorld var0) {
        this.stopListening();
        this.progress.clear();
        this.visible.clear();
        this.rootsToUpdate.clear();
        this.progressChanged.clear();
        this.isFirstPacket = true;
        this.lastSelectedTab = null;
        this.tree = var0.tree();
        this.load(var0);
    }

    private void registerListeners(AdvancementDataWorld var0) {
        for (AdvancementHolder var2 : var0.getAllAdvancements()) {
            this.registerListeners(var2);
        }
    }

    private void checkForAutomaticTriggers(AdvancementDataWorld var0) {
        for (AdvancementHolder var2 : var0.getAllAdvancements()) {
            Advancement var3 = var2.value();
            if (!var3.criteria().isEmpty()) continue;
            this.award(var2, "");
            var3.rewards().grant(this.player);
        }
    }

    private void load(AdvancementDataWorld var0) {
        if (Files.isRegularFile(this.playerSavePath, new LinkOption[0])) {
            try (JsonReader var1 = new JsonReader((Reader)Files.newBufferedReader(this.playerSavePath, StandardCharsets.UTF_8));){
                var1.setLenient(false);
                JsonElement var2 = Streams.parse((JsonReader)var1);
                a var3 = (a)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var2).getOrThrow(JsonParseException::new);
                this.applyFrom(var0, var3);
            }
            catch (JsonIOException | IOException var12) {
                LOGGER.error("Couldn't access player advancements in {}", (Object)this.playerSavePath, (Object)var12);
            }
            catch (JsonParseException var13) {
                LOGGER.error("Couldn't parse player advancements in {}", (Object)this.playerSavePath, (Object)var13);
            }
        }
        this.checkForAutomaticTriggers(var0);
        this.registerListeners(var0);
    }

    public void save() {
        JsonElement var0 = (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.asData()).getOrThrow();
        try {
            FileUtils.createDirectoriesSafe(this.playerSavePath.getParent());
            try (BufferedWriter var1 = Files.newBufferedWriter(this.playerSavePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(var0, GSON.newJsonWriter((Writer)var1));
            }
        }
        catch (JsonIOException | IOException var1) {
            LOGGER.error("Couldn't save player advancements to {}", (Object)this.playerSavePath, (Object)var1);
        }
    }

    private void applyFrom(AdvancementDataWorld var0, a var12) {
        var12.forEach((var1, var2) -> {
            AdvancementHolder var3 = var0.get((MinecraftKey)var1);
            if (var3 == null) {
                LOGGER.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", var1, (Object)this.playerSavePath);
                return;
            }
            this.startProgress(var3, (AdvancementProgress)var2);
            this.progressChanged.add(var3);
            this.markForVisibilityUpdate(var3);
        });
    }

    private a asData() {
        LinkedHashMap<MinecraftKey, AdvancementProgress> var0 = new LinkedHashMap<MinecraftKey, AdvancementProgress>();
        this.progress.forEach((var1, var2) -> {
            if (var2.hasProgress()) {
                var0.put(var1.id(), (AdvancementProgress)var2);
            }
        });
        return new a(var0);
    }

    public boolean award(AdvancementHolder var0, String var12) {
        boolean var2 = false;
        AdvancementProgress var3 = this.getOrStartProgress(var0);
        boolean var4 = var3.isDone();
        if (var3.grantProgress(var12)) {
            this.unregisterListeners(var0);
            this.progressChanged.add(var0);
            var2 = true;
            if (!var4 && var3.isDone()) {
                var0.value().rewards().grant(this.player);
                var0.value().display().ifPresent(var1 -> {
                    if (var1.shouldAnnounceChat() && this.player.level().getGameRules().getBoolean(GameRules.RULE_ANNOUNCE_ADVANCEMENTS)) {
                        this.playerList.broadcastSystemMessage(var1.getType().createAnnouncement(var0, this.player), false);
                    }
                });
            }
        }
        if (!var4 && var3.isDone()) {
            this.markForVisibilityUpdate(var0);
        }
        return var2;
    }

    public boolean revoke(AdvancementHolder var0, String var1) {
        boolean var2 = false;
        AdvancementProgress var3 = this.getOrStartProgress(var0);
        boolean var4 = var3.isDone();
        if (var3.revokeProgress(var1)) {
            this.registerListeners(var0);
            this.progressChanged.add(var0);
            var2 = true;
        }
        if (var4 && !var3.isDone()) {
            this.markForVisibilityUpdate(var0);
        }
        return var2;
    }

    private void markForVisibilityUpdate(AdvancementHolder var0) {
        AdvancementNode var1 = this.tree.get(var0);
        if (var1 != null) {
            this.rootsToUpdate.add(var1.root());
        }
    }

    private void registerListeners(AdvancementHolder var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        if (var1.isDone()) {
            return;
        }
        for (Map.Entry<String, Criterion<?>> var3 : var0.value().criteria().entrySet()) {
            CriterionProgress var4 = var1.getCriterion(var3.getKey());
            if (var4 == null || var4.isDone()) continue;
            this.registerListener(var0, var3.getKey(), var3.getValue());
        }
    }

    private <T extends CriterionInstance> void registerListener(AdvancementHolder var0, String var1, Criterion<T> var2) {
        var2.trigger().addPlayerListener(this, new CriterionTrigger.a<T>(var2.triggerInstance(), var0, var1));
    }

    private void unregisterListeners(AdvancementHolder var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        for (Map.Entry<String, Criterion<?>> var3 : var0.value().criteria().entrySet()) {
            CriterionProgress var4 = var1.getCriterion(var3.getKey());
            if (var4 == null || !var4.isDone() && !var1.isDone()) continue;
            this.removeListener(var0, var3.getKey(), var3.getValue());
        }
    }

    private <T extends CriterionInstance> void removeListener(AdvancementHolder var0, String var1, Criterion<T> var2) {
        var2.trigger().removePlayerListener(this, new CriterionTrigger.a<T>(var2.triggerInstance(), var0, var1));
    }

    public void flushDirty(EntityPlayer var0) {
        if (this.isFirstPacket || !this.rootsToUpdate.isEmpty() || !this.progressChanged.isEmpty()) {
            HashMap<MinecraftKey, AdvancementProgress> var1 = new HashMap<MinecraftKey, AdvancementProgress>();
            HashSet<AdvancementHolder> var2 = new HashSet<AdvancementHolder>();
            HashSet<MinecraftKey> var3 = new HashSet<MinecraftKey>();
            for (AdvancementNode advancementNode : this.rootsToUpdate) {
                this.updateTreeVisibility(advancementNode, var2, var3);
            }
            this.rootsToUpdate.clear();
            for (AdvancementHolder advancementHolder : this.progressChanged) {
                if (!this.visible.contains(advancementHolder)) continue;
                var1.put(advancementHolder.id(), this.progress.get(advancementHolder));
            }
            this.progressChanged.clear();
            if (!(var1.isEmpty() && var2.isEmpty() && var3.isEmpty())) {
                var0.connection.send(new PacketPlayOutAdvancements(this.isFirstPacket, var2, var3, var1));
            }
        }
        this.isFirstPacket = false;
    }

    public void setSelectedTab(@Nullable AdvancementHolder var0) {
        AdvancementHolder var1 = this.lastSelectedTab;
        this.lastSelectedTab = var0 != null && var0.value().isRoot() && var0.value().display().isPresent() ? var0 : null;
        if (var1 != this.lastSelectedTab) {
            this.player.connection.send(new PacketPlayOutSelectAdvancementTab(this.lastSelectedTab == null ? null : this.lastSelectedTab.id()));
        }
    }

    public AdvancementProgress getOrStartProgress(AdvancementHolder var0) {
        AdvancementProgress var1 = this.progress.get(var0);
        if (var1 == null) {
            var1 = new AdvancementProgress();
            this.startProgress(var0, var1);
        }
        return var1;
    }

    private void startProgress(AdvancementHolder var0, AdvancementProgress var1) {
        var1.update(var0.value().requirements());
        this.progress.put(var0, var1);
    }

    private void updateTreeVisibility(AdvancementNode var02, Set<AdvancementHolder> var1, Set<MinecraftKey> var22) {
        AdvancementVisibilityEvaluator.evaluateVisibility(var02, var0 -> this.getOrStartProgress(var0.holder()).isDone(), (var2, var3) -> {
            AdvancementHolder var4 = var2.holder();
            if (var3) {
                if (this.visible.add(var4)) {
                    var1.add(var4);
                    if (this.progress.containsKey(var4)) {
                        this.progressChanged.add(var4);
                    }
                }
            } else if (this.visible.remove(var4)) {
                var22.add(var4.id());
            }
        });
    }

    record a(Map<MinecraftKey, AdvancementProgress> map) {
        public static final Codec<a> CODEC = Codec.unboundedMap(MinecraftKey.CODEC, AdvancementProgress.CODEC).xmap(a::new, a::map);

        public void forEach(BiConsumer<MinecraftKey, AdvancementProgress> var0) {
            this.map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach((? super T var1) -> var0.accept((MinecraftKey)var1.getKey(), (AdvancementProgress)var1.getValue()));
        }
    }
}

