/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().create();
    public Map<MinecraftKey, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.a registries;

    public AdvancementDataWorld(HolderLookup.a var0) {
        super(GSON, Registries.elementsDirPath(Registries.ADVANCEMENT));
        this.registries = var0;
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var0, IResourceManager var1, GameProfilerFiller var22) {
        RegistryOps var32 = this.registries.createSerializationContext(JsonOps.INSTANCE);
        ImmutableMap.Builder var4 = ImmutableMap.builder();
        var0.forEach((var2, var3) -> {
            try {
                Advancement var4 = (Advancement)Advancement.CODEC.parse((DynamicOps)var32, var3).getOrThrow(JsonParseException::new);
                this.validate((MinecraftKey)var2, var4);
                var4.put(var2, (Object)new AdvancementHolder((MinecraftKey)var2, var4));
            }
            catch (Exception var4) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", var2, (Object)var4.getMessage());
            }
        });
        this.advancements = var4.buildOrThrow();
        AdvancementTree var5 = new AdvancementTree();
        var5.addAll(this.advancements.values());
        for (AdvancementNode var7 : var5.roots()) {
            if (!var7.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(var7);
        }
        this.tree = var5;
    }

    private void validate(MinecraftKey var0, Advancement var12) {
        ProblemReporter.a var2 = new ProblemReporter.a();
        var12.validate(var2, this.registries.asGetterLookup());
        var2.getReport().ifPresent(var1 -> LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)var0, var1));
    }

    @Nullable
    public AdvancementHolder get(MinecraftKey var0) {
        return this.advancements.get(var0);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

