/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public class CustomFunctionData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MinecraftKey TICK_FUNCTION_TAG = MinecraftKey.withDefaultNamespace("tick");
    private static final MinecraftKey LOAD_FUNCTION_TAG = MinecraftKey.withDefaultNamespace("load");
    private final MinecraftServer server;
    private List<CommandFunction<CommandListenerWrapper>> ticking = ImmutableList.of();
    private boolean postReload;
    private CustomFunctionManager library;

    public CustomFunctionData(MinecraftServer var0, CustomFunctionManager var1) {
        this.server = var0;
        this.library = var1;
        this.postReload(var1);
    }

    public CommandDispatcher<CommandListenerWrapper> getDispatcher() {
        return this.server.getCommands().getDispatcher();
    }

    public void tick() {
        if (!this.server.tickRateManager().runsNormally()) {
            return;
        }
        if (this.postReload) {
            this.postReload = false;
            Collection<CommandFunction<CommandListenerWrapper>> var0 = this.library.getTag(LOAD_FUNCTION_TAG);
            this.executeTagFunctions(var0, LOAD_FUNCTION_TAG);
        }
        this.executeTagFunctions(this.ticking, TICK_FUNCTION_TAG);
    }

    private void executeTagFunctions(Collection<CommandFunction<CommandListenerWrapper>> var0, MinecraftKey var1) {
        this.server.getProfiler().push(var1::toString);
        for (CommandFunction<CommandListenerWrapper> var3 : var0) {
            this.execute(var3, this.getGameLoopSender());
        }
        this.server.getProfiler().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandFunction<CommandListenerWrapper> var0, CommandListenerWrapper var1) {
        GameProfilerFiller var22 = this.server.getProfiler();
        var22.push(() -> "function " + String.valueOf(var0.id()));
        try {
            InstantiatedFunction<CommandListenerWrapper> var3 = var0.instantiate(null, this.getDispatcher());
            net.minecraft.commands.CommandDispatcher.executeCommandInContext(var1, var2 -> ExecutionContext.queueInitialFunctionCall(var2, var3, var1, CommandResultCallback.EMPTY));
        }
        catch (FunctionInstantiationException var3) {
        }
        catch (Exception var3) {
            LOGGER.warn("Failed to execute function {}", (Object)var0.id(), (Object)var3);
        }
        finally {
            var22.pop();
        }
    }

    public void replaceLibrary(CustomFunctionManager var0) {
        this.library = var0;
        this.postReload(var0);
    }

    private void postReload(CustomFunctionManager var0) {
        this.ticking = ImmutableList.copyOf(var0.getTag(TICK_FUNCTION_TAG));
        this.postReload = true;
    }

    public CommandListenerWrapper getGameLoopSender() {
        return this.server.createCommandSourceStack().withPermission(2).withSuppressedOutput();
    }

    public Optional<CommandFunction<CommandListenerWrapper>> get(MinecraftKey var0) {
        return this.library.getFunction(var0);
    }

    public Collection<CommandFunction<CommandListenerWrapper>> getTag(MinecraftKey var0) {
        return this.library.getTag(var0);
    }

    public Iterable<MinecraftKey> getFunctionNames() {
        return this.library.getFunctions().keySet();
    }

    public Iterable<MinecraftKey> getTagNames() {
        return this.library.getAvailableTags();
    }
}

