/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;

public class CommandBan {
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.ban.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("ban").requires(var0 -> var0.hasPermission(3))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentProfile.gameProfile()).executes(var0 -> CommandBan.banPlayers((CommandListenerWrapper)var0.getSource(), ArgumentProfile.getGameProfiles((CommandContext<CommandListenerWrapper>)var0, "targets"), null))).then(net.minecraft.commands.CommandDispatcher.argument("reason", ArgumentChat.message()).executes(var0 -> CommandBan.banPlayers((CommandListenerWrapper)var0.getSource(), ArgumentProfile.getGameProfiles((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentChat.getMessage((CommandContext<CommandListenerWrapper>)var0, "reason"))))));
    }

    private static int banPlayers(CommandListenerWrapper var0, Collection<GameProfile> var1, @Nullable IChatBaseComponent var2) throws CommandSyntaxException {
        GameProfileBanList var3 = var0.getServer().getPlayerList().getBans();
        int var4 = 0;
        for (GameProfile var6 : var1) {
            if (var3.isBanned(var6)) continue;
            GameProfileBanEntry var7 = new GameProfileBanEntry(var6, null, var0.getTextName(), null, var2 == null ? null : var2.getString());
            var3.add(var7);
            ++var4;
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.ban.success", IChatBaseComponent.literal(var6.getName()), var7.getReason()), true);
            EntityPlayer var8 = var0.getServer().getPlayerList().getPlayer(var6.getId());
            if (var8 == null) continue;
            var8.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.banned"));
        }
        if (var4 == 0) {
            throw ERROR_ALREADY_BANNED.create();
        }
        return var4;
    }
}

