/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.item.ItemStack;

public class CommandClear {
    private static final DynamicCommandExceptionType ERROR_SINGLE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("clear.failed.single", var0));
    private static final DynamicCommandExceptionType ERROR_MULTIPLE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("clear.failed.multiple", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clear").requires(var0 -> var0.hasPermission(2))).executes(var02 -> CommandClear.clearUnlimited((CommandListenerWrapper)var02.getSource(), Collections.singleton(((CommandListenerWrapper)var02.getSource()).getPlayerOrException()), var0 -> true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var02 -> CommandClear.clearUnlimited((CommandListenerWrapper)var02.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var02, "targets"), var0 -> true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item", ArgumentItemPredicate.itemPredicate(var1)).executes(var0 -> CommandClear.clearUnlimited((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentItemPredicate.getItemPredicate((CommandContext<CommandListenerWrapper>)var0, "item")))).then(net.minecraft.commands.CommandDispatcher.argument("maxCount", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandClear.clearInventory((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentItemPredicate.getItemPredicate((CommandContext<CommandListenerWrapper>)var0, "item"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"maxCount")))))));
    }

    private static int clearUnlimited(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Predicate<ItemStack> var2) throws CommandSyntaxException {
        return CommandClear.clearInventory(var0, var1, var2, -1);
    }

    private static int clearInventory(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Predicate<ItemStack> var2, int var3) throws CommandSyntaxException {
        int var4 = 0;
        for (EntityPlayer var6 : var1) {
            var4 += var6.getInventory().clearOrCountMatchingItems(var2, var3, var6.inventoryMenu.getCraftSlots());
            var6.containerMenu.broadcastChanges();
            var6.inventoryMenu.slotsChanged(var6.getInventory());
        }
        if (var4 == 0) {
            if (var1.size() == 1) {
                throw ERROR_SINGLE.create((Object)var1.iterator().next().getName());
            }
            throw ERROR_MULTIPLE.create((Object)var1.size());
        }
        int var5 = var4;
        if (var3 == 0) {
            if (var1.size() == 1) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.clear.test.single", var5, ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
            } else {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.clear.test.multiple", var5, var1.size()), true);
            }
        } else if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.clear.success.single", var5, ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.clear.success.multiple", var5, var1.size()), true);
        }
        return var4;
    }
}

