/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_LOOT_TABLE = (var0, var1) -> {
        ReloadableServerRegistries.b var2 = ((CommandListenerWrapper)var0.getSource()).getServer().reloadableRegistries();
        return ICompletionProvider.suggestResource(var2.getKeys(Registries.LOOT_TABLE), var1);
    };
    private static final DynamicCommandExceptionType ERROR_NO_HELD_ITEMS = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.drop.no_held_items", var0));
    private static final DynamicCommandExceptionType ERROR_NO_LOOT_TABLE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.drop.no_loot_table", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register(CommandLoot.addTargets((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("loot").requires(var0 -> var0.hasPermission(2)), (var12, var2) -> var12.then(net.minecraft.commands.CommandDispatcher.literal("fish").then(net.minecraft.commands.CommandDispatcher.argument("loot_table", ResourceOrIdArgument.lootTable(var1)).suggests(SUGGEST_LOOT_TABLE).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var1 -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)var1, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)var1, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), ItemStack.EMPTY, var2))).then(net.minecraft.commands.CommandDispatcher.argument("tool", ArgumentItemStack.item(var1)).executes(var1 -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)var1, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)var1, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), ArgumentItemStack.getItem(var1, "tool").createItemStack(1, false), var2)))).then(net.minecraft.commands.CommandDispatcher.literal("mainhand").executes(var1 -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)var1, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)var1, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)var1.getSource(), EnumItemSlot.MAINHAND), var2)))).then(net.minecraft.commands.CommandDispatcher.literal("offhand").executes(var1 -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)var1, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)var1, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)var1.getSource(), EnumItemSlot.OFFHAND), var2)))))).then(net.minecraft.commands.CommandDispatcher.literal("loot").then(net.minecraft.commands.CommandDispatcher.argument("loot_table", ResourceOrIdArgument.lootTable(var1)).suggests(SUGGEST_LOOT_TABLE).executes(var1 -> CommandLoot.dropChestLoot((CommandContext<CommandListenerWrapper>)var1, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)var1, "loot_table"), var2)))).then(net.minecraft.commands.CommandDispatcher.literal("kill").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.entity()).executes(var1 -> CommandLoot.dropKillLoot((CommandContext<CommandListenerWrapper>)var1, ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var1, "target"), var2)))).then(net.minecraft.commands.CommandDispatcher.literal("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var1 -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)var1, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), ItemStack.EMPTY, var2))).then(net.minecraft.commands.CommandDispatcher.argument("tool", ArgumentItemStack.item(var1)).executes(var1 -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)var1, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), ArgumentItemStack.getItem(var1, "tool").createItemStack(1, false), var2)))).then(net.minecraft.commands.CommandDispatcher.literal("mainhand").executes(var1 -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)var1, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)var1.getSource(), EnumItemSlot.MAINHAND), var2)))).then(net.minecraft.commands.CommandDispatcher.literal("offhand").executes(var1 -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)var1, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)var1.getSource(), EnumItemSlot.OFFHAND), var2)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T addTargets(T var02, c var12) {
        return (T)var02.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("replace").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("entities", ArgumentEntity.entities()).then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()), (var0, var1, var2) -> CommandLoot.entityReplace(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "entities"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), var1.size(), var1, var2)).then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)0)), (var0, var1, var2) -> CommandLoot.entityReplace(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "entities"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), var1, var2))))))).then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("targetPos", ArgumentPosition.blockPos()).then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()), (var0, var1, var2) -> CommandLoot.blockReplace((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "targetPos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), var1.size(), var1, var2)).then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)0)), (var0, var1, var2) -> CommandLoot.blockReplace((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "targetPos"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), var1, var2))))))).then(net.minecraft.commands.CommandDispatcher.literal("insert").then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("targetPos", ArgumentPosition.blockPos()), (var0, var1, var2) -> CommandLoot.blockDistribute((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "targetPos"), var1, var2)))).then(net.minecraft.commands.CommandDispatcher.literal("give").then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("players", ArgumentEntity.players()), (var0, var1, var2) -> CommandLoot.playerGive(ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "players"), var1, var2)))).then(net.minecraft.commands.CommandDispatcher.literal("spawn").then(var12.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("targetPos", ArgumentVec3.vec3()), (var0, var1, var2) -> CommandLoot.dropInWorld((CommandListenerWrapper)var0.getSource(), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "targetPos"), var1, var2))));
    }

    private static IInventory getContainer(CommandListenerWrapper var0, BlockPosition var1) throws CommandSyntaxException {
        TileEntity var2 = var0.getLevel().getBlockEntity(var1);
        if (!(var2 instanceof IInventory)) {
            throw ItemCommands.ERROR_TARGET_NOT_A_CONTAINER.create((Object)var1.getX(), (Object)var1.getY(), (Object)var1.getZ());
        }
        return (IInventory)((Object)var2);
    }

    private static int blockDistribute(CommandListenerWrapper var0, BlockPosition var1, List<ItemStack> var2, a var3) throws CommandSyntaxException {
        IInventory var4 = CommandLoot.getContainer(var0, var1);
        ArrayList var5 = Lists.newArrayListWithCapacity((int)var2.size());
        for (ItemStack var7 : var2) {
            if (!CommandLoot.distributeToContainer(var4, var7.copy())) continue;
            var4.setChanged();
            var5.add(var7);
        }
        var3.accept(var5);
        return var5.size();
    }

    private static boolean distributeToContainer(IInventory var0, ItemStack var1) {
        boolean var2 = false;
        for (int var3 = 0; var3 < var0.getContainerSize() && !var1.isEmpty(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (!var0.canPlaceItem(var3, var1)) continue;
            if (var4.isEmpty()) {
                var0.setItem(var3, var1);
                var2 = true;
                break;
            }
            if (!CommandLoot.canMergeItems(var4, var1)) continue;
            int var5 = var1.getMaxStackSize() - var4.getCount();
            int var6 = Math.min(var1.getCount(), var5);
            var1.shrink(var6);
            var4.grow(var6);
            var2 = true;
        }
        return var2;
    }

    private static int blockReplace(CommandListenerWrapper var0, BlockPosition var1, int var2, int var3, List<ItemStack> var4, a var5) throws CommandSyntaxException {
        IInventory var6 = CommandLoot.getContainer(var0, var1);
        int var7 = var6.getContainerSize();
        if (var2 < 0 || var2 >= var7) {
            throw ItemCommands.ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)var2);
        }
        ArrayList var8 = Lists.newArrayListWithCapacity((int)var4.size());
        for (int var9 = 0; var9 < var3; ++var9) {
            ItemStack var11;
            int var10 = var2 + var9;
            ItemStack itemStack = var11 = var9 < var4.size() ? var4.get(var9) : ItemStack.EMPTY;
            if (!var6.canPlaceItem(var10, var11)) continue;
            var6.setItem(var10, var11);
            var8.add(var11);
        }
        var5.accept(var8);
        return var8.size();
    }

    private static boolean canMergeItems(ItemStack var0, ItemStack var1) {
        return var0.getCount() <= var0.getMaxStackSize() && ItemStack.isSameItemSameComponents(var0, var1);
    }

    private static int playerGive(Collection<EntityPlayer> var0, List<ItemStack> var1, a var2) throws CommandSyntaxException {
        ArrayList var3 = Lists.newArrayListWithCapacity((int)var1.size());
        for (ItemStack var5 : var1) {
            for (EntityPlayer var7 : var0) {
                if (!var7.getInventory().add(var5.copy())) continue;
                var3.add(var5);
            }
        }
        var2.accept(var3);
        return var3.size();
    }

    private static void setSlots(Entity var0, List<ItemStack> var1, int var2, int var3, List<ItemStack> var4) {
        for (int var5 = 0; var5 < var3; ++var5) {
            ItemStack var6 = var5 < var1.size() ? var1.get(var5) : ItemStack.EMPTY;
            SlotAccess var7 = var0.getSlot(var2 + var5);
            if (var7 == SlotAccess.NULL || !var7.set(var6.copy())) continue;
            var4.add(var6);
        }
    }

    private static int entityReplace(Collection<? extends Entity> var0, int var1, int var2, List<ItemStack> var3, a var4) throws CommandSyntaxException {
        ArrayList var5 = Lists.newArrayListWithCapacity((int)var3.size());
        for (Entity entity : var0) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer var8 = (EntityPlayer)entity;
                CommandLoot.setSlots(entity, var3, var1, var2, var5);
                var8.containerMenu.broadcastChanges();
                continue;
            }
            CommandLoot.setSlots(entity, var3, var1, var2, var5);
        }
        var4.accept(var5);
        return var5.size();
    }

    private static int dropInWorld(CommandListenerWrapper var0, Vec3D var1, List<ItemStack> var22, a var3) throws CommandSyntaxException {
        WorldServer var4 = var0.getLevel();
        var22.forEach(var2 -> {
            EntityItem var3 = new EntityItem(var4, var1.x, var1.y, var1.z, var2.copy());
            var3.setDefaultPickUpDelay();
            var4.addFreshEntity(var3);
        });
        var3.accept(var22);
        return var22.size();
    }

    private static void callback(CommandListenerWrapper var0, List<ItemStack> var1) {
        if (var1.size() == 1) {
            ItemStack var2 = var1.get(0);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.single", var2.getCount(), var2.getDisplayName()), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.multiple", var1.size()), false);
        }
    }

    private static void callback(CommandListenerWrapper var0, List<ItemStack> var1, ResourceKey<LootTable> var2) {
        if (var1.size() == 1) {
            ItemStack var3 = var1.get(0);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.single_with_table", var3.getCount(), var3.getDisplayName(), IChatBaseComponent.translationArg(var2.location())), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.multiple_with_table", var1.size(), IChatBaseComponent.translationArg(var2.location())), false);
        }
    }

    private static ItemStack getSourceHandItem(CommandListenerWrapper var0, EnumItemSlot var1) throws CommandSyntaxException {
        Entity var2 = var0.getEntityOrException();
        if (var2 instanceof EntityLiving) {
            return ((EntityLiving)var2).getItemBySlot(var1);
        }
        throw ERROR_NO_HELD_ITEMS.create((Object)var2.getDisplayName());
    }

    private static int dropBlockLoot(CommandContext<CommandListenerWrapper> var0, BlockPosition var1, ItemStack var22, b var3) throws CommandSyntaxException {
        CommandListenerWrapper var4 = (CommandListenerWrapper)var0.getSource();
        WorldServer var5 = var4.getLevel();
        IBlockData var6 = var5.getBlockState(var1);
        TileEntity var7 = var5.getBlockEntity(var1);
        LootParams.a var8 = new LootParams.a(var5).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var1)).withParameter(LootContextParameters.BLOCK_STATE, var6).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, var7).withOptionalParameter(LootContextParameters.THIS_ENTITY, var4.getEntity()).withParameter(LootContextParameters.TOOL, var22);
        List<ItemStack> var9 = var6.getDrops(var8);
        return var3.accept(var0, var9, var2 -> CommandLoot.callback(var4, var2, var6.getBlock().getLootTable()));
    }

    private static int dropKillLoot(CommandContext<CommandListenerWrapper> var0, Entity var1, b var22) throws CommandSyntaxException {
        Object var7;
        if (!(var1 instanceof EntityLiving)) {
            throw ERROR_NO_LOOT_TABLE.create((Object)var1.getDisplayName());
        }
        ResourceKey<LootTable> var3 = ((EntityLiving)var1).getLootTable();
        CommandListenerWrapper var4 = (CommandListenerWrapper)var0.getSource();
        LootParams.a var5 = new LootParams.a(var4.getLevel());
        Entity var6 = var4.getEntity();
        if (var6 instanceof EntityHuman) {
            var7 = (EntityHuman)var6;
            var5.withParameter(LootContextParameters.LAST_DAMAGE_PLAYER, var7);
        }
        var5.withParameter(LootContextParameters.DAMAGE_SOURCE, var1.damageSources().magic());
        var5.withOptionalParameter(LootContextParameters.DIRECT_ATTACKING_ENTITY, var6);
        var5.withOptionalParameter(LootContextParameters.ATTACKING_ENTITY, var6);
        var5.withParameter(LootContextParameters.THIS_ENTITY, var1);
        var5.withParameter(LootContextParameters.ORIGIN, var4.getPosition());
        var7 = var5.create(LootContextParameterSets.ENTITY);
        LootTable var8 = var4.getServer().reloadableRegistries().getLootTable(var3);
        ObjectArrayList<ItemStack> var9 = var8.getRandomItems((LootParams)var7);
        return var22.accept(var0, (List<ItemStack>)var9, var2 -> CommandLoot.callback(var4, var2, var3));
    }

    private static int dropChestLoot(CommandContext<CommandListenerWrapper> var0, Holder<LootTable> var1, b var2) throws CommandSyntaxException {
        CommandListenerWrapper var3 = (CommandListenerWrapper)var0.getSource();
        LootParams var4 = new LootParams.a(var3.getLevel()).withOptionalParameter(LootContextParameters.THIS_ENTITY, var3.getEntity()).withParameter(LootContextParameters.ORIGIN, var3.getPosition()).create(LootContextParameterSets.CHEST);
        return CommandLoot.drop(var0, var1, var4, var2);
    }

    private static int dropFishingLoot(CommandContext<CommandListenerWrapper> var0, Holder<LootTable> var1, BlockPosition var2, ItemStack var3, b var4) throws CommandSyntaxException {
        CommandListenerWrapper var5 = (CommandListenerWrapper)var0.getSource();
        LootParams var6 = new LootParams.a(var5.getLevel()).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var2)).withParameter(LootContextParameters.TOOL, var3).withOptionalParameter(LootContextParameters.THIS_ENTITY, var5.getEntity()).create(LootContextParameterSets.FISHING);
        return CommandLoot.drop(var0, var1, var6, var4);
    }

    private static int drop(CommandContext<CommandListenerWrapper> var0, Holder<LootTable> var12, LootParams var2, b var3) throws CommandSyntaxException {
        CommandListenerWrapper var4 = (CommandListenerWrapper)var0.getSource();
        ObjectArrayList<ItemStack> var5 = var12.value().getRandomItems(var2);
        return var3.accept(var0, (List<ItemStack>)var5, var1 -> CommandLoot.callback(var4, var1));
    }

    @FunctionalInterface
    static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

