/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;

public class CommandWhitelist {
    private static final SimpleCommandExceptionType ERROR_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_DISABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.whitelist.remove.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("whitelist").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.literal("on").executes(var0 -> CommandWhitelist.enableWhitelist((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("off").executes(var0 -> CommandWhitelist.disableWhitelist((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandWhitelist.showList((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentProfile.gameProfile()).suggests((var02, var12) -> {
            PlayerList var2 = ((CommandListenerWrapper)var02.getSource()).getServer().getPlayerList();
            return ICompletionProvider.suggest(var2.getPlayers().stream().filter(var1 -> !var2.getWhiteList().isWhiteListed(var1.getGameProfile())).map(var0 -> var0.getGameProfile().getName()), var12);
        }).executes(var0 -> CommandWhitelist.addPlayers((CommandListenerWrapper)var0.getSource(), ArgumentProfile.getGameProfiles((CommandContext<CommandListenerWrapper>)var0, "targets")))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentProfile.gameProfile()).suggests((var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getWhiteListNames(), var1)).executes(var0 -> CommandWhitelist.removePlayers((CommandListenerWrapper)var0.getSource(), ArgumentProfile.getGameProfiles((CommandContext<CommandListenerWrapper>)var0, "targets")))))).then(net.minecraft.commands.CommandDispatcher.literal("reload").executes(var0 -> CommandWhitelist.reload((CommandListenerWrapper)var0.getSource()))));
    }

    private static int reload(CommandListenerWrapper var0) {
        var0.getServer().getPlayerList().reloadWhiteList();
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.reloaded"), true);
        var0.getServer().kickUnlistedPlayers(var0);
        return 1;
    }

    private static int addPlayers(CommandListenerWrapper var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        WhiteList var2 = var0.getServer().getPlayerList().getWhiteList();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (var2.isWhiteListed(var5)) continue;
            WhiteListEntry var6 = new WhiteListEntry(var5);
            var2.add(var6);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.add.success", IChatBaseComponent.literal(var5.getName())), true);
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return var3;
    }

    private static int removePlayers(CommandListenerWrapper var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        WhiteList var2 = var0.getServer().getPlayerList().getWhiteList();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (!var2.isWhiteListed(var5)) continue;
            WhiteListEntry var6 = new WhiteListEntry(var5);
            var2.remove(var6);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.remove.success", IChatBaseComponent.literal(var5.getName())), true);
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        var0.getServer().kickUnlistedPlayers(var0);
        return var3;
    }

    private static int enableWhitelist(CommandListenerWrapper var0) throws CommandSyntaxException {
        PlayerList var1 = var0.getServer().getPlayerList();
        if (var1.isUsingWhitelist()) {
            throw ERROR_ALREADY_ENABLED.create();
        }
        var1.setUsingWhiteList(true);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.enabled"), true);
        var0.getServer().kickUnlistedPlayers(var0);
        return 1;
    }

    private static int disableWhitelist(CommandListenerWrapper var0) throws CommandSyntaxException {
        PlayerList var1 = var0.getServer().getPlayerList();
        if (!var1.isUsingWhitelist()) {
            throw ERROR_ALREADY_DISABLED.create();
        }
        var1.setUsingWhiteList(false);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.disabled"), true);
        return 1;
    }

    private static int showList(CommandListenerWrapper var0) {
        String[] var1 = var0.getServer().getPlayerList().getWhiteListNames();
        if (var1.length == 0) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.none"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.whitelist.list", var1.length, String.join((CharSequence)", ", var1)), false);
        }
        return var1.length;
    }
}

