/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;

public class DamageCommand {
    private static final SimpleCommandExceptionType ERROR_INVULNERABLE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.damage.invulnerable"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("damage").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.entity()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amount", FloatArgumentType.floatArg((float)0.0f)).executes(var0 -> DamageCommand.damage((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), FloatArgumentType.getFloat((CommandContext)var0, (String)"amount"), ((CommandListenerWrapper)var0.getSource()).getLevel().damageSources().generic()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("damageType", ResourceArgument.resource(var1, Registries.DAMAGE_TYPE)).executes(var0 -> DamageCommand.damage((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), FloatArgumentType.getFloat((CommandContext)var0, (String)"amount"), new DamageSource(ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "damageType", Registries.DAMAGE_TYPE))))).then(net.minecraft.commands.CommandDispatcher.literal("at").then(net.minecraft.commands.CommandDispatcher.argument("location", ArgumentVec3.vec3()).executes(var0 -> DamageCommand.damage((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), FloatArgumentType.getFloat((CommandContext)var0, (String)"amount"), new DamageSource(ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "damageType", Registries.DAMAGE_TYPE), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "location"))))))).then(net.minecraft.commands.CommandDispatcher.literal("by").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("entity", ArgumentEntity.entity()).executes(var0 -> DamageCommand.damage((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), FloatArgumentType.getFloat((CommandContext)var0, (String)"amount"), new DamageSource(ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "damageType", Registries.DAMAGE_TYPE), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "entity"))))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("cause", ArgumentEntity.entity()).executes(var0 -> DamageCommand.damage((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "target"), FloatArgumentType.getFloat((CommandContext)var0, (String)"amount"), new DamageSource(ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "damageType", Registries.DAMAGE_TYPE), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "entity"), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "cause"))))))))))));
    }

    private static int damage(CommandListenerWrapper var0, Entity var1, float var2, DamageSource var3) throws CommandSyntaxException {
        if (var1.hurt(var3, var2)) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.damage.success", Float.valueOf(var2), var1.getDisplayName()), true);
            return 1;
        }
        throw ERROR_INVULNERABLE.create();
    }
}

