/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistryCustom;
import org.slf4j.Logger;

public abstract class PropertyManager<T extends PropertyManager<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Properties properties;

    public PropertyManager(Properties var0) {
        this.properties = var0;
    }

    public static Properties loadFromFile(Path var0) {
        Properties properties;
        block16: {
            InputStream var1 = Files.newInputStream(var0, new OpenOption[0]);
            try {
                CharsetDecoder var2 = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                Properties var3 = new Properties();
                var3.load(new InputStreamReader(var1, var2));
                properties = var3;
                if (var1 == null) break block16;
            }
            catch (Throwable var2) {
                try {
                    if (var1 != null) {
                        try {
                            var1.close();
                        }
                        catch (Throwable var3) {
                            var2.addSuppressed(var3);
                        }
                    }
                    throw var2;
                }
                catch (CharacterCodingException var12) {
                    Properties properties2;
                    block17: {
                        LOGGER.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)var0);
                        BufferedReader var22 = Files.newBufferedReader(var0, StandardCharsets.ISO_8859_1);
                        try {
                            Properties var3 = new Properties();
                            var3.load(var22);
                            properties2 = var3;
                            if (var22 == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (var22 != null) {
                                    try {
                                        ((Reader)var22).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException var13) {
                                LOGGER.error("Failed to load properties from file: {}", (Object)var0, (Object)var13);
                                return new Properties();
                            }
                        }
                        ((Reader)var22).close();
                    }
                    return properties2;
                }
            }
            var1.close();
        }
        return properties;
    }

    public void store(Path var0) {
        try (BufferedWriter var1 = Files.newBufferedWriter(var0, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.properties.store(var1, "Minecraft server properties");
        }
        catch (IOException var12) {
            LOGGER.error("Failed to store properties to file: {}", (Object)var0);
        }
    }

    private static <V extends Number> Function<String, V> wrapNumberDeserializer(Function<String, V> var0) {
        return var1 -> {
            try {
                return (Number)var0.apply((String)var1);
            }
            catch (NumberFormatException var2) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> dispatchNumberOrString(IntFunction<V> var0, Function<String, V> var1) {
        return var2 -> {
            try {
                return var0.apply(Integer.parseInt(var2));
            }
            catch (NumberFormatException var3) {
                return var1.apply((String)var2);
            }
        };
    }

    @Nullable
    private String getStringRaw(String var0) {
        return (String)this.properties.get(var0);
    }

    @Nullable
    protected <V> V getLegacy(String var0, Function<String, V> var1) {
        String var2 = this.getStringRaw(var0);
        if (var2 == null) {
            return null;
        }
        this.properties.remove(var0);
        return var1.apply(var2);
    }

    protected <V> V get(String var0, Function<String, V> var1, Function<V, String> var2, V var3) {
        String var4 = this.getStringRaw(var0);
        Object var5 = MoreObjects.firstNonNull(var4 != null ? var1.apply(var4) : null, var3);
        this.properties.put(var0, var2.apply(var5));
        return (V)var5;
    }

    protected <V> EditableProperty<V> getMutable(String var0, Function<String, V> var1, Function<V, String> var2, V var3) {
        String var4 = this.getStringRaw(var0);
        Object var5 = MoreObjects.firstNonNull(var4 != null ? var1.apply(var4) : null, var3);
        this.properties.put(var0, var2.apply(var5));
        return new EditableProperty(var0, var5, var2);
    }

    protected <V> V get(String var0, Function<String, V> var1, UnaryOperator<V> var22, Function<V, String> var3, V var4) {
        return (V)this.get(var0, var2 -> {
            Object var3 = var1.apply((String)var2);
            return var3 != null ? var22.apply(var3) : null;
        }, var3, var4);
    }

    protected <V> V get(String var0, Function<String, V> var1, V var2) {
        return (V)this.get(var0, var1, Objects::toString, var2);
    }

    protected <V> EditableProperty<V> getMutable(String var0, Function<String, V> var1, V var2) {
        return this.getMutable(var0, var1, Objects::toString, var2);
    }

    protected String get(String var0, String var1) {
        return this.get(var0, Function.identity(), Function.identity(), var1);
    }

    @Nullable
    protected String getLegacyString(String var0) {
        return (String)this.getLegacy(var0, Function.identity());
    }

    protected int get(String var0, int var1) {
        return this.get(var0, PropertyManager.wrapNumberDeserializer(Integer::parseInt), Integer.valueOf(var1));
    }

    protected EditableProperty<Integer> getMutable(String var0, int var1) {
        return this.getMutable(var0, PropertyManager.wrapNumberDeserializer(Integer::parseInt), var1);
    }

    protected int get(String var0, UnaryOperator<Integer> var1, int var2) {
        return this.get(var0, PropertyManager.wrapNumberDeserializer(Integer::parseInt), var1, Objects::toString, var2);
    }

    protected long get(String var0, long var1) {
        return this.get(var0, PropertyManager.wrapNumberDeserializer(Long::parseLong), var1);
    }

    protected boolean get(String var0, boolean var1) {
        return this.get(var0, Boolean::valueOf, var1);
    }

    protected EditableProperty<Boolean> getMutable(String var0, boolean var1) {
        return this.getMutable(var0, Boolean::valueOf, var1);
    }

    @Nullable
    protected Boolean getLegacyBoolean(String var0) {
        return this.getLegacy(var0, Boolean::valueOf);
    }

    protected Properties cloneProperties() {
        Properties var0 = new Properties();
        var0.putAll((Map<?, ?>)this.properties);
        return var0;
    }

    protected abstract T reload(IRegistryCustom var1, Properties var2);

    public class EditableProperty<V>
    implements Supplier<V> {
        private final String key;
        private final V value;
        private final Function<V, String> serializer;

        EditableProperty(String var1, Object var2, Function var3) {
            this.key = var1;
            this.value = var2;
            this.serializer = var3;
        }

        @Override
        public V get() {
            return this.value;
        }

        public T update(IRegistryCustom var0, V var1) {
            Properties var2 = PropertyManager.this.cloneProperties();
            var2.put(this.key, this.serializer.apply(var1));
            return PropertyManager.this.reload(var0, var2);
        }
    }
}

