/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private static final double TOLERANCE_LEVEL_POSITION = 7.62939453125E-6;
    public static final int FORCED_POS_UPDATE_PERIOD = 60;
    private static final int FORCED_TELEPORT_PERIOD = 400;
    private final WorldServer level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final Consumer<Packet<?>> broadcast;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private int lastSentYRot;
    private int lastSentXRot;
    private int lastSentYHeadRot;
    private Vec3D lastSentMovement;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers = Collections.emptyList();
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<DataWatcher.c<?>> trackedDataValues;

    public EntityTrackerEntry(WorldServer var0, Entity var1, int var2, boolean var3, Consumer<Packet<?>> var4) {
        this.level = var0;
        this.broadcast = var4;
        this.entity = var1;
        this.updateInterval = var2;
        this.trackDelta = var3;
        this.positionCodec.setBase(var1.trackingPosition());
        this.lastSentMovement = var1.getDeltaMovement();
        this.lastSentYRot = MathHelper.floor(var1.getYRot() * 256.0f / 360.0f);
        this.lastSentXRot = MathHelper.floor(var1.getXRot() * 256.0f / 360.0f);
        this.lastSentYHeadRot = MathHelper.floor(var1.getYHeadRot() * 256.0f / 360.0f);
        this.wasOnGround = var1.onGround();
        this.trackedDataValues = var1.getEntityData().getNonDefaultValues();
    }

    public void sendChanges() {
        Object var3;
        Entity entity;
        List<Entity> var02 = this.entity.getPassengers();
        if (!var02.equals(this.lastPassengers)) {
            this.broadcast.accept(new PacketPlayOutMount(this.entity));
            EntityTrackerEntry.removedPassengers(var02, this.lastPassengers).forEach(var0 -> {
                if (var0 instanceof EntityPlayer) {
                    EntityPlayer var1 = (EntityPlayer)var0;
                    var1.connection.teleport(var1.getX(), var1.getY(), var1.getZ(), var1.getYRot(), var1.getXRot());
                }
            });
            this.lastPassengers = var02;
        }
        if ((entity = this.entity) instanceof EntityItemFrame) {
            EntityItemFrame var1 = (EntityItemFrame)entity;
            if (this.tickCount % 10 == 0) {
                WorldMap var4;
                ItemStack var2 = var1.getItem();
                if (var2.getItem() instanceof ItemWorldMap && (var4 = ItemWorldMap.getSavedData((MapId)(var3 = var2.get(DataComponents.MAP_ID)), (World)this.level)) != null) {
                    for (EntityPlayer var6 : this.level.players()) {
                        var4.tickCarriedBy(var6, var2);
                        Packet<?> var7 = var4.getUpdatePacket((MapId)var3, var6);
                        if (var7 == null) continue;
                        var6.connection.send(var7);
                    }
                }
                this.sendDirtyEntityData();
            }
        }
        if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            int var1;
            if (this.entity.isPassenger()) {
                boolean var32;
                var1 = MathHelper.floor(this.entity.getYRot() * 256.0f / 360.0f);
                int var2 = MathHelper.floor(this.entity.getXRot() * 256.0f / 360.0f);
                boolean bl = var32 = Math.abs(var1 - this.lastSentYRot) >= 1 || Math.abs(var2 - this.lastSentXRot) >= 1;
                if (var32) {
                    this.broadcast.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), (byte)var1, (byte)var2, this.entity.onGround()));
                    this.lastSentYRot = var1;
                    this.lastSentXRot = var2;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                Vec3D var17;
                double var18;
                boolean var16;
                ++this.teleportDelay;
                var1 = MathHelper.floor(this.entity.getYRot() * 256.0f / 360.0f);
                int var2 = MathHelper.floor(this.entity.getXRot() * 256.0f / 360.0f);
                var3 = this.entity.trackingPosition();
                boolean var4 = this.positionCodec.delta((Vec3D)var3).lengthSqr() >= 7.62939453125E-6;
                Packet<PacketListenerPlayOut> var5 = null;
                boolean var6 = var4 || this.tickCount % 60 == 0;
                boolean var7 = Math.abs(var1 - this.lastSentYRot) >= 1 || Math.abs(var2 - this.lastSentXRot) >= 1;
                boolean var8 = false;
                boolean var9 = false;
                long var10 = this.positionCodec.encodeX((Vec3D)var3);
                long var12 = this.positionCodec.encodeY((Vec3D)var3);
                long var14 = this.positionCodec.encodeZ((Vec3D)var3);
                boolean bl = var16 = var10 < -32768L || var10 > 32767L || var12 < -32768L || var12 > 32767L || var14 < -32768L || var14 > 32767L;
                if (var16 || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.onGround()) {
                    this.wasOnGround = this.entity.onGround();
                    this.teleportDelay = 0;
                    var5 = new PacketPlayOutEntityTeleport(this.entity);
                    var8 = true;
                    var9 = true;
                } else if (var6 && var7 || this.entity instanceof EntityArrow) {
                    var5 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.entity.getId(), (short)var10, (short)var12, (short)var14, (byte)var1, (byte)var2, this.entity.onGround());
                    var8 = true;
                    var9 = true;
                } else if (var6) {
                    var5 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.entity.getId(), (short)var10, (short)var12, (short)var14, this.entity.onGround());
                    var8 = true;
                } else if (var7) {
                    var5 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), (byte)var1, (byte)var2, this.entity.onGround());
                    var9 = true;
                }
                if ((this.trackDelta || this.entity.hasImpulse || this.entity instanceof EntityLiving && ((EntityLiving)this.entity).isFallFlying()) && this.tickCount > 0 && ((var18 = (var17 = this.entity.getDeltaMovement()).distanceToSqr(this.lastSentMovement)) > 1.0E-7 || var18 > 0.0 && var17.lengthSqr() == 0.0)) {
                    this.lastSentMovement = var17;
                    Entity entity2 = this.entity;
                    if (entity2 instanceof EntityFireball) {
                        EntityFireball var20 = (EntityFireball)entity2;
                        this.broadcast.accept(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement), new ClientboundProjectilePowerPacket(var20.getId(), var20.accelerationPower))));
                    } else {
                        this.broadcast.accept(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement));
                    }
                }
                if (var5 != null) {
                    this.broadcast.accept(var5);
                }
                this.sendDirtyEntityData();
                if (var8) {
                    this.positionCodec.setBase((Vec3D)var3);
                }
                if (var9) {
                    this.lastSentYRot = var1;
                    this.lastSentXRot = var2;
                }
                this.wasRiding = false;
            }
            var1 = MathHelper.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
            if (Math.abs(var1 - this.lastSentYHeadRot) >= 1) {
                this.broadcast.accept(new PacketPlayOutEntityHeadRotation(this.entity, (byte)var1));
                this.lastSentYHeadRot = var1;
            }
            this.entity.hasImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            this.entity.hurtMarked = false;
            this.broadcastAndSend(new PacketPlayOutEntityVelocity(this.entity));
        }
    }

    private static Stream<Entity> removedPassengers(List<Entity> var0, List<Entity> var12) {
        return var12.stream().filter(var1 -> !var0.contains(var1));
    }

    public void removePairing(EntityPlayer var0) {
        this.entity.stopSeenByPlayer(var0);
        var0.connection.send(new PacketPlayOutEntityDestroy(this.entity.getId()));
    }

    public void addPairing(EntityPlayer var0) {
        ArrayList<Packet<? super PacketListenerPlayOut>> var1 = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        this.sendPairingData(var0, var1::add);
        var0.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)var1));
        this.entity.startSeenByPlayer(var0);
    }

    public void sendPairingData(EntityPlayer var0, Consumer<Packet<PacketListenerPlayOut>> var1) {
        Object object;
        Object var4;
        if (this.entity.isRemoved()) {
            LOGGER.warn("Fetching packet for removed entity {}", (Object)this.entity);
        }
        Packet<PacketListenerPlayOut> var2 = this.entity.getAddEntityPacket(this);
        var1.accept(var2);
        if (this.trackedDataValues != null) {
            var1.accept(new PacketPlayOutEntityMetadata(this.entity.getId(), this.trackedDataValues));
        }
        boolean var3 = this.trackDelta;
        if (this.entity instanceof EntityLiving) {
            var4 = ((EntityLiving)this.entity).getAttributes().getSyncableAttributes();
            if (!var4.isEmpty()) {
                var1.accept(new PacketPlayOutUpdateAttributes(this.entity.getId(), (Collection<AttributeModifiable>)var4));
            }
            if (((EntityLiving)this.entity).isFallFlying()) {
                var3 = true;
            }
        }
        if (var3 && !(this.entity instanceof EntityLiving)) {
            var1.accept(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement));
        }
        if (this.entity instanceof EntityLiving) {
            var4 = Lists.newArrayList();
            object = EnumItemSlot.values();
            int n2 = ((EnumItemSlot[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                EnumItemSlot var8 = object[i2];
                ItemStack var9 = ((EntityLiving)this.entity).getItemBySlot(var8);
                if (var9.isEmpty()) continue;
                var4.add(Pair.of((Object)var8, (Object)var9.copy()));
            }
            if (!var4.isEmpty()) {
                var1.accept(new PacketPlayOutEntityEquipment(this.entity.getId(), (List<Pair<EnumItemSlot, ItemStack>>)var4));
            }
        }
        if (!this.entity.getPassengers().isEmpty()) {
            var1.accept(new PacketPlayOutMount(this.entity));
        }
        if (this.entity.isPassenger()) {
            var1.accept(new PacketPlayOutMount(this.entity.getVehicle()));
        }
        if ((object = this.entity) instanceof Leashable && (var4 = (Leashable)object).isLeashed()) {
            var1.accept(new PacketPlayOutAttachEntity(this.entity, var4.getLeashHolder()));
        }
    }

    public Vec3D getPositionBase() {
        return this.positionCodec.getBase();
    }

    public Vec3D getLastSentMovement() {
        return this.lastSentMovement;
    }

    public float getLastSentXRot() {
        return (float)(this.lastSentXRot * 360) / 256.0f;
    }

    public float getLastSentYRot() {
        return (float)(this.lastSentYRot * 360) / 256.0f;
    }

    public float getLastSentYHeadRot() {
        return (float)(this.lastSentYHeadRot * 360) / 256.0f;
    }

    private void sendDirtyEntityData() {
        DataWatcher var0 = this.entity.getEntityData();
        List<DataWatcher.c<?>> var1 = var0.packDirty();
        if (var1 != null) {
            this.trackedDataValues = var0.getNonDefaultValues();
            this.broadcastAndSend(new PacketPlayOutEntityMetadata(this.entity.getId(), var1));
        }
        if (this.entity instanceof EntityLiving) {
            Set<AttributeModifiable> var2 = ((EntityLiving)this.entity).getAttributes().getAttributesToSync();
            if (!var2.isEmpty()) {
                this.broadcastAndSend(new PacketPlayOutUpdateAttributes(this.entity.getId(), var2));
            }
            var2.clear();
        }
    }

    private void broadcastAndSend(Packet<?> var0) {
        this.broadcast.accept(var0);
        if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity).connection.send(var0);
        }
    }
}

