/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlayerChunk
extends GenerationChunkHolder {
    public static final ChunkResult<Chunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    private static final CompletableFuture<ChunkResult<Chunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private final LevelHeightAccessor levelHeightAccessor;
    private volatile CompletableFuture<ChunkResult<Chunk>> fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<Chunk>> tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<Chunk>> entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    public int oldTicketLevel;
    private int ticketLevel;
    private int queueLevel;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;
    private final a onLevelChange;
    public final b playerProvider;
    private boolean wasAccessibleSinceLastSave;
    private CompletableFuture<?> pendingFullStateConfirmation = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> sendSync = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> saveSync = CompletableFuture.completedFuture(null);

    public PlayerChunk(ChunkCoordIntPair var0, int var1, LevelHeightAccessor var2, LevelLightEngine var3, a var4, b var5) {
        super(var0);
        this.levelHeightAccessor = var2;
        this.lightEngine = var3;
        this.onLevelChange = var4;
        this.playerProvider = var5;
        this.ticketLevel = this.oldTicketLevel = ChunkLevel.MAX_LEVEL + 1;
        this.queueLevel = this.oldTicketLevel;
        this.setTicketLevel(var1);
        this.changedBlocksPerSection = new ShortSet[var2.getSectionsCount()];
    }

    public CompletableFuture<ChunkResult<Chunk>> getTickingChunkFuture() {
        return this.tickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<Chunk>> getEntityTickingChunkFuture() {
        return this.entityTickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<Chunk>> getFullChunkFuture() {
        return this.fullChunkFuture;
    }

    @Nullable
    public Chunk getTickingChunk() {
        return this.getTickingChunkFuture().getNow(UNLOADED_LEVEL_CHUNK).orElse(null);
    }

    @Nullable
    public Chunk getChunkToSend() {
        if (!this.sendSync.isDone()) {
            return null;
        }
        return this.getTickingChunk();
    }

    public CompletableFuture<?> getSendSyncFuture() {
        return this.sendSync;
    }

    public void addSendDependency(CompletableFuture<?> var02) {
        this.sendSync = this.sendSync.isDone() ? var02 : this.sendSync.thenCombine(var02, (var0, var1) -> null);
    }

    public CompletableFuture<?> getSaveSyncFuture() {
        return this.saveSync;
    }

    public boolean isReadyForSaving() {
        return this.getGenerationRefCount() == 0 && this.saveSync.isDone();
    }

    private void addSaveDependency(CompletableFuture<?> var02) {
        this.saveSync = this.saveSync.isDone() ? var02 : this.saveSync.thenCombine(var02, (var0, var1) -> null);
    }

    public void blockChanged(BlockPosition var0) {
        Chunk var1 = this.getTickingChunk();
        if (var1 == null) {
            return;
        }
        int var2 = this.levelHeightAccessor.getSectionIndex(var0.getY());
        if (this.changedBlocksPerSection[var2] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[var2] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[var2].add(SectionPosition.sectionRelativePos(var0));
    }

    public void sectionLightChanged(EnumSkyBlock var0, int var1) {
        IChunkAccess var2 = this.getChunkIfPresent(ChunkStatus.INITIALIZE_LIGHT);
        if (var2 == null) {
            return;
        }
        var2.setUnsaved(true);
        Chunk var3 = this.getTickingChunk();
        if (var3 == null) {
            return;
        }
        int var4 = this.lightEngine.getMinLightSection();
        int var5 = this.lightEngine.getMaxLightSection();
        if (var1 < var4 || var1 > var5) {
            return;
        }
        int var6 = var1 - var4;
        if (var0 == EnumSkyBlock.SKY) {
            this.skyChangedLightSectionFilter.set(var6);
        } else {
            this.blockChangedLightSectionFilter.set(var6);
        }
    }

    public void broadcastChanges(Chunk var0) {
        List<EntityPlayer> var22;
        if (!this.hasChangedSections && this.skyChangedLightSectionFilter.isEmpty() && this.blockChangedLightSectionFilter.isEmpty()) {
            return;
        }
        World var1 = var0.getLevel();
        if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            var22 = this.playerProvider.getPlayers(this.pos, true);
            if (!var22.isEmpty()) {
                PacketPlayOutLightUpdate var32 = new PacketPlayOutLightUpdate(var0.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                this.broadcast(var22, var32);
            }
            this.skyChangedLightSectionFilter.clear();
            this.blockChangedLightSectionFilter.clear();
        }
        if (!this.hasChangedSections) {
            return;
        }
        var22 = this.playerProvider.getPlayers(this.pos, false);
        for (int var33 = 0; var33 < this.changedBlocksPerSection.length; ++var33) {
            Object var8;
            Object var7;
            ShortSet var4 = this.changedBlocksPerSection[var33];
            if (var4 == null) continue;
            this.changedBlocksPerSection[var33] = null;
            if (var22.isEmpty()) continue;
            int var5 = this.levelHeightAccessor.getSectionYFromSectionIndex(var33);
            SectionPosition var6 = SectionPosition.of(var0.getPos(), var5);
            if (var4.size() == 1) {
                var7 = var6.relativeToBlockPos(var4.iterator().nextShort());
                var8 = var1.getBlockState((BlockPosition)var7);
                this.broadcast(var22, new PacketPlayOutBlockChange((BlockPosition)var7, (IBlockData)var8));
                this.broadcastBlockEntityIfNeeded(var22, var1, (BlockPosition)var7, (IBlockData)var8);
                continue;
            }
            var7 = var0.getSection(var33);
            var8 = new PacketPlayOutMultiBlockChange(var6, var4, (ChunkSection)var7);
            this.broadcast(var22, (Packet<?>)var8);
            ((PacketPlayOutMultiBlockChange)var8).runUpdates((var2, var3) -> this.broadcastBlockEntityIfNeeded(var22, var1, (BlockPosition)var2, (IBlockData)var3));
        }
        this.hasChangedSections = false;
    }

    private void broadcastBlockEntityIfNeeded(List<EntityPlayer> var0, World var1, BlockPosition var2, IBlockData var3) {
        if (var3.hasBlockEntity()) {
            this.broadcastBlockEntity(var0, var1, var2);
        }
    }

    private void broadcastBlockEntity(List<EntityPlayer> var0, World var1, BlockPosition var2) {
        Packet<PacketListenerPlayOut> var4;
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 != null && (var4 = var3.getUpdatePacket()) != null) {
            this.broadcast(var0, var4);
        }
    }

    private void broadcast(List<EntityPlayer> var0, Packet<?> var12) {
        var0.forEach(var1 -> var1.connection.send(var12));
    }

    @Override
    public int getTicketLevel() {
        return this.ticketLevel;
    }

    @Override
    public int getQueueLevel() {
        return this.queueLevel;
    }

    private void setQueueLevel(int var0) {
        this.queueLevel = var0;
    }

    public void setTicketLevel(int var0) {
        this.ticketLevel = var0;
    }

    private void scheduleFullChunkPromotion(PlayerChunkMap var0, CompletableFuture<ChunkResult<Chunk>> var1, Executor var2, FullChunkStatus var3) {
        this.pendingFullStateConfirmation.cancel(false);
        CompletableFuture var4 = new CompletableFuture();
        var4.thenRunAsync(() -> var0.onFullChunkStatusChange(this.pos, var3), var2);
        this.pendingFullStateConfirmation = var4;
        var1.thenAccept(var12 -> var12.ifSuccess(var1 -> var4.complete(null)));
    }

    private void demoteFullChunk(PlayerChunkMap var0, FullChunkStatus var1) {
        this.pendingFullStateConfirmation.cancel(false);
        var0.onFullChunkStatusChange(this.pos, var1);
    }

    protected void updateFutures(PlayerChunkMap var0, Executor var1) {
        FullChunkStatus var2 = ChunkLevel.fullStatus(this.oldTicketLevel);
        FullChunkStatus var3 = ChunkLevel.fullStatus(this.ticketLevel);
        boolean var4 = var2.isOrAfter(FullChunkStatus.FULL);
        boolean var5 = var3.isOrAfter(FullChunkStatus.FULL);
        this.wasAccessibleSinceLastSave |= var5;
        if (!var4 && var5) {
            this.fullChunkFuture = var0.prepareAccessibleChunk(this);
            this.scheduleFullChunkPromotion(var0, this.fullChunkFuture, var1, FullChunkStatus.FULL);
            this.addSaveDependency(this.fullChunkFuture);
        }
        if (var4 && !var5) {
            this.fullChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean var6 = var2.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        boolean var7 = var3.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        if (!var6 && var7) {
            this.tickingChunkFuture = var0.prepareTickingChunk(this);
            this.scheduleFullChunkPromotion(var0, this.tickingChunkFuture, var1, FullChunkStatus.BLOCK_TICKING);
            this.addSaveDependency(this.tickingChunkFuture);
        }
        if (var6 && !var7) {
            this.tickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean var8 = var2.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        boolean var9 = var3.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        if (!var8 && var9) {
            if (this.entityTickingChunkFuture != UNLOADED_LEVEL_CHUNK_FUTURE) {
                throw SystemUtils.pauseInIde(new IllegalStateException());
            }
            this.entityTickingChunkFuture = var0.prepareEntityTickingChunk(this);
            this.scheduleFullChunkPromotion(var0, this.entityTickingChunkFuture, var1, FullChunkStatus.ENTITY_TICKING);
            this.addSaveDependency(this.entityTickingChunkFuture);
        }
        if (var8 && !var9) {
            this.entityTickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        if (!var3.isOrAfter(var2)) {
            this.demoteFullChunk(var0, var3);
        }
        this.onLevelChange.onLevelChange(this.pos, this::getQueueLevel, this.ticketLevel, this::setQueueLevel);
        this.oldTicketLevel = this.ticketLevel;
    }

    public boolean wasAccessibleSinceLastSave() {
        return this.wasAccessibleSinceLastSave;
    }

    public void refreshAccessibility() {
        this.wasAccessibleSinceLastSave = ChunkLevel.fullStatus(this.ticketLevel).isOrAfter(FullChunkStatus.FULL);
    }

    @FunctionalInterface
    public static interface a {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface b {
        public List<EntityPlayer> getPlayers(ChunkCoordIntPair var1, boolean var2);
    }
}

