/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> visibleChunkMap = this.updatingChunkMap.clone();
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> pendingUnloads = new Long2ObjectLinkedOpenHashMap();
    private final List<ChunkGenerationTask> pendingGenerationTasks = new ArrayList<ChunkGenerationTask>();
    public final WorldServer level;
    private final LightEngineThreaded lightEngine;
    private final IAsyncTaskHandler<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<WorldPersistentData> overworldDataStorage;
    private final VillagePlace poiManager;
    public final LongSet toDrop = new LongOpenHashSet();
    private boolean modified;
    private final ChunkTaskQueueSorter queueSorter;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> worldgenMailbox;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> mainThreadMailbox;
    public final WorldLoadListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final a distanceManager;
    private final AtomicInteger tickingGenerated = new AtomicInteger();
    private final String storageName;
    private final PlayerMap playerMap = new PlayerMap();
    public final Int2ObjectMap<EntityTracker> entityMap = new Int2ObjectOpenHashMap();
    private final Long2ByteMap chunkTypeCache = new Long2ByteOpenHashMap();
    private final Long2LongMap chunkSaveCooldowns = new Long2LongOpenHashMap();
    private final Queue<Runnable> unloadQueue = Queues.newConcurrentLinkedQueue();
    public int serverViewDistance;
    private final WorldGenContext worldGenContext;

    public PlayerChunkMap(WorldServer var0, Convertable.ConversionSession var1, DataFixer var2, StructureTemplateManager var3, Executor var4, IAsyncTaskHandler<Runnable> var5, ILightAccess var6, ChunkGenerator var7, WorldLoadListener var8, ChunkStatusUpdateListener var9, Supplier<WorldPersistentData> var10, int var11, boolean var12) {
        super(new RegionStorageInfo(var1.getLevelId(), var0.dimension(), "chunk"), var1.getDimensionPath(var0.dimension()).resolve("region"), var2, var12);
        Object var17;
        Path var13 = var1.getDimensionPath(var0.dimension());
        this.storageName = var13.getFileName().toString();
        this.level = var0;
        IRegistryCustom var14 = var0.registryAccess();
        long var15 = var0.getSeed();
        if (var7 instanceof ChunkGeneratorAbstract) {
            var17 = (ChunkGeneratorAbstract)var7;
            this.randomState = RandomState.create(((ChunkGeneratorAbstract)var17).generatorSettings().value(), var14.lookupOrThrow(Registries.NOISE), var15);
        } else {
            this.randomState = RandomState.create(GeneratorSettingBase.dummy(), var14.lookupOrThrow(Registries.NOISE), var15);
        }
        this.chunkGeneratorState = var7.createState(var14.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, var15);
        this.mainThreadExecutor = var5;
        var17 = ThreadedMailbox.create(var4, "worldgen");
        Mailbox<Runnable> var18 = Mailbox.of("main", var5::tell);
        this.progressListener = var8;
        this.chunkStatusListener = var9;
        ThreadedMailbox<Runnable> var19 = ThreadedMailbox.create(var4, "light");
        this.queueSorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of((Object)var17, var18, var19), var4, Integer.MAX_VALUE);
        this.worldgenMailbox = this.queueSorter.getProcessor(var17, false);
        this.mainThreadMailbox = this.queueSorter.getProcessor(var18, false);
        this.lightEngine = new LightEngineThreaded(var6, this, this.level.dimensionType().hasSkyLight(), var19, this.queueSorter.getProcessor(var19, false));
        this.distanceManager = new a(var4, var5);
        this.overworldDataStorage = var10;
        this.poiManager = new VillagePlace(new RegionStorageInfo(var1.getLevelId(), var0.dimension(), "poi"), var13.resolve("poi"), var2, var12, var14, var0.getServer(), var0);
        this.setServerViewDistance(var11);
        this.worldGenContext = new WorldGenContext(var0, var7, var3, this.lightEngine, this.mainThreadMailbox);
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    private static double euclideanDistanceSquared(ChunkCoordIntPair var0, Entity var1) {
        double var2 = SectionPosition.sectionToBlockCoord(var0.x, 8);
        double var4 = SectionPosition.sectionToBlockCoord(var0.z, 8);
        double var6 = var2 - var1.getX();
        double var8 = var4 - var1.getZ();
        return var6 * var6 + var8 * var8;
    }

    boolean isChunkTracked(EntityPlayer var0, int var1, int var2) {
        return var0.getChunkTrackingView().contains(var1, var2) && !var0.connection.chunkSender.isPending(ChunkCoordIntPair.asLong(var1, var2));
    }

    private boolean isChunkOnTrackedBorder(EntityPlayer var0, int var1, int var2) {
        if (!this.isChunkTracked(var0, var1, var2)) {
            return false;
        }
        for (int var3 = -1; var3 <= 1; ++var3) {
            for (int var4 = -1; var4 <= 1; ++var4) {
                if (var3 == 0 && var4 == 0 || this.isChunkTracked(var0, var1 + var3, var2 + var4)) continue;
                return true;
            }
        }
        return false;
    }

    protected LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected PlayerChunk getUpdatingChunkIfPresent(long var0) {
        return (PlayerChunk)this.updatingChunkMap.get(var0);
    }

    @Nullable
    protected PlayerChunk getVisibleChunkIfPresent(long var0) {
        return (PlayerChunk)this.visibleChunkMap.get(var0);
    }

    protected IntSupplier getChunkQueueLevel(long var0) {
        return () -> {
            PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
            if (var2 == null) {
                return ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1;
            }
            return Math.min(var2.getQueueLevel(), ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkCoordIntPair var0) {
        PlayerChunk var1 = this.getVisibleChunkIfPresent(var0.toLong());
        if (var1 == null) {
            return "null";
        }
        String var2 = var1.getTicketLevel() + "\n";
        ChunkStatus var3 = var1.getLatestStatus();
        IChunkAccess var4 = var1.getLatestChunk();
        if (var3 != null) {
            var2 = var2 + "St: \u00a7" + var3.getIndex() + String.valueOf(var3) + "\u00a7r\n";
        }
        if (var4 != null) {
            var2 = var2 + "Ch: \u00a7" + var4.getPersistedStatus().getIndex() + String.valueOf(var4.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus var5 = var1.getFullStatus();
        var2 = var2 + String.valueOf('\u00a7') + var5.ordinal() + String.valueOf((Object)var5);
        return var2 + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<IChunkAccess>>> getChunkRangeFuture(PlayerChunk var02, int var1, IntFunction<ChunkStatus> var2) {
        if (var1 == 0) {
            ChunkStatus var3 = var2.apply(0);
            return var02.scheduleChunkGenerationTask(var3, this).thenApply(var0 -> var0.map(List::of));
        }
        ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>> var3 = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>();
        ChunkCoordIntPair var4 = var02.getPos();
        for (int var5 = -var1; var5 <= var1; ++var5) {
            for (int var6 = -var1; var6 <= var1; ++var6) {
                int var7 = Math.max(Math.abs(var6), Math.abs(var5));
                long var8 = ChunkCoordIntPair.asLong(var4.x + var6, var4.z + var5);
                PlayerChunk var10 = this.getUpdatingChunkIfPresent(var8);
                if (var10 == null) {
                    return UNLOADED_CHUNK_LIST_FUTURE;
                }
                ChunkStatus var11 = var2.apply(var7);
                var3.add(var10.scheduleChunkGenerationTask(var11, this));
            }
        }
        return SystemUtils.sequence(var3).thenApply(var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (ChunkResult var3 : var0) {
                if (var3 == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                IChunkAccess var4 = var3.orElse(null);
                if (var4 == null) {
                    return UNLOADED_CHUNK_LIST_RESULT;
                }
                var1.add(var4);
            }
            return ChunkResult.of(var1);
        });
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException var0, String var12) {
        StringBuilder var2 = new StringBuilder();
        Consumer<PlayerChunk> var3 = var1 -> var1.getAllFutures().forEach(var2 -> {
            ChunkStatus var3 = (ChunkStatus)var2.getFirst();
            CompletableFuture var4 = (CompletableFuture)var2.getSecond();
            if (var4 != null && var4.isDone() && var4.join() == null) {
                var2.append(var1.getPos()).append(" - status: ").append(var3).append(" future: ").append(var4).append(System.lineSeparator());
            }
        });
        var2.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach(var3);
        var2.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach(var3);
        CrashReport var4 = CrashReport.forThrowable(var0, "Chunk loading");
        CrashReportSystemDetails var5 = var4.addCategory("Chunk loading");
        var5.setDetail("Details", var12);
        var5.setDetail("Futures", var2);
        return new ReportedException(var4);
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareEntityTickingChunk(PlayerChunk var03) {
        return this.getChunkRangeFuture(var03, 2, var0 -> ChunkStatus.FULL).thenApplyAsync(var02 -> var02.map(var0 -> (Chunk)var0.get(var0.size() / 2)), (Executor)this.mainThreadExecutor);
    }

    @Nullable
    PlayerChunk updateChunkScheduling(long var0, int var2, @Nullable PlayerChunk var3, int var4) {
        if (!ChunkLevel.isLoaded(var4) && !ChunkLevel.isLoaded(var2)) {
            return var3;
        }
        if (var3 != null) {
            var3.setTicketLevel(var2);
        }
        if (var3 != null) {
            if (!ChunkLevel.isLoaded(var2)) {
                this.toDrop.add(var0);
            } else {
                this.toDrop.remove(var0);
            }
        }
        if (ChunkLevel.isLoaded(var2) && var3 == null) {
            var3 = (PlayerChunk)this.pendingUnloads.remove(var0);
            if (var3 != null) {
                var3.setTicketLevel(var2);
            } else {
                var3 = new PlayerChunk(new ChunkCoordIntPair(var0), var2, this.level, this.lightEngine, this.queueSorter, this);
            }
            this.updatingChunkMap.put(var0, (Object)var3);
            this.modified = true;
        }
        return var3;
    }

    @Override
    public void close() throws IOException {
        try {
            this.queueSorter.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean var02) {
        if (var02) {
            List<PlayerChunk> var12 = this.visibleChunkMap.values().stream().filter(PlayerChunk::wasAccessibleSinceLastSave).peek(PlayerChunk::refreshAccessibility).toList();
            MutableBoolean var2 = new MutableBoolean();
            do {
                var2.setFalse();
                var12.stream().map(var0 -> {
                    this.mainThreadExecutor.managedBlock(var0::isReadyForSaving);
                    return var0.getLatestChunk();
                }).filter(var0 -> var0 instanceof ProtoChunkExtension || var0 instanceof Chunk).filter(this::save).forEach(var1 -> var2.setTrue());
            } while (var2.isTrue());
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.visibleChunkMap.values().forEach(this::saveChunkIfNeeded);
        }
    }

    protected void tick(BooleanSupplier var0) {
        GameProfilerFiller var1 = this.level.getProfiler();
        var1.push("poi");
        this.poiManager.tick(var0);
        var1.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(var0);
        }
        var1.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.queueSorter.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier var0) {
        Runnable var3;
        LongIterator var1 = this.toDrop.iterator();
        int var2 = 0;
        while (var1.hasNext() && (var0.getAsBoolean() || var2 < 200 || this.toDrop.size() > 2000)) {
            long var32 = var1.nextLong();
            PlayerChunk var5 = (PlayerChunk)this.updatingChunkMap.get(var32);
            if (var5 != null) {
                if (var5.getGenerationRefCount() != 0) continue;
                this.updatingChunkMap.remove(var32);
                this.pendingUnloads.put(var32, (Object)var5);
                this.modified = true;
                ++var2;
                this.scheduleUnload(var32, var5);
            }
            var1.remove();
        }
        for (int var4 = Math.max(0, this.unloadQueue.size() - 2000); (var0.getAsBoolean() || var4 > 0) && (var3 = this.unloadQueue.poll()) != null; --var4) {
            var3.run();
        }
        int var5 = 0;
        ObjectIterator var6 = this.visibleChunkMap.values().iterator();
        while (var5 < 20 && var0.getAsBoolean() && var6.hasNext()) {
            if (!this.saveChunkIfNeeded((PlayerChunk)var6.next())) continue;
            ++var5;
        }
    }

    private void scheduleUnload(long var0, PlayerChunk var22) {
        ((CompletableFuture)var22.getSaveSyncFuture().thenRunAsync(() -> {
            if (!var22.isReadyForSaving()) {
                this.scheduleUnload(var0, var22);
                return;
            }
            IChunkAccess var3 = var22.getLatestChunk();
            if (this.pendingUnloads.remove(var0, (Object)var22) && var3 != null) {
                Chunk var4;
                if (var3 instanceof Chunk) {
                    var4 = (Chunk)var3;
                    var4.setLoaded(false);
                }
                this.save(var3);
                if (var3 instanceof Chunk) {
                    var4 = (Chunk)var3;
                    this.level.unload(var4);
                }
                this.lightEngine.updateChunkStatus(var3.getPos());
                this.lightEngine.tryScheduleUpdate();
                this.progressListener.onStatusChange(var3.getPos(), null);
                this.chunkSaveCooldowns.remove(var3.getPos().toLong());
            }
        }, this.unloadQueue::add)).whenComplete((var1, var2) -> {
            if (var2 != null) {
                LOGGER.error("Failed to save chunk {}", (Object)var22.getPos(), var2);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    private CompletableFuture<IChunkAccess> scheduleChunkLoad(ChunkCoordIntPair var0) {
        return ((CompletableFuture)((CompletableFuture)this.readChunk(var0).thenApply(var12 -> var12.filter(var1 -> {
            boolean var2 = PlayerChunkMap.isChunkDataValid(var1);
            if (!var2) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)var0);
            }
            return var2;
        }))).thenApplyAsync(var1 -> {
            this.level.getProfiler().incrementCounter("chunkLoad");
            if (var1.isPresent()) {
                ProtoChunk var2 = ChunkRegionLoader.read(this.level, this.poiManager, this.storageInfo(), var0, (NBTTagCompound)var1.get());
                this.markPosition(var0, ((IChunkAccess)var2).getPersistedStatus().getChunkType());
                return var2;
            }
            return this.createEmptyChunk(var0);
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync(var1 -> this.handleChunkLoadFailure((Throwable)var1, var0), (Executor)this.mainThreadExecutor);
    }

    private static boolean isChunkDataValid(NBTTagCompound var0) {
        return var0.contains("Status", 8);
    }

    private IChunkAccess handleChunkLoadFailure(Throwable var0, ChunkCoordIntPair var1) {
        boolean var5;
        Throwable throwable;
        Throwable var2;
        Throwable var3;
        if (var0 instanceof CompletionException) {
            var3 = (CompletionException)var0;
            v0 = var3.getCause();
        } else {
            v0 = var2 = var0;
        }
        if (var2 instanceof ReportedException) {
            ReportedException var4 = (ReportedException)var2;
            throwable = var4.getCause();
        } else {
            throwable = var2;
        }
        var3 = throwable;
        boolean var4 = var3 instanceof Error;
        boolean bl = var5 = var3 instanceof IOException || var3 instanceof NbtException;
        if (!var4) {
            if (!var5) {
                // empty if block
            }
        } else {
            CrashReport var6 = CrashReport.forThrowable(var0, "Exception loading chunk");
            CrashReportSystemDetails var7 = var6.addCategory("Chunk being loaded");
            var7.setDetail("pos", var1);
            this.markPositionReplaceable(var1);
            throw new ReportedException(var6);
        }
        this.level.getServer().reportChunkLoadFailure(var3, this.storageInfo(), var1);
        return this.createEmptyChunk(var1);
    }

    private IChunkAccess createEmptyChunk(ChunkCoordIntPair var0) {
        this.markPositionReplaceable(var0);
        return new ProtoChunk(var0, ChunkConverter.EMPTY, this.level, this.level.registryAccess().registryOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkCoordIntPair var0) {
        this.chunkTypeCache.put(var0.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkCoordIntPair var0, ChunkType var1) {
        return this.chunkTypeCache.put(var0.toLong(), var1 == ChunkType.PROTOCHUNK ? (byte)-1 : 1);
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long var0) {
        PlayerChunk var2 = (PlayerChunk)this.updatingChunkMap.get(var0);
        var2.increaseGenerationRefCount();
        return var2;
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder var0) {
        var0.decreaseGenerationRefCount();
    }

    @Override
    public CompletableFuture<IChunkAccess> applyStep(GenerationChunkHolder var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2) {
        ChunkCoordIntPair var3 = var0.getPos();
        if (var1.targetStatus() == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad(var3);
        }
        try {
            GenerationChunkHolder var4 = var2.get(var3.x, var3.z);
            IChunkAccess var5 = var4.getChunkIfPresentUnchecked(var1.targetStatus().getParent());
            if (var5 == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            CompletableFuture<IChunkAccess> var6 = var1.apply(this.worldGenContext, var2, var5);
            this.progressListener.onStatusChange(var3, var1.targetStatus());
            return var6;
        }
        catch (Exception var4) {
            var4.getStackTrace();
            CrashReport var5 = CrashReport.forThrowable(var4, "Exception generating new chunk");
            CrashReportSystemDetails var6 = var5.addCategory("Chunk to be generated");
            var6.setDetail("Status being generated", () -> var1.targetStatus().getName());
            var6.setDetail("Location", String.format(Locale.ROOT, "%d,%d", var3.x, var3.z));
            var6.setDetail("Position hash", ChunkCoordIntPair.asLong(var3.x, var3.z));
            var6.setDetail("Generator", this.generator());
            this.mainThreadExecutor.execute(() -> {
                throw new ReportedException(var5);
            });
            throw new ReportedException(var5);
        }
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus var0, ChunkCoordIntPair var1) {
        ChunkGenerationTask var2 = ChunkGenerationTask.create(this, var0, var1);
        this.pendingGenerationTasks.add(var2);
        return var2;
    }

    private void runGenerationTask(ChunkGenerationTask var0) {
        this.worldgenMailbox.tell(ChunkTaskQueueSorter.message(var0.getCenter(), () -> {
            CompletableFuture<?> var1 = var0.runUntilWait();
            if (var1 == null) {
                return;
            }
            var1.thenRun(() -> this.runGenerationTask(var0));
        }));
    }

    @Override
    public void runGenerationTasks() {
        this.pendingGenerationTasks.forEach(this::runGenerationTask);
        this.pendingGenerationTasks.clear();
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareTickingChunk(PlayerChunk var03) {
        CompletableFuture<ChunkResult<List<IChunkAccess>>> var12 = this.getChunkRangeFuture(var03, 1, var0 -> ChunkStatus.FULL);
        CompletionStage var2 = ((CompletableFuture)var12.thenApplyAsync(var02 -> var02.map(var0 -> (Chunk)var0.get(var0.size() / 2)), var1 -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message((GenerationChunkHolder)var03, var1)))).thenApplyAsync(var1 -> var1.ifSuccess(var12 -> {
            var12.postProcessGeneration();
            this.level.startTickingChunk((Chunk)var12);
            CompletableFuture<?> var2 = var03.getSendSyncFuture();
            if (var2.isDone()) {
                this.onChunkReadyToSend((Chunk)var12);
            } else {
                var2.thenAcceptAsync(var1 -> this.onChunkReadyToSend((Chunk)var12), (Executor)this.mainThreadExecutor);
            }
        }), (Executor)this.mainThreadExecutor);
        ((CompletableFuture)var2).handle((var0, var1) -> {
            this.tickingGenerated.getAndIncrement();
            return null;
        });
        return var2;
    }

    private void onChunkReadyToSend(Chunk var0) {
        ChunkCoordIntPair var1 = var0.getPos();
        for (EntityPlayer var3 : this.playerMap.getAllPlayers()) {
            if (!var3.getChunkTrackingView().contains(var1)) continue;
            PlayerChunkMap.markChunkPendingToSend(var3, var0);
        }
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareAccessibleChunk(PlayerChunk var0) {
        return this.getChunkRangeFuture(var0, 1, ChunkLevel::getStatusAroundFullChunk).thenApplyAsync(var02 -> var02.map(var0 -> (Chunk)var0.get(var0.size() / 2)), var1 -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message((GenerationChunkHolder)var0, var1)));
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(PlayerChunk var0) {
        if (!var0.wasAccessibleSinceLastSave() || !var0.isReadyForSaving()) {
            return false;
        }
        IChunkAccess var1 = var0.getLatestChunk();
        if (var1 instanceof ProtoChunkExtension || var1 instanceof Chunk) {
            long var2 = var1.getPos().toLong();
            long var4 = this.chunkSaveCooldowns.getOrDefault(var2, -1L);
            long var6 = System.currentTimeMillis();
            if (var6 < var4) {
                return false;
            }
            boolean var8 = this.save(var1);
            var0.refreshAccessibility();
            if (var8) {
                this.chunkSaveCooldowns.put(var2, var6 + 10000L);
            }
            return var8;
        }
        return false;
    }

    public boolean save(IChunkAccess var0) {
        this.poiManager.flush(var0.getPos());
        if (!var0.isUnsaved()) {
            return false;
        }
        var0.setUnsaved(false);
        ChunkCoordIntPair var12 = var0.getPos();
        try {
            ChunkStatus var2 = var0.getPersistedStatus();
            if (var2.getChunkType() != ChunkType.LEVELCHUNK) {
                if (this.isExistingChunkFull(var12)) {
                    return false;
                }
                if (var2 == ChunkStatus.EMPTY && var0.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            this.level.getProfiler().incrementCounter("chunkSave");
            NBTTagCompound var3 = ChunkRegionLoader.write(this.level, var0);
            this.write(var12, var3).exceptionally(var1 -> {
                this.level.getServer().reportChunkSaveFailure((Throwable)var1, this.storageInfo(), var12);
                return null;
            });
            this.markPosition(var12, var2.getChunkType());
            return true;
        }
        catch (Exception var2) {
            this.level.getServer().reportChunkSaveFailure(var2, this.storageInfo(), var12);
            return false;
        }
    }

    private boolean isExistingChunkFull(ChunkCoordIntPair var0) {
        NBTTagCompound var2;
        byte var1 = this.chunkTypeCache.get(var0.toLong());
        if (var1 != 0) {
            return var1 == 1;
        }
        try {
            var2 = this.readChunk(var0).join().orElse(null);
            if (var2 == null) {
                this.markPositionReplaceable(var0);
                return false;
            }
        }
        catch (Exception var3) {
            LOGGER.error("Failed to read chunk {}", (Object)var0, (Object)var3);
            this.markPositionReplaceable(var0);
            return false;
        }
        ChunkType var3 = ChunkRegionLoader.getChunkTypeFromTag(var2);
        return this.markPosition(var0, var3) == 1;
    }

    protected void setServerViewDistance(int var0) {
        int var1 = MathHelper.clamp(var0, 2, 32);
        if (var1 != this.serverViewDistance) {
            this.serverViewDistance = var1;
            this.distanceManager.updatePlayerTickets(this.serverViewDistance);
            for (EntityPlayer var3 : this.playerMap.getAllPlayers()) {
                this.updateChunkTracking(var3);
            }
        }
    }

    int getPlayerViewDistance(EntityPlayer var0) {
        return MathHelper.clamp(var0.requestedViewDistance(), 2, this.serverViewDistance);
    }

    private void markChunkPendingToSend(EntityPlayer var0, ChunkCoordIntPair var1) {
        Chunk var2 = this.getChunkToSend(var1.toLong());
        if (var2 != null) {
            PlayerChunkMap.markChunkPendingToSend(var0, var2);
        }
    }

    private static void markChunkPendingToSend(EntityPlayer var0, Chunk var1) {
        var0.connection.chunkSender.markChunkPendingToSend(var1);
    }

    private static void dropChunk(EntityPlayer var0, ChunkCoordIntPair var1) {
        var0.connection.chunkSender.dropChunk(var0, var1);
    }

    @Nullable
    public Chunk getChunkToSend(long var0) {
        PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
        if (var2 == null) {
            return null;
        }
        return var2.getChunkToSend();
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public ChunkMapDistance getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<PlayerChunk> getChunks() {
        return Iterables.unmodifiableIterable((Iterable)this.visibleChunkMap.values());
    }

    void dumpChunks(Writer var02) throws IOException {
        CSVWriter var1 = CSVWriter.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(var02);
        TickingTracker var2 = this.distanceManager.tickingTracker();
        for (Long2ObjectMap.Entry var4 : this.visibleChunkMap.long2ObjectEntrySet()) {
            long var5 = var4.getLongKey();
            ChunkCoordIntPair var7 = new ChunkCoordIntPair(var5);
            PlayerChunk var8 = (PlayerChunk)var4.getValue();
            Optional<IChunkAccess> var9 = Optional.ofNullable(var8.getLatestChunk());
            Optional<Object> var10 = var9.flatMap(var0 -> var0 instanceof Chunk ? Optional.of((Chunk)var0) : Optional.empty());
            var1.writeRow(var7.x, var7.z, var8.getTicketLevel(), var9.isPresent(), var9.map(IChunkAccess::getPersistedStatus).orElse(null), var10.map(Chunk::getFullStatus).orElse(null), PlayerChunkMap.printFuture(var8.getFullChunkFuture()), PlayerChunkMap.printFuture(var8.getTickingChunkFuture()), PlayerChunkMap.printFuture(var8.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString(var5), this.anyPlayerCloseEnoughForSpawning(var7), var10.map(var0 -> var0.getBlockEntities().size()).orElse(0), var2.getTicketDebugString(var5), var2.getLevel(var5), var10.map(var0 -> var0.getBlockTicks().count()).orElse(0), var10.map(var0 -> var0.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<Chunk>> var0) {
        try {
            ChunkResult var1 = var0.getNow(null);
            if (var1 != null) {
                return var1.isSuccess() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException var1) {
            return "failed " + var1.getCause().getMessage();
        }
        catch (CancellationException var1) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> readChunk(ChunkCoordIntPair var02) {
        return this.read(var02).thenApplyAsync(var0 -> var0.map(this::upgradeChunkTag), (Executor)SystemUtils.backgroundExecutor());
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound var0) {
        return this.upgradeChunkTag(this.level.dimension(), this.overworldDataStorage, var0, this.generator().getTypeNameForDataFixer());
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair var0) {
        if (!this.distanceManager.hasPlayersNearby(var0.toLong())) {
            return false;
        }
        for (EntityPlayer var2 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(var2, var0)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> getPlayersCloseForSpawning(ChunkCoordIntPair var0) {
        long var1 = var0.toLong();
        if (!this.distanceManager.hasPlayersNearby(var1)) {
            return List.of();
        }
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (EntityPlayer var5 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(var5, var0)) continue;
            var3.add((Object)var5);
        }
        return var3.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer var0, ChunkCoordIntPair var1) {
        if (var0.isSpectator()) {
            return false;
        }
        double var2 = PlayerChunkMap.euclideanDistanceSquared(var1, var0);
        return var2 < 16384.0;
    }

    private boolean skipPlayer(EntityPlayer var0) {
        return var0.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(EntityPlayer var0, boolean var1) {
        boolean var2 = this.skipPlayer(var0);
        boolean var3 = this.playerMap.ignoredOrUnknown(var0);
        if (var1) {
            this.playerMap.addPlayer(var0, var2);
            this.updatePlayerPos(var0);
            if (!var2) {
                this.distanceManager.addPlayer(SectionPosition.of(var0), var0);
            }
            var0.setChunkTrackingView(ChunkTrackingView.EMPTY);
            this.updateChunkTracking(var0);
        } else {
            SectionPosition var4 = var0.getLastSectionPos();
            this.playerMap.removePlayer(var0);
            if (!var3) {
                this.distanceManager.removePlayer(var4, var0);
            }
            this.applyChunkTrackingView(var0, ChunkTrackingView.EMPTY);
        }
    }

    private void updatePlayerPos(EntityPlayer var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        var0.setLastSectionPos(var1);
    }

    public void move(EntityPlayer var0) {
        boolean var5;
        Object var22;
        for (Object var22 : this.entityMap.values()) {
            if (((EntityTracker)var22).entity == var0) {
                ((EntityTracker)var22).updatePlayers(this.level.players());
                continue;
            }
            ((EntityTracker)var22).updatePlayer(var0);
        }
        SectionPosition var1 = var0.getLastSectionPos();
        var22 = SectionPosition.of(var0);
        boolean var3 = this.playerMap.ignored(var0);
        boolean var4 = this.skipPlayer(var0);
        boolean bl = var5 = var1.asLong() != ((SectionPosition)var22).asLong();
        if (var5 || var3 != var4) {
            this.updatePlayerPos(var0);
            if (!var3) {
                this.distanceManager.removePlayer(var1, var0);
            }
            if (!var4) {
                this.distanceManager.addPlayer((SectionPosition)var22, var0);
            }
            if (!var3 && var4) {
                this.playerMap.ignorePlayer(var0);
            }
            if (var3 && !var4) {
                this.playerMap.unIgnorePlayer(var0);
            }
            this.updateChunkTracking(var0);
        }
    }

    private void updateChunkTracking(EntityPlayer var0) {
        ChunkTrackingView.a var3;
        ChunkCoordIntPair var1 = var0.chunkPosition();
        int var2 = this.getPlayerViewDistance(var0);
        ChunkTrackingView chunkTrackingView = var0.getChunkTrackingView();
        if (chunkTrackingView instanceof ChunkTrackingView.a && (var3 = (ChunkTrackingView.a)chunkTrackingView).center().equals(var1) && var3.viewDistance() == var2) {
            return;
        }
        this.applyChunkTrackingView(var0, ChunkTrackingView.of(var1, var2));
    }

    private void applyChunkTrackingView(EntityPlayer var0, ChunkTrackingView var12) {
        if (var0.level() != this.level) {
            return;
        }
        ChunkTrackingView var2 = var0.getChunkTrackingView();
        if (var12 instanceof ChunkTrackingView.a) {
            ChunkTrackingView.a var4;
            ChunkTrackingView.a var3 = (ChunkTrackingView.a)var12;
            if (!(var2 instanceof ChunkTrackingView.a) || !(var4 = (ChunkTrackingView.a)var2).center().equals(var3.center())) {
                var0.connection.send(new PacketPlayOutViewCentre(var3.center().x, var3.center().z));
            }
        }
        ChunkTrackingView.difference(var2, var12, var1 -> this.markChunkPendingToSend(var0, (ChunkCoordIntPair)var1), var1 -> PlayerChunkMap.dropChunk(var0, var1));
        var0.setChunkTrackingView(var12);
    }

    @Override
    public List<EntityPlayer> getPlayers(ChunkCoordIntPair var0, boolean var1) {
        Set<EntityPlayer> var2 = this.playerMap.getAllPlayers();
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (EntityPlayer var5 : var2) {
            if ((!var1 || !this.isChunkOnTrackedBorder(var5, var0.x, var0.z)) && (var1 || !this.isChunkTracked(var5, var0.x, var0.z))) continue;
            var3.add((Object)var5);
        }
        return var3.build();
    }

    protected void addEntity(Entity var0) {
        if (var0 instanceof EntityComplexPart) {
            return;
        }
        EntityTypes<?> var1 = var0.getType();
        int var2 = var1.clientTrackingRange() * 16;
        if (var2 == 0) {
            return;
        }
        int var3 = var1.updateInterval();
        if (this.entityMap.containsKey(var0.getId())) {
            throw SystemUtils.pauseInIde(new IllegalStateException("Entity is already tracked!"));
        }
        EntityTracker var4 = new EntityTracker(var0, var2, var3, var1.trackDeltas());
        this.entityMap.put(var0.getId(), (Object)var4);
        var4.updatePlayers(this.level.players());
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var5 = (EntityPlayer)var0;
            this.updatePlayerStatus(var5, true);
            for (EntityTracker var7 : this.entityMap.values()) {
                if (var7.entity == var5) continue;
                var7.updatePlayer(var5);
            }
        }
    }

    protected void removeEntity(Entity var0) {
        Object var1;
        if (var0 instanceof EntityPlayer) {
            var1 = (EntityPlayer)var0;
            this.updatePlayerStatus((EntityPlayer)var1, false);
            for (EntityTracker var3 : this.entityMap.values()) {
                var3.removePlayer((EntityPlayer)var1);
            }
        }
        if ((var1 = (EntityTracker)this.entityMap.remove(var0.getId())) != null) {
            ((EntityTracker)var1).broadcastRemoved();
        }
    }

    protected void tick() {
        for (EntityPlayer entityPlayer : this.playerMap.getAllPlayers()) {
            this.updateChunkTracking(entityPlayer);
        }
        ArrayList var0 = Lists.newArrayList();
        List<EntityPlayer> list = this.level.players();
        for (EntityTracker var3 : this.entityMap.values()) {
            boolean var6;
            SectionPosition var4 = var3.lastSectionPos;
            SectionPosition var5 = SectionPosition.of(var3.entity);
            boolean bl = var6 = !Objects.equals(var4, var5);
            if (var6) {
                var3.updatePlayers(list);
                Entity var7 = var3.entity;
                if (var7 instanceof EntityPlayer) {
                    var0.add((EntityPlayer)var7);
                }
                var3.lastSectionPos = var5;
            }
            if (!var6 && !this.distanceManager.inEntityTickingRange(var5.chunk().toLong())) continue;
            var3.serverEntity.sendChanges();
        }
        if (!var0.isEmpty()) {
            for (EntityTracker var3 : this.entityMap.values()) {
                var3.updatePlayers(var0);
            }
        }
    }

    public void broadcast(Entity var0, Packet<?> var1) {
        EntityTracker var2 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var2 != null) {
            var2.broadcast(var1);
        }
    }

    protected void broadcastAndSend(Entity var0, Packet<?> var1) {
        EntityTracker var2 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var2 != null) {
            var2.broadcastAndSend(var1);
        }
    }

    public void resendBiomesForChunks(List<IChunkAccess> var02) {
        HashMap<EntityPlayer, List> var12 = new HashMap<EntityPlayer, List>();
        for (IChunkAccess var3 : var02) {
            Chunk var6;
            ChunkCoordIntPair var4 = var3.getPos();
            Chunk var5 = var3 instanceof Chunk ? (var6 = (Chunk)var3) : this.level.getChunk(var4.x, var4.z);
            for (EntityPlayer var7 : this.getPlayers(var4, false)) {
                var12.computeIfAbsent(var7, var0 -> new ArrayList()).add(var5);
            }
        }
        var12.forEach((var0, var1) -> var0.connection.send(ClientboundChunksBiomesPacket.forChunks(var1)));
    }

    protected VillagePlace getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkCoordIntPair var0, FullChunkStatus var1) {
        this.chunkStatusListener.onChunkStatusChange(var0, var1);
    }

    public void waitForLightBeforeSending(ChunkCoordIntPair var02, int var1) {
        int var2 = var1 + 1;
        ChunkCoordIntPair.rangeClosed(var02, var2).forEach(var0 -> {
            PlayerChunk var1 = this.getVisibleChunkIfPresent(var0.toLong());
            if (var1 != null) {
                var1.addSendDependency(this.lightEngine.waitForPendingTasks(var0.x, var0.z));
            }
        });
    }

    class a
    extends ChunkMapDistance {
        protected a(Executor var1, Executor var2) {
            super(var1, var2);
        }

        @Override
        protected boolean isChunkToRemove(long var0) {
            return PlayerChunkMap.this.toDrop.contains(var0);
        }

        @Override
        @Nullable
        protected PlayerChunk getChunk(long var0) {
            return PlayerChunkMap.this.getUpdatingChunkIfPresent(var0);
        }

        @Override
        @Nullable
        protected PlayerChunk updateChunkScheduling(long var0, int var2, @Nullable PlayerChunk var3, int var4) {
            return PlayerChunkMap.this.updateChunkScheduling(var0, var2, var3, var4);
        }
    }

    public class EntityTracker {
        public final EntityTrackerEntry serverEntity;
        final Entity entity;
        private final int range;
        SectionPosition lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public EntityTracker(Entity var1, int var2, int var3, boolean var4) {
            this.serverEntity = new EntityTrackerEntry(PlayerChunkMap.this.level, var1, var3, var4, this::broadcast);
            this.entity = var1;
            this.range = var2;
            this.lastSectionPos = SectionPosition.of(var1);
        }

        public boolean equals(Object var0) {
            if (var0 instanceof EntityTracker) {
                return ((EntityTracker)var0).entity.getId() == this.entity.getId();
            }
            return false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> var0) {
            for (ServerPlayerConnection var2 : this.seenBy) {
                var2.send(var0);
            }
        }

        public void broadcastAndSend(Packet<?> var0) {
            this.broadcast(var0);
            if (this.entity instanceof EntityPlayer) {
                ((EntityPlayer)this.entity).connection.send(var0);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection var1 : this.seenBy) {
                this.serverEntity.removePairing(var1.getPlayer());
            }
        }

        public void removePlayer(EntityPlayer var0) {
            if (this.seenBy.remove(var0.connection)) {
                this.serverEntity.removePairing(var0);
            }
        }

        public void updatePlayer(EntityPlayer var0) {
            boolean var9;
            if (var0 == this.entity) {
                return;
            }
            Vec3D var1 = var0.position().subtract(this.entity.position());
            int var2 = PlayerChunkMap.this.getPlayerViewDistance(var0);
            double var5 = var1.x * var1.x + var1.z * var1.z;
            double var3 = Math.min(this.getEffectiveRange(), var2 * 16);
            double var7 = var3 * var3;
            boolean bl = var9 = var5 <= var7 && this.entity.broadcastToPlayer(var0) && PlayerChunkMap.this.isChunkTracked(var0, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
            if (var9) {
                if (this.seenBy.add(var0.connection)) {
                    this.serverEntity.addPairing(var0);
                }
            } else if (this.seenBy.remove(var0.connection)) {
                this.serverEntity.removePairing(var0);
            }
        }

        private int scaledRange(int var0) {
            return PlayerChunkMap.this.level.getServer().getScaledTrackingDistance(var0);
        }

        private int getEffectiveRange() {
            int var0 = this.range;
            for (Entity var2 : this.entity.getIndirectPassengers()) {
                int var3 = var2.getType().clientTrackingRange() * 16;
                if (var3 <= var0) continue;
                var0 = var3;
            }
            return this.scaledRange(var0);
        }

        public void updatePlayers(List<EntityPlayer> var0) {
            for (EntityPlayer var2 : var0) {
                this.updatePlayer(var2);
            }
        }
    }
}

