/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.SharedConstants;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final IChatBaseComponent IGNORE_STATUS_REASON = IChatBaseComponent.translatable("disconnect.ignoring_status_request");
    private final MinecraftServer server;
    private final NetworkManager connection;

    public HandshakeListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
    }

    @Override
    public void handleIntention(PacketHandshakingInSetProtocol var0) {
        switch (var0.intention()) {
            case LOGIN: {
                this.beginLogin(var0, false);
                break;
            }
            case STATUS: {
                ServerPing var1 = this.server.getStatus();
                this.connection.setupOutboundProtocol(StatusProtocols.CLIENTBOUND);
                if (this.server.repliesToStatus() && var1 != null) {
                    this.connection.setupInboundProtocol(StatusProtocols.SERVERBOUND, new PacketStatusListener(var1, this.connection));
                    break;
                }
                this.connection.disconnect(IGNORE_STATUS_REASON);
                break;
            }
            case TRANSFER: {
                if (!this.server.acceptsTransfers()) {
                    this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
                    IChatMutableComponent var1 = IChatBaseComponent.translatable("multiplayer.disconnect.transfers_disabled");
                    this.connection.send(new PacketLoginOutDisconnect(var1));
                    this.connection.disconnect(var1);
                    break;
                }
                this.beginLogin(var0, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)var0.intention()));
            }
        }
    }

    private void beginLogin(PacketHandshakingInSetProtocol var0, boolean var1) {
        this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
        if (var0.protocolVersion() != SharedConstants.getCurrentVersion().getProtocolVersion()) {
            IChatMutableComponent var2 = var0.protocolVersion() < 754 ? IChatBaseComponent.translatable("multiplayer.disconnect.outdated_client", SharedConstants.getCurrentVersion().getName()) : IChatBaseComponent.translatable("multiplayer.disconnect.incompatible", SharedConstants.getCurrentVersion().getName());
            this.connection.send(new PacketLoginOutDisconnect(var2));
            this.connection.disconnect(var2);
        } else {
            this.connection.setupInboundProtocol(LoginProtocols.SERVERBOUND, new LoginListener(this.server, this.connection, var1));
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails var0) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }
}

