/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.MathHelper;

public class ColorUtil {
    public static int as8BitChannel(float var0) {
        return MathHelper.floor(var0 * 255.0f);
    }

    public static class a {
        public static int alpha(int var0) {
            return var0 >>> 24;
        }

        public static int red(int var0) {
            return var0 & 0xFF;
        }

        public static int green(int var0) {
            return var0 >> 8 & 0xFF;
        }

        public static int blue(int var0) {
            return var0 >> 16 & 0xFF;
        }

        public static int transparent(int var0) {
            return var0 & 0xFFFFFF;
        }

        public static int opaque(int var0) {
            return var0 | 0xFF000000;
        }

        public static int color(int var0, int var1, int var2, int var3) {
            return var0 << 24 | var1 << 16 | var2 << 8 | var3;
        }

        public static int color(int var0, int var1) {
            return var0 << 24 | var1 & 0xFFFFFF;
        }

        public static int fromArgb32(int var0) {
            return var0 & 0xFF00FF00 | (var0 & 0xFF0000) >> 16 | (var0 & 0xFF) << 16;
        }
    }

    public static class b {
        public static int alpha(int var0) {
            return var0 >>> 24;
        }

        public static int red(int var0) {
            return var0 >> 16 & 0xFF;
        }

        public static int green(int var0) {
            return var0 >> 8 & 0xFF;
        }

        public static int blue(int var0) {
            return var0 & 0xFF;
        }

        public static int color(int var0, int var1, int var2, int var3) {
            return var0 << 24 | var1 << 16 | var2 << 8 | var3;
        }

        public static int color(int var0, int var1, int var2) {
            return b.color(255, var0, var1, var2);
        }

        public static int multiply(int var0, int var1) {
            return b.color(b.alpha(var0) * b.alpha(var1) / 255, b.red(var0) * b.red(var1) / 255, b.green(var0) * b.green(var1) / 255, b.blue(var0) * b.blue(var1) / 255);
        }

        public static int lerp(float var0, int var1, int var2) {
            int var3 = MathHelper.lerpInt(var0, b.alpha(var1), b.alpha(var2));
            int var4 = MathHelper.lerpInt(var0, b.red(var1), b.red(var2));
            int var5 = MathHelper.lerpInt(var0, b.green(var1), b.green(var2));
            int var6 = MathHelper.lerpInt(var0, b.blue(var1), b.blue(var2));
            return b.color(var3, var4, var5, var6);
        }

        public static int opaque(int var0) {
            return var0 | 0xFF000000;
        }

        public static int color(int var0, int var1) {
            return var0 << 24 | var1 & 0xFFFFFF;
        }

        public static int colorFromFloat(float var0, float var1, float var2, float var3) {
            return b.color(ColorUtil.as8BitChannel(var0), ColorUtil.as8BitChannel(var1), ColorUtil.as8BitChannel(var2), ColorUtil.as8BitChannel(var3));
        }

        public static int average(int var0, int var1) {
            return b.color((b.alpha(var0) + b.alpha(var1)) / 2, (b.red(var0) + b.red(var1)) / 2, (b.green(var0) + b.green(var1)) / 2, (b.blue(var0) + b.blue(var1)) / 2);
        }
    }
}

