/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.NBTBase;

public class EncoderCache {
    final LoadingCache<a<?, ?>, DataResult<?>> cache;

    public EncoderCache(int var0) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)var0).concurrencyLevel(1).softValues().build(new CacheLoader<a<?, ?>, DataResult<?>>(this){

            public DataResult<?> load(a<?, ?> var0) {
                return var0.resolve();
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((a)object);
            }
        });
    }

    public <A> Codec<A> wrap(final Codec<A> var0) {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var02, T var1) {
                return var0.decode(var02, var1);
            }

            public <T> DataResult<T> encode(A var02, DynamicOps<T> var1, T var2) {
                return ((DataResult)EncoderCache.this.cache.getUnchecked(new a(var0, var02, var1))).map(var0 -> {
                    if (var0 instanceof NBTBase) {
                        NBTBase var1 = (NBTBase)var0;
                        return var1.copy();
                    }
                    return var0;
                });
            }
        };
    }

    record a<A, T>(Codec<A> codec, A value, DynamicOps<T> ops) {
        public DataResult<T> resolve() {
            return this.codec.encodeStart(this.ops, this.value);
        }

        @Override
        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof a) {
                a var1 = (a)var0;
                return this.codec == var1.codec && this.value.equals(var1.value) && this.ops.equals(var1.ops);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int var0 = System.identityHashCode(this.codec);
            var0 = 31 * var0 + this.value.hashCode();
            var0 = 31 * var0 + this.ops.hashCode();
            return var0;
        }
    }
}

