/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.util.FormattedStringEmpty;
import net.minecraft.util.StringDecomposer;

@FunctionalInterface
public interface FormattedString {
    public static final FormattedString EMPTY = var0 -> true;

    public boolean accept(FormattedStringEmpty var1);

    public static FormattedString codepoint(int var0, ChatModifier var1) {
        return var2 -> var2.accept(0, var1, var0);
    }

    public static FormattedString forward(String var0, ChatModifier var1) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var2 -> StringDecomposer.iterate(var0, var1, var2);
    }

    public static FormattedString forward(String var0, ChatModifier var1, Int2IntFunction var2) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var3 -> StringDecomposer.iterate(var0, var1, FormattedString.decorateOutput(var3, var2));
    }

    public static FormattedString backward(String var0, ChatModifier var1) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var2 -> StringDecomposer.iterateBackwards(var0, var1, var2);
    }

    public static FormattedString backward(String var0, ChatModifier var1, Int2IntFunction var2) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var3 -> StringDecomposer.iterateBackwards(var0, var1, FormattedString.decorateOutput(var3, var2));
    }

    public static FormattedStringEmpty decorateOutput(FormattedStringEmpty var0, Int2IntFunction var1) {
        return (var2, var3, var4) -> var0.accept(var2, var3, (Integer)var1.apply((Object)var4));
    }

    public static FormattedString composite() {
        return EMPTY;
    }

    public static FormattedString composite(FormattedString var0) {
        return var0;
    }

    public static FormattedString composite(FormattedString var0, FormattedString var1) {
        return FormattedString.fromPair(var0, var1);
    }

    public static FormattedString composite(FormattedString ... var0) {
        return FormattedString.fromList((List<FormattedString>)ImmutableList.copyOf((Object[])var0));
    }

    public static FormattedString composite(List<FormattedString> var0) {
        int var1 = var0.size();
        switch (var1) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return var0.get(0);
            }
            case 2: {
                return FormattedString.fromPair(var0.get(0), var0.get(1));
            }
        }
        return FormattedString.fromList((List<FormattedString>)ImmutableList.copyOf(var0));
    }

    public static FormattedString fromPair(FormattedString var0, FormattedString var1) {
        return var2 -> var0.accept(var2) && var1.accept(var2);
    }

    public static FormattedString fromList(List<FormattedString> var0) {
        return var1 -> {
            for (FormattedString var3 : var0) {
                if (var3.accept(var1)) continue;
                return false;
            }
            return true;
        };
    }
}

