/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.Validate;

public class DataBitsPacked {
    private static final int BIT_TO_LONG_SHIFT = 6;
    private final long[] data;
    private final int bits;
    private final long mask;
    private final int size;

    public DataBitsPacked(int var0, int var1) {
        this(var0, var1, new long[MathHelper.roundToward(var1 * var0, 64) / 64]);
    }

    public DataBitsPacked(int var0, int var1, long[] var2) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)var0);
        this.size = var1;
        this.bits = var0;
        this.data = var2;
        this.mask = (1L << var0) - 1L;
        int var3 = MathHelper.roundToward(var1 * var0, 64) / 64;
        if (var2.length != var3) {
            throw new IllegalArgumentException("Invalid length given for storage, got: " + var2.length + " but expected: " + var3);
        }
    }

    public void set(int var0, int var1) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        Validate.inclusiveBetween((long)0L, (long)this.mask, (long)var1);
        int var2 = var0 * this.bits;
        int var3 = var2 >> 6;
        int var4 = (var0 + 1) * this.bits - 1 >> 6;
        int var5 = var2 ^ var3 << 6;
        this.data[var3] = this.data[var3] & (this.mask << var5 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)var1 & this.mask) << var5;
        if (var3 != var4) {
            int var6 = 64 - var5;
            int var7 = this.bits - var6;
            this.data[var4] = this.data[var4] >>> var7 << var7 | ((long)var1 & this.mask) >> var6;
        }
    }

    public int get(int var0) {
        Validate.inclusiveBetween((long)0L, (long)(this.size - 1), (long)var0);
        int var1 = var0 * this.bits;
        int var2 = var1 >> 6;
        int var3 = (var0 + 1) * this.bits - 1 >> 6;
        int var4 = var1 ^ var2 << 6;
        if (var2 == var3) {
            return (int)(this.data[var2] >>> var4 & this.mask);
        }
        int var5 = 64 - var4;
        return (int)((this.data[var2] >>> var4 | this.data[var3] << var5) & this.mask);
    }

    public long[] getRaw() {
        return this.data;
    }

    public int getBits() {
        return this.bits;
    }
}

