/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUIDBase;
import org.slf4j.Logger;

public class DataConverterMiscUUID
extends DataConverterUUIDBase {
    private static final Logger LOGGER = LogUtils.getLogger();

    public DataConverterMiscUUID(Schema var0) {
        super(var0, DataConverterTypes.LEVEL);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelUUIDFix", this.getInputSchema().getType(this.typeReference), var0 -> var0.updateTyped(DSL.remainderFinder(), var02 -> var02.update(DSL.remainderFinder(), var0 -> {
            var0 = this.updateCustomBossEvents((Dynamic<?>)var0);
            var0 = this.updateDragonFight((Dynamic<?>)var0);
            var0 = this.updateWanderingTrader((Dynamic<?>)var0);
            return var0;
        })));
    }

    private Dynamic<?> updateWanderingTrader(Dynamic<?> var0) {
        return DataConverterMiscUUID.replaceUUIDString(var0, "WanderingTraderId", "WanderingTraderId").orElse(var0);
    }

    private Dynamic<?> updateDragonFight(Dynamic<?> var0) {
        return var0.update("DimensionData", var02 -> var02.updateMapValues(var0 -> var0.mapSecond(var02 -> var02.update("DragonFight", var0 -> DataConverterMiscUUID.replaceUUIDLeastMost(var0, "DragonUUID", "Dragon").orElse((Dynamic<?>)var0)))));
    }

    private Dynamic<?> updateCustomBossEvents(Dynamic<?> var02) {
        return var02.update("CustomBossEvents", var0 -> var0.updateMapValues(var02 -> var02.mapSecond(var0 -> var0.update("Players", var1 -> var0.createList(var1.asStream().map(var0 -> DataConverterMiscUUID.createUUIDFromML(var0).orElseGet(() -> {
            LOGGER.warn("CustomBossEvents contains invalid UUIDs.");
            return var0;
        })))))));
    }
}

