/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class EffectDurationFix
extends DataFix {
    private static final Set<String> ITEM_TYPES = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public EffectDurationFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema var02 = this.getInputSchema();
        Type var1 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        OpticFinder var22 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.ITEM_NAME.typeName(), DataConverterSchemaNamed.namespacedString()));
        OpticFinder var3 = var1.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EffectDurationEntity", var02.getType(DataConverterTypes.ENTITY), var0 -> var0.update(DSL.remainderFinder(), this::updateEntity)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("EffectDurationPlayer", var02.getType(DataConverterTypes.PLAYER), var0 -> var0.update(DSL.remainderFinder(), this::updateEntity)), this.fixTypeEverywhereTyped("EffectDurationItem", var1, var2 -> {
            Optional var4;
            Optional var3 = var2.getOptional(var22);
            if (var3.filter(ITEM_TYPES::contains).isPresent() && (var4 = var2.getOptionalTyped(var3)).isPresent()) {
                Dynamic var5 = (Dynamic)((Typed)var4.get()).get(DSL.remainderFinder());
                Typed var6 = ((Typed)var4.get()).set(DSL.remainderFinder(), (Object)var5.update("CustomPotionEffects", this::fix));
                return var2.set(var3, var6);
            }
            return var2;
        })});
    }

    private Dynamic<?> fixEffect(Dynamic<?> var0) {
        return var0.update("FactorCalculationData", var1 -> {
            int var2 = var1.get("effect_changed_timestamp").asInt(-1);
            var1 = var1.remove("effect_changed_timestamp");
            int var3 = var0.get("Duration").asInt(-1);
            int var4 = var2 - var3;
            return var1.set("ticks_active", var1.createInt(var4));
        });
    }

    private Dynamic<?> fix(Dynamic<?> var0) {
        return var0.createList(var0.asStream().map(this::fixEffect));
    }

    private Dynamic<?> updateEntity(Dynamic<?> var0) {
        var0 = var0.update("Effects", this::fix);
        var0 = var0.update("ActiveEffects", this::fix);
        var0 = var0.update("CustomPotionEffects", this::fix);
        return var0;
    }
}

