/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.Rule;

public abstract class ParseState<S> {
    private final Map<b<?>, a<?>> ruleCache = new HashMap();
    private final Dictionary<S> dictionary;
    private final ErrorCollector<S> errorCollector;

    protected ParseState(Dictionary<S> var0, ErrorCollector<S> var1) {
        this.dictionary = var0;
        this.errorCollector = var1;
    }

    public ErrorCollector<S> errorCollector() {
        return this.errorCollector;
    }

    public <T> Optional<T> parseTopRule(Atom<T> var0) {
        Optional<T> var1 = this.parse(var0);
        if (var1.isPresent()) {
            this.errorCollector.finish(this.mark());
        }
        return var1;
    }

    public <T> Optional<T> parse(Atom<T> var0) {
        b<T> var1 = new b<T>(var0, this.mark());
        a<T> var2 = this.lookupInCache(var1);
        if (var2 != null) {
            this.restore(var2.mark());
            return var2.value;
        }
        Rule<S, T> var3 = this.dictionary.get(var0);
        if (var3 == null) {
            throw new IllegalStateException("No symbol " + String.valueOf(var0));
        }
        Optional<T> var4 = var3.parse(this);
        this.storeInCache(var1, var4);
        return var4;
    }

    @Nullable
    private <T> a<T> lookupInCache(b<T> var0) {
        return this.ruleCache.get(var0);
    }

    private <T> void storeInCache(b<T> var0, Optional<T> var1) {
        this.ruleCache.put(var0, new a<T>(var1, this.mark()));
    }

    public abstract S input();

    public abstract int mark();

    public abstract void restore(int var1);

    record b<T>(Atom<T> name, int mark) {
    }

    static final class a<T>
    extends Record {
        final Optional<T> value;
        private final int mark;

        a(Optional<T> var0, int var1) {
            this.value = var0;
            this.mark = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "value;mark", "value", "mark"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "value;mark", "value", "mark"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "value;mark", "value", "mark"}, this, var0);
        }

        public Optional<T> value() {
            return this.value;
        }

        public int mark() {
            return this.mark;
        }
    }
}

