/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.List;
import java.util.Optional;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import org.apache.commons.lang3.mutable.MutableBoolean;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S> Term<S> named(Atom<?> var0) {
        return new d(var0);
    }

    public static <S, T> Term<S> marker(Atom<T> var0, T var1) {
        return new b(var0, var1);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... var0) {
        return new e<S>(List.of(var0));
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... var0) {
        return new a<S>(List.of(var0));
    }

    public static <S> Term<S> optional(Term<S> var0) {
        return new c<S>(var0);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
                var2.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public record d<S, T>(Atom<T> name) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            Optional<T> var3 = var0.parse(this.name);
            if (var3.isEmpty()) {
                return false;
            }
            var1.put(this.name, var3.get());
            return true;
        }
    }

    public record b<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            var1.put(this.name, this.value);
            return true;
        }
    }

    public record e<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var3 = var0.mark();
            for (Term<S> var5 : this.elements) {
                if (var5.parse(var0, var1, var2)) continue;
                var0.restore(var3);
                return false;
            }
            return true;
        }
    }

    public record a<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            MutableBoolean var3 = new MutableBoolean();
            Control var4 = () -> ((MutableBoolean)var3).setTrue();
            int var5 = var0.mark();
            for (Term<S> var7 : this.elements) {
                if (var3.isTrue()) break;
                Scope var8 = new Scope();
                if (var7.parse(var0, var8, var4)) {
                    var1.putAll(var8);
                    return true;
                }
                var0.restore(var5);
            }
            return false;
        }
    }

    public record c<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            int var3 = var0.mark();
            if (!this.term.parse(var0, var1, var2)) {
                var0.restore(var3);
            }
            return true;
        }
    }
}

