/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import java.util.function.Supplier;
import net.minecraft.util.profiling.GameProfilerDisabled;
import net.minecraft.util.profiling.metrics.MetricCategory;

public interface GameProfilerFiller {
    public static final String ROOT = "root";

    public void startTick();

    public void endTick();

    public void push(String var1);

    public void push(Supplier<String> var1);

    public void pop();

    public void popPush(String var1);

    public void popPush(Supplier<String> var1);

    public void markForCharting(MetricCategory var1);

    default public void incrementCounter(String var0) {
        this.incrementCounter(var0, 1);
    }

    public void incrementCounter(String var1, int var2);

    default public void incrementCounter(Supplier<String> var0) {
        this.incrementCounter(var0, 1);
    }

    public void incrementCounter(Supplier<String> var1, int var2);

    public static GameProfilerFiller tee(final GameProfilerFiller var0, final GameProfilerFiller var1) {
        if (var0 == GameProfilerDisabled.INSTANCE) {
            return var1;
        }
        if (var1 == GameProfilerDisabled.INSTANCE) {
            return var0;
        }
        return new GameProfilerFiller(){

            @Override
            public void startTick() {
                var0.startTick();
                var1.startTick();
            }

            @Override
            public void endTick() {
                var0.endTick();
                var1.endTick();
            }

            @Override
            public void push(String var02) {
                var0.push(var02);
                var1.push(var02);
            }

            @Override
            public void push(Supplier<String> var02) {
                var0.push(var02);
                var1.push(var02);
            }

            @Override
            public void markForCharting(MetricCategory var02) {
                var0.markForCharting(var02);
                var1.markForCharting(var02);
            }

            @Override
            public void pop() {
                var0.pop();
                var1.pop();
            }

            @Override
            public void popPush(String var02) {
                var0.popPush(var02);
                var1.popPush(var02);
            }

            @Override
            public void popPush(Supplier<String> var02) {
                var0.popPush(var02);
                var1.popPush(var02);
            }

            @Override
            public void incrementCounter(String var02, int var12) {
                var0.incrementCounter(var02, var12);
                var1.incrementCounter(var02, var12);
            }

            @Override
            public void incrementCounter(Supplier<String> var02, int var12) {
                var0.incrementCounter(var02, var12);
                var1.incrementCounter(var02, var12);
            }
        };
    }
}

