/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import net.minecraft.util.profiling.GameProfilerDisabled;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerFillerActive;
import net.minecraft.util.profiling.MethodProfiler;
import net.minecraft.util.profiling.MethodProfilerResults;

public class GameProfilerSwitcher {
    private final LongSupplier realTime;
    private final IntSupplier tickCount;
    private GameProfilerFillerActive profiler = GameProfilerDisabled.INSTANCE;

    public GameProfilerSwitcher(LongSupplier var0, IntSupplier var1) {
        this.realTime = var0;
        this.tickCount = var1;
    }

    public boolean isEnabled() {
        return this.profiler != GameProfilerDisabled.INSTANCE;
    }

    public void disable() {
        this.profiler = GameProfilerDisabled.INSTANCE;
    }

    public void enable() {
        this.profiler = new MethodProfiler(this.realTime, this.tickCount, true);
    }

    public GameProfilerFiller getFiller() {
        return this.profiler;
    }

    public MethodProfilerResults getResults() {
        return this.profiler.getResults();
    }
}

