/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.ItemStack;

public final class ChestLock
extends Record {
    public final String key;
    public static final ChestLock NO_LOCK = new ChestLock("");
    public static final Codec<ChestLock> CODEC = Codec.STRING.xmap(ChestLock::new, ChestLock::key);
    public static final String TAG_LOCK = "Lock";

    public ChestLock(String var0) {
        this.key = var0;
    }

    public boolean unlocksWith(ItemStack var0) {
        if (this.key.isEmpty()) {
            return true;
        }
        IChatBaseComponent var1 = var0.get(DataComponents.CUSTOM_NAME);
        return var1 != null && this.key.equals(var1.getString());
    }

    public void addToTag(NBTTagCompound var0) {
        if (!this.key.isEmpty()) {
            var0.putString(TAG_LOCK, this.key);
        }
    }

    public static ChestLock fromTag(NBTTagCompound var0) {
        if (var0.contains(TAG_LOCK, 8)) {
            return new ChestLock(var0.getString(TAG_LOCK));
        }
        return NO_LOCK;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChestLock.class, "key", "key"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ChestLock.class, "key", "key"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ChestLock.class, "key", "key"}, this, var0);
    }

    public String key() {
        return this.key;
    }
}

