/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public interface EquipmentUser {
    public void setItemSlot(EnumItemSlot var1, ItemStack var2);

    public ItemStack getItemBySlot(EnumItemSlot var1);

    public void setDropChance(EnumItemSlot var1, float var2);

    default public void equip(EquipmentTable var0, LootParams var1) {
        this.equip(var0.lootTable(), var1, var0.slotDropChances());
    }

    default public void equip(ResourceKey<LootTable> var0, LootParams var1, Map<EnumItemSlot, Float> var2) {
        this.equip(var0, var1, 0L, var2);
    }

    default public void equip(ResourceKey<LootTable> var0, LootParams var1, long var2, Map<EnumItemSlot, Float> var4) {
        if (var0.equals(LootTables.EMPTY)) {
            return;
        }
        LootTable var5 = var1.getLevel().getServer().reloadableRegistries().getLootTable(var0);
        if (var5 == LootTable.EMPTY) {
            return;
        }
        ObjectArrayList<ItemStack> var6 = var5.getRandomItems(var1, var2);
        ArrayList<EnumItemSlot> var7 = new ArrayList<EnumItemSlot>();
        for (ItemStack var9 : var6) {
            EnumItemSlot var10 = this.resolveSlot(var9, var7);
            if (var10 == null) continue;
            ItemStack var11 = var10.limit(var9);
            this.setItemSlot(var10, var11);
            Float var12 = var4.get(var10);
            if (var12 != null) {
                this.setDropChance(var10, var12.floatValue());
            }
            var7.add(var10);
        }
    }

    @Nullable
    default public EnumItemSlot resolveSlot(ItemStack var0, List<EnumItemSlot> var1) {
        if (var0.isEmpty()) {
            return null;
        }
        Equipable var2 = Equipable.get(var0);
        if (var2 != null) {
            EnumItemSlot var3 = var2.getEquipmentSlot();
            if (!var1.contains(var3)) {
                return var3;
            }
        } else if (!var1.contains(EnumItemSlot.MAINHAND)) {
            return EnumItemSlot.MAINHAND;
        }
        return null;
    }
}

