/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 10.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;

    @Nullable
    public a getLeashData();

    public void setLeashData(@Nullable a var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedToIt() {
        return this.canBeLeashed() && !this.isLeashed();
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int var0) {
        this.setLeashData(new a(var0));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    @Nullable
    default public a readLeashData(NBTTagCompound var0) {
        Either var1;
        if (var0.contains(LEASH_TAG, 10)) {
            return new a((Either<UUID, BlockPosition>)Either.left((Object)var0.getCompound(LEASH_TAG).getUUID("UUID")));
        }
        if (var0.contains(LEASH_TAG, 11) && (var1 = (Either)GameProfileSerializer.readBlockPos(var0, LEASH_TAG).map(Either::right).orElse(null)) != null) {
            return new a((Either<UUID, BlockPosition>)var1);
        }
        return null;
    }

    default public void writeLeashData(NBTTagCompound var02, @Nullable a var1) {
        if (var1 == null) {
            return;
        }
        Either var2 = var1.delayedLeashInfo;
        Entity entity = var1.leashHolder;
        if (entity instanceof EntityLeash) {
            EntityLeash var3 = (EntityLeash)entity;
            var2 = Either.right((Object)var3.getPos());
        } else if (var1.leashHolder != null) {
            var2 = Either.left((Object)var1.leashHolder.getUUID());
        }
        if (var2 == null) {
            return;
        }
        var02.put(LEASH_TAG, (NBTBase)var2.map(var0 -> {
            NBTTagCompound var1 = new NBTTagCompound();
            var1.putUUID("UUID", (UUID)var0);
            return var1;
        }, GameProfileSerializer::writeBlockPos));
    }

    private static <E extends Entity> void restoreLeashFromSave(E var0, a var1) {
        World world;
        if (var1.delayedLeashInfo != null && (world = var0.level()) instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            Optional var3 = var1.delayedLeashInfo.left();
            Optional var4 = var1.delayedLeashInfo.right();
            if (var3.isPresent()) {
                Entity var5 = var2.getEntity((UUID)var3.get());
                if (var5 != null) {
                    Leashable.setLeashedTo(var0, var5, true);
                    return;
                }
            } else if (var4.isPresent()) {
                Leashable.setLeashedTo(var0, EntityLeash.getOrCreateKnot(var2, (BlockPosition)var4.get()), true);
                return;
            }
            if (var0.tickCount > 100) {
                var0.spawnAtLocation(Items.LEAD);
                ((Leashable)((Object)var0)).setLeashData(null);
            }
        }
    }

    default public void dropLeash(boolean var0, boolean var1) {
        Leashable.dropLeash((Entity)((Object)this), var0, var1);
    }

    private static <E extends Entity> void dropLeash(E var0, boolean var1, boolean var2) {
        a var3 = ((Leashable)((Object)var0)).getLeashData();
        if (var3 != null && var3.leashHolder != null) {
            World world;
            ((Leashable)((Object)var0)).setLeashData(null);
            if (!var0.level().isClientSide && var2) {
                var0.spawnAtLocation(Items.LEAD);
            }
            if (var1 && (world = var0.level()) instanceof WorldServer) {
                WorldServer var4 = (WorldServer)world;
                var4.getChunkSource().broadcast(var0, new PacketPlayOutAttachEntity(var0, null));
            }
        }
    }

    public static <E extends Entity> void tickLeash(E var0) {
        Entity var2;
        a var1 = ((Leashable)((Object)var0)).getLeashData();
        if (var1 != null && var1.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(var0, var1);
        }
        if (var1 == null || var1.leashHolder == null) {
            return;
        }
        if (!var0.isAlive() || !var1.leashHolder.isAlive()) {
            Leashable.dropLeash(var0, true, true);
        }
        if ((var2 = ((Leashable)((Object)var0)).getLeashHolder()) != null && var2.level() == var0.level()) {
            float var3 = var0.distanceTo(var2);
            if (!((Leashable)((Object)var0)).handleLeashAtDistance(var2, var3)) {
                return;
            }
            if ((double)var3 > 10.0) {
                ((Leashable)((Object)var0)).leashTooFarBehaviour();
            } else if ((double)var3 > 6.0) {
                ((Leashable)((Object)var0)).elasticRangeLeashBehaviour(var2, var3);
                var0.checkSlowFallDistance();
            } else {
                ((Leashable)((Object)var0)).closeRangeLeashBehaviour(var2);
            }
        }
    }

    default public boolean handleLeashAtDistance(Entity var0, float var1) {
        return true;
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash(true, true);
    }

    default public void closeRangeLeashBehaviour(Entity var0) {
    }

    default public void elasticRangeLeashBehaviour(Entity var0, float var1) {
        Leashable.legacyElasticRangeLeashBehaviour((Entity)((Object)this), var0, var1);
    }

    private static <E extends Entity> void legacyElasticRangeLeashBehaviour(E var0, Entity var1, float var2) {
        double var3 = (var1.getX() - var0.getX()) / (double)var2;
        double var5 = (var1.getY() - var0.getY()) / (double)var2;
        double var7 = (var1.getZ() - var0.getZ()) / (double)var2;
        var0.setDeltaMovement(var0.getDeltaMovement().add(Math.copySign(var3 * var3 * 0.4, var3), Math.copySign(var5 * var5 * 0.4, var5), Math.copySign(var7 * var7 * 0.4, var7)));
    }

    default public void setLeashedTo(Entity var0, boolean var1) {
        Leashable.setLeashedTo((Entity)((Object)this), var0, var1);
    }

    private static <E extends Entity> void setLeashedTo(E var0, Entity var1, boolean var2) {
        World world;
        a var3 = ((Leashable)((Object)var0)).getLeashData();
        if (var3 == null) {
            var3 = new a(var1);
            ((Leashable)((Object)var0)).setLeashData(var3);
        } else {
            var3.setLeashHolder(var1);
        }
        if (var2 && (world = var0.level()) instanceof WorldServer) {
            WorldServer var4 = (WorldServer)world;
            var4.getChunkSource().broadcast(var0, new PacketPlayOutAttachEntity(var0, var1));
        }
        if (var0.isPassenger()) {
            var0.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E var0) {
        Entity entity;
        a var1 = ((Leashable)((Object)var0)).getLeashData();
        if (var1 == null) {
            return null;
        }
        if (var1.delayedLeashHolderId != 0 && var0.level().isClientSide && (entity = var0.level().getEntity(var1.delayedLeashHolderId)) instanceof Entity) {
            Entity var2 = entity;
            var1.setLeashHolder(var2);
        }
        return var1.leashHolder;
    }

    public static final class a {
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPosition> delayedLeashInfo;

        a(Either<UUID, BlockPosition> var0) {
            this.delayedLeashInfo = var0;
        }

        a(Entity var0) {
            this.leashHolder = var0;
        }

        a(int var0) {
            this.delayedLeashHolderId = var0;
        }

        public void setLeashHolder(Entity var0) {
            this.leashHolder = var0;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }
}

