/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;

public class SaddleStorage {
    private static final int MIN_BOOST_TIME = 140;
    private static final int MAX_BOOST_TIME = 700;
    private final DataWatcher entityData;
    private final DataWatcherObject<Integer> boostTimeAccessor;
    private final DataWatcherObject<Boolean> hasSaddleAccessor;
    public boolean boosting;
    public int boostTime;

    public SaddleStorage(DataWatcher var0, DataWatcherObject<Integer> var1, DataWatcherObject<Boolean> var2) {
        this.entityData = var0;
        this.boostTimeAccessor = var1;
        this.hasSaddleAccessor = var2;
    }

    public void onSynced() {
        this.boosting = true;
        this.boostTime = 0;
    }

    public boolean boost(RandomSource var0) {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.entityData.set(this.boostTimeAccessor, var0.nextInt(841) + 140);
        return true;
    }

    public void tickBoost() {
        if (this.boosting && this.boostTime++ > this.boostTimeTotal()) {
            this.boosting = false;
        }
    }

    public float boostFactor() {
        if (this.boosting) {
            return 1.0f + 1.15f * MathHelper.sin((float)this.boostTime / (float)this.boostTimeTotal() * (float)Math.PI);
        }
        return 1.0f;
    }

    public int boostTimeTotal() {
        return this.entityData.get(this.boostTimeAccessor);
    }

    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putBoolean("Saddle", this.hasSaddle());
    }

    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.setSaddle(var0.getBoolean("Saddle"));
    }

    public void setSaddle(boolean var0) {
        this.entityData.set(this.hasSaddleAccessor, var0);
    }

    public boolean hasSaddle() {
        return this.entityData.get(this.hasSaddleAccessor);
    }
}

