/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public class BehavorMove
extends Behavior<EntityInsentient> {
    private static final int MAX_COOLDOWN_BEFORE_RETRYING = 40;
    private int remainingCooldown;
    @Nullable
    private PathEntity path;
    @Nullable
    private BlockPosition lastTargetPos;
    private float speedModifier;

    public BehavorMove() {
        this(150, 250);
    }

    public BehavorMove(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.PATH, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), var0, var1);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
        if (this.remainingCooldown > 0) {
            --this.remainingCooldown;
            return false;
        }
        BehaviorController<?> var2 = var1.getBrain();
        MemoryTarget var3 = var2.getMemory(MemoryModuleType.WALK_TARGET).get();
        boolean var4 = this.reachedTarget(var1, var3);
        if (!var4 && this.tryComputePath(var1, var3, var0.getGameTime())) {
            this.lastTargetPos = var3.getTarget().currentBlockPosition();
            return true;
        }
        var2.eraseMemory(MemoryModuleType.WALK_TARGET);
        if (var4) {
            var2.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        }
        return false;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityInsentient var1, long var2) {
        if (this.path == null || this.lastTargetPos == null) {
            return false;
        }
        Optional<MemoryTarget> var4 = var1.getBrain().getMemory(MemoryModuleType.WALK_TARGET);
        boolean var5 = var4.map(BehavorMove::isWalkTargetSpectator).orElse(false);
        NavigationAbstract var6 = var1.getNavigation();
        return !var6.isDone() && var4.isPresent() && !this.reachedTarget(var1, var4.get()) && !var5;
    }

    @Override
    protected void stop(WorldServer var0, EntityInsentient var1, long var2) {
        if (var1.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET) && !this.reachedTarget(var1, var1.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get()) && var1.getNavigation().isStuck()) {
            this.remainingCooldown = var0.getRandom().nextInt(40);
        }
        var1.getNavigation().stop();
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.PATH);
        this.path = null;
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        var1.getBrain().setMemory(MemoryModuleType.PATH, this.path);
        var1.getNavigation().moveTo(this.path, (double)this.speedModifier);
    }

    @Override
    protected void tick(WorldServer var0, EntityInsentient var1, long var2) {
        PathEntity var4 = var1.getNavigation().getPath();
        BehaviorController<?> var5 = var1.getBrain();
        if (this.path != var4) {
            this.path = var4;
            var5.setMemory(MemoryModuleType.PATH, var4);
        }
        if (var4 == null || this.lastTargetPos == null) {
            return;
        }
        MemoryTarget var6 = var5.getMemory(MemoryModuleType.WALK_TARGET).get();
        if (var6.getTarget().currentBlockPosition().distSqr(this.lastTargetPos) > 4.0 && this.tryComputePath(var1, var6, var0.getGameTime())) {
            this.lastTargetPos = var6.getTarget().currentBlockPosition();
            this.start(var0, var1, var2);
        }
    }

    private boolean tryComputePath(EntityInsentient var0, MemoryTarget var1, long var2) {
        BlockPosition var4 = var1.getTarget().currentBlockPosition();
        this.path = var0.getNavigation().createPath(var4, 0);
        this.speedModifier = var1.getSpeedModifier();
        BehaviorController<Long> var5 = var0.getBrain();
        if (this.reachedTarget(var0, var1)) {
            var5.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        } else {
            boolean var6;
            boolean bl = var6 = this.path != null && this.path.canReach();
            if (var6) {
                var5.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            } else if (!var5.hasMemoryValue(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)) {
                var5.setMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, var2);
            }
            if (this.path != null) {
                return true;
            }
            Vec3D var7 = DefaultRandomPos.getPosTowards((EntityCreature)var0, 10, 7, Vec3D.atBottomCenterOf(var4), 1.5707963705062866);
            if (var7 != null) {
                this.path = var0.getNavigation().createPath(var7.x, var7.y, var7.z, 0);
                return this.path != null;
            }
        }
        return false;
    }

    private boolean reachedTarget(EntityInsentient var0, MemoryTarget var1) {
        return var1.getTarget().currentBlockPosition().distManhattan(var0.blockPosition()) <= var1.getCloseEnoughDist();
    }

    private static boolean isWalkTargetSpectator(MemoryTarget var0) {
        BehaviorPosition var1 = var0.getTarget();
        if (var1 instanceof BehaviorPositionEntity) {
            BehaviorPositionEntity var2 = (BehaviorPositionEntity)var1;
            return var2.getEntity().isSpectator();
        }
        return false;
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityInsentient)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityInsentient)entityLiving, l2);
    }
}

