/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int TIME_OUT_DURATION = 160;
    private final ToIntFunction<E> getCooldownOnFail;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float walkSpeed;
    private final PathfinderTargetCondition ramTargeting;
    private final int ramPrepareTime;
    private final Function<E, SoundEffect> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<a> ramCandidate = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> var0, int var1, int var2, float var3, PathfinderTargetCondition var4, int var5, Function<E, SoundEffect> var6) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.RAM_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 160);
        this.getCooldownOnFail = var0;
        this.minRamDistance = var1;
        this.maxRamDistance = var2;
        this.walkSpeed = var3;
        this.ramTargeting = var4;
        this.ramPrepareTime = var5;
        this.getPrepareRamSound = var6;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var13, long var2) {
        BehaviorController<?> var4 = var13.getBrain();
        var4.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(var12 -> var12.findClosest(var1 -> this.ramTargeting.test(var13, (EntityLiving)var1))).ifPresent(var1 -> this.chooseRamPosition(var13, (EntityLiving)var1));
    }

    @Override
    protected void stop(WorldServer var0, E var1, long var2) {
        BehaviorController<Vec3D> var4 = ((EntityLiving)var1).getBrain();
        if (!var4.hasMemoryValue(MemoryModuleType.RAM_TARGET)) {
            var0.broadcastEntityEvent((Entity)var1, (byte)59);
            var4.setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, this.getCooldownOnFail.applyAsInt(var1));
        }
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().getTarget().isAlive();
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        boolean var4;
        if (this.ramCandidate.isEmpty()) {
            return;
        }
        ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(this.ramCandidate.get().getStartPosition(), this.walkSpeed, 0));
        ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(this.ramCandidate.get().getTarget(), true));
        boolean bl = var4 = !this.ramCandidate.get().getTarget().blockPosition().equals(this.ramCandidate.get().getTargetPosition());
        if (var4) {
            var0.broadcastEntityEvent((Entity)var1, (byte)59);
            ((EntityInsentient)var1).getNavigation().stop();
            this.chooseRamPosition((EntityCreature)var1, this.ramCandidate.get().target);
        } else {
            BlockPosition var5 = ((Entity)var1).blockPosition();
            if (var5.equals(this.ramCandidate.get().getStartPosition())) {
                var0.broadcastEntityEvent((Entity)var1, (byte)58);
                if (this.reachedRamPositionTimestamp.isEmpty()) {
                    this.reachedRamPositionTimestamp = Optional.of(var2);
                }
                if (var2 - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                    ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.RAM_TARGET, this.getEdgeOfBlock(var5, this.ramCandidate.get().getTargetPosition()));
                    var0.playSound(null, (Entity)var1, this.getPrepareRamSound.apply(var1), SoundCategory.NEUTRAL, 1.0f, ((EntityLiving)var1).getVoicePitch());
                    this.ramCandidate = Optional.empty();
                }
            }
        }
    }

    private Vec3D getEdgeOfBlock(BlockPosition var0, BlockPosition var1) {
        double var2 = 0.5;
        double var4 = 0.5 * (double)MathHelper.sign(var1.getX() - var0.getX());
        double var6 = 0.5 * (double)MathHelper.sign(var1.getZ() - var0.getZ());
        return Vec3D.atBottomCenterOf(var1).add(var4, 0.0, var6);
    }

    private Optional<BlockPosition> calculateRammingStartPosition(EntityCreature var0, EntityLiving var12) {
        BlockPosition var2 = var12.blockPosition();
        if (!this.isWalkableBlock(var0, var2)) {
            return Optional.empty();
        }
        ArrayList var3 = Lists.newArrayList();
        BlockPosition.MutableBlockPosition var4 = var2.mutable();
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            var4.set(var2);
            for (int var7 = 0; var7 < this.maxRamDistance; ++var7) {
                if (this.isWalkableBlock(var0, var4.move(var6))) continue;
                var4.move(var6.getOpposite());
                break;
            }
            if (var4.distManhattan(var2) < this.minRamDistance) continue;
            var3.add(var4.immutable());
        }
        NavigationAbstract var5 = var0.getNavigation();
        return var3.stream().sorted(Comparator.comparingDouble(var0.blockPosition()::distSqr)).filter(var1 -> {
            PathEntity var2 = var5.createPath((BlockPosition)var1, 0);
            return var2 != null && var2.canReach();
        }).findFirst();
    }

    private boolean isWalkableBlock(EntityCreature var0, BlockPosition var1) {
        return var0.getNavigation().isStableDestination(var1) && var0.getPathfindingMalus(PathfinderNormal.getPathTypeStatic(var0, var1)) == 0.0f;
    }

    private void chooseRamPosition(EntityCreature var0, EntityLiving var12) {
        this.reachedRamPositionTimestamp = Optional.empty();
        this.ramCandidate = this.calculateRammingStartPosition(var0, var12).map(var1 -> new a((BlockPosition)var1, var12.blockPosition(), var12));
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (E)((EntityCreature)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }

    public static class a {
        private final BlockPosition startPosition;
        private final BlockPosition targetPosition;
        final EntityLiving target;

        public a(BlockPosition var0, BlockPosition var1, EntityLiving var2) {
            this.startPosition = var0;
            this.targetPosition = var1;
            this.target = var2;
        }

        public BlockPosition getStartPosition() {
            return this.startPosition;
        }

        public BlockPosition getTargetPosition() {
            return this.targetPosition;
        }

        public EntityLiving getTarget() {
            return this.target;
        }
    }
}

