/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalBreath
extends PathfinderGoal {
    private final EntityCreature mob;

    public PathfinderGoalBreath(EntityCreature var0) {
        this.mob = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        return this.mob.getAirSupply() < 140;
    }

    @Override
    public boolean canContinueToUse() {
        return this.canUse();
    }

    @Override
    public boolean isInterruptable() {
        return false;
    }

    @Override
    public void start() {
        this.findAirPosition();
    }

    private void findAirPosition() {
        Iterable<BlockPosition> var0 = BlockPosition.betweenClosed(MathHelper.floor(this.mob.getX() - 1.0), this.mob.getBlockY(), MathHelper.floor(this.mob.getZ() - 1.0), MathHelper.floor(this.mob.getX() + 1.0), MathHelper.floor(this.mob.getY() + 8.0), MathHelper.floor(this.mob.getZ() + 1.0));
        BaseBlockPosition var1 = null;
        for (BlockPosition var3 : var0) {
            if (!this.givesAir(this.mob.level(), var3)) continue;
            var1 = var3;
            break;
        }
        if (var1 == null) {
            var1 = BlockPosition.containing(this.mob.getX(), this.mob.getY() + 8.0, this.mob.getZ());
        }
        this.mob.getNavigation().moveTo(var1.getX(), var1.getY() + 1, var1.getZ(), 1.0);
    }

    @Override
    public void tick() {
        this.findAirPosition();
        this.mob.moveRelative(0.02f, new Vec3D(this.mob.xxa, this.mob.yya, this.mob.zza));
        this.mob.move(EnumMoveType.SELF, this.mob.getDeltaMovement());
    }

    private boolean givesAir(IWorldReader var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return (var0.getFluidState(var1).isEmpty() || var2.is(Blocks.BUBBLE_COLUMN)) && var2.isPathfindable(PathMode.LAND);
    }
}

