/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AxisAlignedBB;

public class PathfinderGoalHurtByTarget
extends PathfinderGoalTarget {
    private static final PathfinderTargetCondition HURT_BY_TARGETING = PathfinderTargetCondition.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
    private static final int ALERT_RANGE_Y = 10;
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    @Nullable
    private Class<?>[] toIgnoreAlert;

    public PathfinderGoalHurtByTarget(EntityCreature var0, Class<?> ... var1) {
        super(var0, true);
        this.toIgnoreDamage = var1;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
    }

    @Override
    public boolean canUse() {
        int var0 = this.mob.getLastHurtByMobTimestamp();
        EntityLiving var1 = this.mob.getLastHurtByMob();
        if (var0 == this.timestamp || var1 == null) {
            return false;
        }
        if (var1.getType() == EntityTypes.PLAYER && this.mob.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
            return false;
        }
        for (Class<?> var5 : this.toIgnoreDamage) {
            if (!var5.isAssignableFrom(var1.getClass())) continue;
            return false;
        }
        return this.canAttack(var1, HURT_BY_TARGETING);
    }

    public PathfinderGoalHurtByTarget setAlertOthers(Class<?> ... var0) {
        this.alertSameType = true;
        this.toIgnoreAlert = var0;
        return this;
    }

    @Override
    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob());
        this.targetMob = this.mob.getTarget();
        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.unseenMemoryTicks = 300;
        if (this.alertSameType) {
            this.alertOthers();
        }
        super.start();
    }

    protected void alertOthers() {
        double var0 = this.getFollowDistance();
        AxisAlignedBB var2 = AxisAlignedBB.unitCubeFromLowerCorner(this.mob.position()).inflate(var0, 10.0, var0);
        List<Entity> var3 = this.mob.level().getEntitiesOfClass(this.mob.getClass(), var2, IEntitySelector.NO_SPECTATORS);
        for (EntityInsentient entityInsentient : var3) {
            if (this.mob == entityInsentient || entityInsentient.getTarget() != null || this.mob instanceof EntityTameableAnimal && ((EntityTameableAnimal)this.mob).getOwner() != ((EntityTameableAnimal)entityInsentient).getOwner() || entityInsentient.isAlliedTo(this.mob.getLastHurtByMob())) continue;
            if (this.toIgnoreAlert != null) {
                boolean var6 = false;
                for (Class<?> var10 : this.toIgnoreAlert) {
                    if (entityInsentient.getClass() != var10) continue;
                    var6 = true;
                    break;
                }
                if (var6) continue;
            }
            this.alertOther(entityInsentient, this.mob.getLastHurtByMob());
        }
    }

    protected void alertOther(EntityInsentient var0, EntityLiving var1) {
        var0.setTarget(var1);
    }
}

