/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AxisAlignedBB;

public class SensorNearestLivingEntities<T extends EntityLiving>
extends Sensor<T> {
    @Override
    protected void doTick(WorldServer var0, T var12) {
        AxisAlignedBB var2 = ((Entity)var12).getBoundingBox().inflate(this.radiusXZ(), this.radiusY(), this.radiusXZ());
        List<EntityLiving> var3 = var0.getEntitiesOfClass(EntityLiving.class, var2, var1 -> var1 != var12 && var1.isAlive());
        var3.sort(Comparator.comparingDouble(arg_0 -> var12.distanceToSqr(arg_0)));
        BehaviorController<?> var4 = ((EntityLiving)var12).getBrain();
        var4.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, var3);
        var4.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, new NearestVisibleLivingEntities((EntityLiving)var12, var3));
    }

    protected int radiusXZ() {
        return 16;
    }

    protected int radiusY() {
        return 16;
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

