/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.util.RandomPositionGenerator;
import net.minecraft.world.phys.Vec3D;

public class DefaultRandomPos {
    @Nullable
    public static Vec3D getPos(EntityCreature var0, int var1, int var2) {
        boolean var3 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return RandomPositionGenerator.generateRandomPos(var0, () -> {
            BlockPosition var4 = RandomPositionGenerator.generateRandomDirection(var0.getRandom(), var1, var2);
            return DefaultRandomPos.generateRandomPosTowardDirection(var0, var1, var3, var4);
        });
    }

    @Nullable
    public static Vec3D getPosTowards(EntityCreature var0, int var1, int var2, Vec3D var3, double var4) {
        Vec3D var6 = var3.subtract(var0.getX(), var0.getY(), var0.getZ());
        boolean var7 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return RandomPositionGenerator.generateRandomPos(var0, () -> {
            BlockPosition var7 = RandomPositionGenerator.generateRandomDirectionWithinRadians(var0.getRandom(), var1, var2, 0, var3.x, var3.z, var4);
            if (var7 == null) {
                return null;
            }
            return DefaultRandomPos.generateRandomPosTowardDirection(var0, var1, var7, var7);
        });
    }

    @Nullable
    public static Vec3D getPosAway(EntityCreature var0, int var1, int var2, Vec3D var3) {
        Vec3D var4 = var0.position().subtract(var3);
        boolean var5 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return RandomPositionGenerator.generateRandomPos(var0, () -> {
            BlockPosition var5 = RandomPositionGenerator.generateRandomDirectionWithinRadians(var0.getRandom(), var1, var2, 0, var3.x, var3.z, 1.5707963705062866);
            if (var5 == null) {
                return null;
            }
            return DefaultRandomPos.generateRandomPosTowardDirection(var0, var1, var5, var5);
        });
    }

    @Nullable
    private static BlockPosition generateRandomPosTowardDirection(EntityCreature var0, int var1, boolean var2, BlockPosition var3) {
        BlockPosition var4 = RandomPositionGenerator.generateRandomPosTowardDirection(var0, var1, var0.getRandom(), var3);
        if (PathfinderGoalUtil.isOutsideLimits(var4, var0) || PathfinderGoalUtil.isRestricted(var2, var0, var4) || PathfinderGoalUtil.isNotStable(var0.getNavigation(), var4) || PathfinderGoalUtil.hasMalus(var0, var4)) {
            return null;
        }
        return var4;
    }
}

