/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.util.RandomPositionGenerator;
import net.minecraft.world.phys.Vec3D;

public class LandRandomPos {
    @Nullable
    public static Vec3D getPos(EntityCreature var0, int var1, int var2) {
        return LandRandomPos.getPos(var0, var1, var2, var0::getWalkTargetValue);
    }

    @Nullable
    public static Vec3D getPos(EntityCreature var0, int var1, int var2, ToDoubleFunction<BlockPosition> var3) {
        boolean var4 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return RandomPositionGenerator.generateRandomPos(() -> {
            BlockPosition var4 = RandomPositionGenerator.generateRandomDirection(var0.getRandom(), var1, var2);
            BlockPosition var5 = LandRandomPos.generateRandomPosTowardDirection(var0, var1, var4, var4);
            if (var5 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(var0, var5);
        }, var3);
    }

    @Nullable
    public static Vec3D getPosTowards(EntityCreature var0, int var1, int var2, Vec3D var3) {
        Vec3D var4 = var3.subtract(var0.getX(), var0.getY(), var0.getZ());
        boolean var5 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return LandRandomPos.getPosInDirection(var0, var1, var2, var4, var5);
    }

    @Nullable
    public static Vec3D getPosAway(EntityCreature var0, int var1, int var2, Vec3D var3) {
        Vec3D var4 = var0.position().subtract(var3);
        boolean var5 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return LandRandomPos.getPosInDirection(var0, var1, var2, var4, var5);
    }

    @Nullable
    private static Vec3D getPosInDirection(EntityCreature var0, int var1, int var2, Vec3D var3, boolean var4) {
        return RandomPositionGenerator.generateRandomPos(var0, () -> {
            BlockPosition var5 = RandomPositionGenerator.generateRandomDirectionWithinRadians(var0.getRandom(), var1, var2, 0, var3.x, var3.z, 1.5707963705062866);
            if (var5 == null) {
                return null;
            }
            BlockPosition var6 = LandRandomPos.generateRandomPosTowardDirection(var0, var1, var4, var5);
            if (var6 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(var0, var6);
        });
    }

    @Nullable
    public static BlockPosition movePosUpOutOfSolid(EntityCreature var0, BlockPosition var12) {
        if (PathfinderGoalUtil.isWater(var0, var12 = RandomPositionGenerator.moveUpOutOfSolid(var12, var0.level().getMaxBuildHeight(), var1 -> PathfinderGoalUtil.isSolid(var0, var1))) || PathfinderGoalUtil.hasMalus(var0, var12)) {
            return null;
        }
        return var12;
    }

    @Nullable
    public static BlockPosition generateRandomPosTowardDirection(EntityCreature var0, int var1, boolean var2, BlockPosition var3) {
        BlockPosition var4 = RandomPositionGenerator.generateRandomPosTowardDirection(var0, var1, var0.getRandom(), var3);
        if (PathfinderGoalUtil.isOutsideLimits(var4, var0) || PathfinderGoalUtil.isRestricted(var2, var0, var4) || PathfinderGoalUtil.isNotStable(var0.getNavigation(), var4)) {
            return null;
        }
        return var4;
    }
}

