/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreath;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowBoat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomSwim;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWater;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJump;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;

public class EntityDolphin
extends EntityWaterAnimal {
    private static final DataWatcherObject<BlockPosition> TREASURE_POS = DataWatcher.defineId(EntityDolphin.class, DataWatcherRegistry.BLOCK_POS);
    private static final DataWatcherObject<Boolean> GOT_FISH = DataWatcher.defineId(EntityDolphin.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> MOISTNESS_LEVEL = DataWatcher.defineId(EntityDolphin.class, DataWatcherRegistry.INT);
    static final PathfinderTargetCondition SWIM_WITH_PLAYER_TARGETING = PathfinderTargetCondition.forNonCombat().range(10.0).ignoreLineOfSight();
    public static final int TOTAL_AIR_SUPPLY = 4800;
    private static final int TOTAL_MOISTNESS_LEVEL = 2400;
    public static final Predicate<EntityItem> ALLOWED_ITEMS = var0 -> !var0.hasPickUpDelay() && var0.isAlive() && var0.isInWater();

    public EntityDolphin(EntityTypes<? extends EntityDolphin> var0, World var1) {
        super((EntityTypes<? extends EntityWaterAnimal>)var0, var1);
        this.moveControl = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl(this, 10);
        this.setCanPickUpLoot(true);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3) {
        this.setAirSupply(this.getMaxAirSupply());
        this.setXRot(0.0f);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    protected void handleAirSupply(int var0) {
    }

    public void setTreasurePos(BlockPosition var0) {
        this.entityData.set(TREASURE_POS, var0);
    }

    public BlockPosition getTreasurePos() {
        return this.entityData.get(TREASURE_POS);
    }

    public boolean gotFish() {
        return this.entityData.get(GOT_FISH);
    }

    public void setGotFish(boolean var0) {
        this.entityData.set(GOT_FISH, var0);
    }

    public int getMoistnessLevel() {
        return this.entityData.get(MOISTNESS_LEVEL);
    }

    public void setMoisntessLevel(int var0) {
        this.entityData.set(MOISTNESS_LEVEL, var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(TREASURE_POS, BlockPosition.ZERO);
        var0.define(GOT_FISH, false);
        var0.define(MOISTNESS_LEVEL, 2400);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("TreasurePosX", this.getTreasurePos().getX());
        var0.putInt("TreasurePosY", this.getTreasurePos().getY());
        var0.putInt("TreasurePosZ", this.getTreasurePos().getZ());
        var0.putBoolean("GotFish", this.gotFish());
        var0.putInt("Moistness", this.getMoistnessLevel());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        int var1 = var0.getInt("TreasurePosX");
        int var2 = var0.getInt("TreasurePosY");
        int var3 = var0.getInt("TreasurePosZ");
        this.setTreasurePos(new BlockPosition(var1, var2, var3));
        super.readAdditionalSaveData(var0);
        this.setGotFish(var0.getBoolean("GotFish"));
        this.setMoisntessLevel(var0.getInt("Moistness"));
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalBreath(this));
        this.goalSelector.addGoal(0, new PathfinderGoalWater(this));
        this.goalSelector.addGoal(1, new a(this));
        this.goalSelector.addGoal(2, new b(this, 4.0));
        this.goalSelector.addGoal(4, new PathfinderGoalRandomSwim(this, 1.0, 10));
        this.goalSelector.addGoal(4, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(5, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(5, new PathfinderGoalWaterJump(this, 10));
        this.goalSelector.addGoal(6, new PathfinderGoalMeleeAttack(this, 1.2f, true));
        this.goalSelector.addGoal(8, new c());
        this.goalSelector.addGoal(8, new PathfinderGoalFollowBoat(this));
        this.goalSelector.addGoal(9, new PathfinderGoalAvoidTarget<EntityGuardian>(this, EntityGuardian.class, 8.0f, 1.0, 1.0));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityGuardian.class).setAlertOthers(new Class[0]));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.MOVEMENT_SPEED, 1.2f).add(GenericAttributes.ATTACK_DAMAGE, 3.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new NavigationGuardian(this, var0);
    }

    @Override
    public void playAttackSound() {
        this.playSound(SoundEffects.DOLPHIN_ATTACK, 1.0f, 1.0f);
    }

    @Override
    public int getMaxAirSupply() {
        return 4800;
    }

    @Override
    protected int increaseAirSupply(int var0) {
        return this.getMaxAirSupply();
    }

    @Override
    public int getMaxHeadXRot() {
        return 1;
    }

    @Override
    public int getMaxHeadYRot() {
        return 1;
    }

    @Override
    protected boolean canRide(Entity var0) {
        return true;
    }

    @Override
    public boolean canTakeItem(ItemStack var0) {
        EnumItemSlot var1 = this.getEquipmentSlotForItem(var0);
        if (!this.getItemBySlot(var1).isEmpty()) {
            return false;
        }
        return var1 == EnumItemSlot.MAINHAND && super.canTakeItem(var0);
    }

    @Override
    protected void pickUpItem(EntityItem var0) {
        ItemStack var1;
        if (this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() && this.canHoldItem(var1 = var0.getItem())) {
            this.onItemPickup(var0);
            this.setItemSlot(EnumItemSlot.MAINHAND, var1);
            this.setGuaranteedDrop(EnumItemSlot.MAINHAND);
            this.take(var0, var1.getCount());
            var0.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isNoAi()) {
            this.setAirSupply(this.getMaxAirSupply());
            return;
        }
        if (this.isInWaterRainOrBubble()) {
            this.setMoisntessLevel(2400);
        } else {
            this.setMoisntessLevel(this.getMoistnessLevel() - 1);
            if (this.getMoistnessLevel() <= 0) {
                this.hurt(this.damageSources().dryOut(), 1.0f);
            }
            if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().add((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f, 0.5, (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f));
                this.setYRot(this.random.nextFloat() * 360.0f);
                this.setOnGround(false);
                this.hasImpulse = true;
            }
        }
        if (this.level().isClientSide && this.isInWater() && this.getDeltaMovement().lengthSqr() > 0.03) {
            Vec3D var0 = this.getViewVector(0.0f);
            float var1 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)) * 0.3f;
            float var2 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)) * 0.3f;
            float var3 = 1.2f - this.random.nextFloat() * 0.7f;
            for (int var4 = 0; var4 < 2; ++var4) {
                this.level().addParticle(Particles.DOLPHIN, this.getX() - var0.x * (double)var3 + (double)var1, this.getY() - var0.y, this.getZ() - var0.z * (double)var3 + (double)var2, 0.0, 0.0, 0.0);
                this.level().addParticle(Particles.DOLPHIN, this.getX() - var0.x * (double)var3 - (double)var1, this.getY() - var0.y, this.getZ() - var0.z * (double)var3 - (double)var2, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 38) {
            this.addParticlesAroundSelf(Particles.HAPPY_VILLAGER);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    private void addParticlesAroundSelf(ParticleParam var0) {
        for (int var1 = 0; var1 < 7; ++var1) {
            double var2 = this.random.nextGaussian() * 0.01;
            double var4 = this.random.nextGaussian() * 0.01;
            double var6 = this.random.nextGaussian() * 0.01;
            this.level().addParticle(var0, this.getRandomX(1.0), this.getRandomY() + 0.2, this.getRandomZ(1.0), var2, var4, var6);
        }
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (!var2.isEmpty() && var2.is(TagsItem.FISHES)) {
            if (!this.level().isClientSide) {
                this.playSound(SoundEffects.DOLPHIN_EAT, 1.0f, 1.0f);
            }
            this.setGotFish(true);
            var2.consume(1, var0);
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.DOLPHIN_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.DOLPHIN_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return this.isInWater() ? SoundEffects.DOLPHIN_AMBIENT_WATER : SoundEffects.DOLPHIN_AMBIENT;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.DOLPHIN_SPLASH;
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.DOLPHIN_SWIM;
    }

    protected boolean closeToNextPos() {
        BlockPosition var0 = this.getNavigation().getTargetPos();
        if (var0 != null) {
            return var0.closerToCenterThan(this.position(), 12.0);
        }
        return false;
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(var0);
        }
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    static class a
    extends PathfinderGoal {
        private final EntityDolphin dolphin;
        private boolean stuck;

        a(EntityDolphin var0) {
            this.dolphin = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean isInterruptable() {
            return false;
        }

        @Override
        public boolean canUse() {
            return this.dolphin.gotFish() && this.dolphin.getAirSupply() >= 100;
        }

        @Override
        public boolean canContinueToUse() {
            BlockPosition var0 = this.dolphin.getTreasurePos();
            return !BlockPosition.containing(var0.getX(), this.dolphin.getY(), var0.getZ()).closerToCenterThan(this.dolphin.position(), 4.0) && !this.stuck && this.dolphin.getAirSupply() >= 100;
        }

        @Override
        public void start() {
            if (!(this.dolphin.level() instanceof WorldServer)) {
                return;
            }
            WorldServer var0 = (WorldServer)this.dolphin.level();
            this.stuck = false;
            this.dolphin.getNavigation().stop();
            BlockPosition var1 = this.dolphin.blockPosition();
            BlockPosition var2 = var0.findNearestMapStructure(StructureTags.DOLPHIN_LOCATED, var1, 50, false);
            if (var2 == null) {
                this.stuck = true;
                return;
            }
            this.dolphin.setTreasurePos(var2);
            var0.broadcastEntityEvent(this.dolphin, (byte)38);
        }

        @Override
        public void stop() {
            BlockPosition var0 = this.dolphin.getTreasurePos();
            if (BlockPosition.containing(var0.getX(), this.dolphin.getY(), var0.getZ()).closerToCenterThan(this.dolphin.position(), 4.0) || this.stuck) {
                this.dolphin.setGotFish(false);
            }
        }

        @Override
        public void tick() {
            World var0 = this.dolphin.level();
            if (this.dolphin.closeToNextPos() || this.dolphin.getNavigation().isDone()) {
                BlockPosition var3;
                Vec3D var1 = Vec3D.atCenterOf(this.dolphin.getTreasurePos());
                Vec3D var2 = DefaultRandomPos.getPosTowards(this.dolphin, 16, 1, var1, 0.3926991f);
                if (var2 == null) {
                    var2 = DefaultRandomPos.getPosTowards(this.dolphin, 8, 4, var1, 1.5707963705062866);
                }
                if (!(var2 == null || var0.getFluidState(var3 = BlockPosition.containing(var2)).is(TagsFluid.WATER) && var0.getBlockState(var3).isPathfindable(PathMode.WATER))) {
                    var2 = DefaultRandomPos.getPosTowards(this.dolphin, 8, 5, var1, 1.5707963705062866);
                }
                if (var2 == null) {
                    this.stuck = true;
                    return;
                }
                this.dolphin.getLookControl().setLookAt(var2.x, var2.y, var2.z, this.dolphin.getMaxHeadYRot() + 20, this.dolphin.getMaxHeadXRot());
                this.dolphin.getNavigation().moveTo(var2.x, var2.y, var2.z, 1.3);
                if (var0.random.nextInt(this.adjustedTickDelay(80)) == 0) {
                    var0.broadcastEntityEvent(this.dolphin, (byte)38);
                }
            }
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityDolphin dolphin;
        private final double speedModifier;
        @Nullable
        private EntityHuman player;

        b(EntityDolphin var0, double var1) {
            this.dolphin = var0;
            this.speedModifier = var1;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            this.player = this.dolphin.level().getNearestPlayer(SWIM_WITH_PLAYER_TARGETING, this.dolphin);
            if (this.player == null) {
                return false;
            }
            return this.player.isSwimming() && this.dolphin.getTarget() != this.player;
        }

        @Override
        public boolean canContinueToUse() {
            return this.player != null && this.player.isSwimming() && this.dolphin.distanceToSqr(this.player) < 256.0;
        }

        @Override
        public void start() {
            this.player.addEffect(new MobEffect(MobEffects.DOLPHINS_GRACE, 100), this.dolphin);
        }

        @Override
        public void stop() {
            this.player = null;
            this.dolphin.getNavigation().stop();
        }

        @Override
        public void tick() {
            this.dolphin.getLookControl().setLookAt(this.player, this.dolphin.getMaxHeadYRot() + 20, this.dolphin.getMaxHeadXRot());
            if (this.dolphin.distanceToSqr(this.player) < 6.25) {
                this.dolphin.getNavigation().stop();
            } else {
                this.dolphin.getNavigation().moveTo(this.player, this.speedModifier);
            }
            if (this.player.isSwimming() && this.player.level().random.nextInt(6) == 0) {
                this.player.addEffect(new MobEffect(MobEffects.DOLPHINS_GRACE, 100), this.dolphin);
            }
        }
    }

    class c
    extends PathfinderGoal {
        private int cooldown;

        c() {
        }

        @Override
        public boolean canUse() {
            if (this.cooldown > EntityDolphin.this.tickCount) {
                return false;
            }
            List<EntityItem> var0 = EntityDolphin.this.level().getEntitiesOfClass(EntityItem.class, EntityDolphin.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !var0.isEmpty() || !EntityDolphin.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty();
        }

        @Override
        public void start() {
            List<EntityItem> var0 = EntityDolphin.this.level().getEntitiesOfClass(EntityItem.class, EntityDolphin.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!var0.isEmpty()) {
                EntityDolphin.this.getNavigation().moveTo(var0.get(0), (double)1.2f);
                EntityDolphin.this.playSound(SoundEffects.DOLPHIN_PLAY, 1.0f, 1.0f);
            }
            this.cooldown = 0;
        }

        @Override
        public void stop() {
            ItemStack var0 = EntityDolphin.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (!var0.isEmpty()) {
                this.drop(var0);
                EntityDolphin.this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
                this.cooldown = EntityDolphin.this.tickCount + EntityDolphin.this.random.nextInt(100);
            }
        }

        @Override
        public void tick() {
            List<EntityItem> var0 = EntityDolphin.this.level().getEntitiesOfClass(EntityItem.class, EntityDolphin.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack var1 = EntityDolphin.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (!var1.isEmpty()) {
                this.drop(var1);
                EntityDolphin.this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
            } else if (!var0.isEmpty()) {
                EntityDolphin.this.getNavigation().moveTo(var0.get(0), (double)1.2f);
            }
        }

        private void drop(ItemStack var0) {
            if (var0.isEmpty()) {
                return;
            }
            double var1 = EntityDolphin.this.getEyeY() - (double)0.3f;
            EntityItem var3 = new EntityItem(EntityDolphin.this.level(), EntityDolphin.this.getX(), var1, EntityDolphin.this.getZ(), var0);
            var3.setPickUpDelay(40);
            var3.setThrower(EntityDolphin.this);
            float var4 = 0.3f;
            float var5 = EntityDolphin.this.random.nextFloat() * ((float)Math.PI * 2);
            float var6 = 0.02f * EntityDolphin.this.random.nextFloat();
            var3.setDeltaMovement(0.3f * -MathHelper.sin(EntityDolphin.this.getYRot() * ((float)Math.PI / 180)) * MathHelper.cos(EntityDolphin.this.getXRot() * ((float)Math.PI / 180)) + MathHelper.cos(var5) * var6, 0.3f * MathHelper.sin(EntityDolphin.this.getXRot() * ((float)Math.PI / 180)) * 1.5f, 0.3f * MathHelper.cos(EntityDolphin.this.getYRot() * ((float)Math.PI / 180)) * MathHelper.cos(EntityDolphin.this.getXRot() * ((float)Math.PI / 180)) + MathHelper.sin(var5) * var6);
            EntityDolphin.this.level().addFreshEntity(var3);
        }
    }
}

