/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.biome.BiomeBase;

public final class WolfVariant {
    public static final Codec<WolfVariant> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)MinecraftKey.CODEC.fieldOf("wild_texture").forGetter(var0 -> var0.wildTexture), (App)MinecraftKey.CODEC.fieldOf("tame_texture").forGetter(var0 -> var0.tameTexture), (App)MinecraftKey.CODEC.fieldOf("angry_texture").forGetter(var0 -> var0.angryTexture), (App)RegistryCodecs.homogeneousList(Registries.BIOME).fieldOf("biomes").forGetter(WolfVariant::biomes)).apply((Applicative)var02, WolfVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WolfVariant> DIRECT_STREAM_CODEC = StreamCodec.composite(MinecraftKey.STREAM_CODEC, WolfVariant::wildTexture, MinecraftKey.STREAM_CODEC, WolfVariant::tameTexture, MinecraftKey.STREAM_CODEC, WolfVariant::angryTexture, ByteBufCodecs.holderSet(Registries.BIOME), WolfVariant::biomes, WolfVariant::new);
    public static final Codec<Holder<WolfVariant>> CODEC = RegistryFileCodec.create(Registries.WOLF_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<WolfVariant>> STREAM_CODEC = ByteBufCodecs.holder(Registries.WOLF_VARIANT, DIRECT_STREAM_CODEC);
    private final MinecraftKey wildTexture;
    private final MinecraftKey tameTexture;
    private final MinecraftKey angryTexture;
    private final MinecraftKey wildTextureFull;
    private final MinecraftKey tameTextureFull;
    private final MinecraftKey angryTextureFull;
    private final HolderSet<BiomeBase> biomes;

    public WolfVariant(MinecraftKey var0, MinecraftKey var1, MinecraftKey var2, HolderSet<BiomeBase> var3) {
        this.wildTexture = var0;
        this.wildTextureFull = WolfVariant.fullTextureId(var0);
        this.tameTexture = var1;
        this.tameTextureFull = WolfVariant.fullTextureId(var1);
        this.angryTexture = var2;
        this.angryTextureFull = WolfVariant.fullTextureId(var2);
        this.biomes = var3;
    }

    private static MinecraftKey fullTextureId(MinecraftKey var02) {
        return var02.withPath(var0 -> "textures/" + var0 + ".png");
    }

    public MinecraftKey wildTexture() {
        return this.wildTextureFull;
    }

    public MinecraftKey tameTexture() {
        return this.tameTextureFull;
    }

    public MinecraftKey angryTexture() {
        return this.angryTextureFull;
    }

    public HolderSet<BiomeBase> biomes() {
        return this.biomes;
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof WolfVariant) {
            WolfVariant var1 = (WolfVariant)var0;
            return Objects.equals(this.wildTexture, var1.wildTexture) && Objects.equals(this.tameTexture, var1.tameTexture) && Objects.equals(this.angryTexture, var1.angryTexture) && Objects.equals(this.biomes, var1.biomes);
        }
        return false;
    }

    public int hashCode() {
        int var0 = 1;
        var0 = 31 * var0 + this.wildTexture.hashCode();
        var0 = 31 * var0 + this.tameTexture.hashCode();
        var0 = 31 * var0 + this.angryTexture.hashCode();
        var0 = 31 * var0 + this.biomes.hashCode();
        return var0;
    }
}

