/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int EQUIPMENT_SLOT_OFFSET = 400;
    public static final int CHEST_SLOT_OFFSET = 499;
    public static final int INVENTORY_SLOT_OFFSET = 500;
    public static final double BREEDING_CROSS_FACTOR = 0.15;
    private static final float MIN_MOVEMENT_SPEED = (float)EntityHorseAbstract.generateSpeed(() -> 0.0);
    private static final float MAX_MOVEMENT_SPEED = (float)EntityHorseAbstract.generateSpeed(() -> 1.0);
    private static final float MIN_JUMP_STRENGTH = (float)EntityHorseAbstract.generateJumpStrength(() -> 0.0);
    private static final float MAX_JUMP_STRENGTH = (float)EntityHorseAbstract.generateJumpStrength(() -> 1.0);
    private static final float MIN_HEALTH = EntityHorseAbstract.generateMaxHealth(var0 -> 0);
    private static final float MAX_HEALTH = EntityHorseAbstract.generateMaxHealth(var0 -> var0 - 1);
    private static final float BACKWARDS_MOVE_SPEED_FACTOR = 0.25f;
    private static final float SIDEWAYS_MOVE_SPEED_FACTOR = 0.5f;
    private static final Predicate<EntityLiving> PARENT_HORSE_SELECTOR = var0 -> var0 instanceof EntityHorseAbstract && ((EntityHorseAbstract)var0).isBred();
    private static final PathfinderTargetCondition MOMMY_TARGETING = PathfinderTargetCondition.forNonCombat().range(16.0).ignoreLineOfSight().selector(PARENT_HORSE_SELECTOR);
    private static final DataWatcherObject<Byte> DATA_ID_FLAGS = DataWatcher.defineId(EntityHorseAbstract.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_TAME = 2;
    private static final int FLAG_SADDLE = 4;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_BASE_COUNT = 1;
    private int eatingCounter;
    private int mouthCounter;
    private int standCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean isJumping;
    public InventorySubcontainer inventory;
    protected int temper;
    protected float playerJumpPendingScale;
    protected boolean allowStandSliding;
    private float eatAnim;
    private float eatAnimO;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    @Nullable
    private UUID owner;
    private final IInventory bodyArmorAccess = new ContainerSingleItem(){

        @Override
        public ItemStack getTheItem() {
            return EntityHorseAbstract.this.getBodyArmorItem();
        }

        @Override
        public void setTheItem(ItemStack var0) {
            EntityHorseAbstract.this.setBodyArmorItem(var0);
        }

        @Override
        public void setChanged() {
        }

        @Override
        public boolean stillValid(EntityHuman var0) {
            return var0.getVehicle() == EntityHorseAbstract.this || var0.canInteractWithEntity(EntityHorseAbstract.this, 4.0);
        }
    };

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.createInventory();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.2));
        this.goalSelector.addGoal(1, new PathfinderGoalTame(this, 1.2));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.goalSelector.addGoal(4, new PathfinderGoalFollowParent(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.goalSelector.addGoal(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        if (this.canPerformRearing()) {
            this.goalSelector.addGoal(9, new RandomStandGoal(this));
        }
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.25, var0 -> var0.is(TagsItem.HORSE_TEMPT_ITEMS), false));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_FLAGS, (byte)0);
    }

    protected boolean getFlag(int var0) {
        return (this.entityData.get(DATA_ID_FLAGS) & var0) != 0;
    }

    protected void setFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(DATA_ID_FLAGS);
        if (var1) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var2 | var0));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var2 & ~var0));
        }
    }

    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwnerUUID(@Nullable UUID var0) {
        this.owner = var0;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setTamed(boolean var0) {
        this.setFlag(2, var0);
    }

    public void setIsJumping(boolean var0) {
        this.isJumping = var0;
    }

    @Override
    public boolean handleLeashAtDistance(Entity var0, float var1) {
        if (var1 > 6.0f && this.isEating()) {
            this.setEating(false);
        }
        return true;
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean var0) {
        this.setFlag(8, var0);
    }

    @Override
    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby() && this.isTamed();
    }

    @Override
    public void equipSaddle(ItemStack var0, @Nullable SoundCategory var1) {
        this.inventory.setItem(0, var0);
    }

    public void equipBodyArmor(EntityHuman var0, ItemStack var1) {
        if (this.isBodyArmorItem(var1)) {
            this.setBodyArmorItem(var1.copyWithCount(1));
            var1.consume(1, var0);
        }
    }

    @Override
    public boolean isSaddled() {
        return this.getFlag(4);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int var0) {
        this.temper = var0;
    }

    public int modifyTemper(int var0) {
        int var1 = MathHelper.clamp(this.getTemper() + var0, 0, this.getMaxTemper());
        this.setTemper(var1);
        return var1;
    }

    @Override
    public boolean isPushable() {
        return !this.isVehicle();
    }

    private void eating() {
        SoundEffect var0;
        this.openMouth();
        if (!this.isSilent() && (var0 = this.getEatingSound()) != null) {
            ((World)this.level()).playSound(null, this.getX(), this.getY(), this.getZ(), var0, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        int var3;
        if (var0 > 1.0f) {
            this.playSound(SoundEffects.HORSE_LAND, 0.4f, 1.0f);
        }
        if ((var3 = this.calculateFallDamage(var0, var1)) <= 0) {
            return false;
        }
        this.hurt(var2, var3);
        if (this.isVehicle()) {
            for (Entity var5 : this.getIndirectPassengers()) {
                var5.hurt(var2, var3);
            }
        }
        this.playBlockFallSound();
        return true;
    }

    public final int getInventorySize() {
        return EntityHorseAbstract.getInventorySize(this.getInventoryColumns());
    }

    public static int getInventorySize(int var0) {
        return var0 * 3 + 1;
    }

    public void createInventory() {
        InventorySubcontainer var0 = this.inventory;
        this.inventory = new InventorySubcontainer(this.getInventorySize());
        if (var0 != null) {
            var0.removeListener(this);
            int var1 = Math.min(var0.getContainerSize(), this.inventory.getContainerSize());
            for (int var2 = 0; var2 < var1; ++var2) {
                ItemStack var3 = var0.getItem(var2);
                if (var3.isEmpty()) continue;
                this.inventory.setItem(var2, var3.copy());
            }
        }
        this.inventory.addListener(this);
        this.syncSaddleToClients();
    }

    protected void syncSaddleToClients() {
        if (((World)this.level()).isClientSide) {
            return;
        }
        this.setFlag(4, !this.inventory.getItem(0).isEmpty());
    }

    @Override
    public void containerChanged(IInventory var0) {
        boolean var1 = this.isSaddled();
        this.syncSaddleToClients();
        if (this.tickCount > 20 && !var1 && this.isSaddled()) {
            this.playSound(this.getSaddleSoundEvent(), 0.5f, 1.0f);
        }
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var2 = super.hurt(var0, var1);
        if (var2 && this.random.nextInt(3) == 0) {
            this.standIfPossible();
        }
        return var2;
    }

    protected boolean canPerformRearing() {
        return true;
    }

    @Nullable
    protected SoundEffect getEatingSound() {
        return null;
    }

    @Nullable
    protected SoundEffect getAngrySound() {
        return null;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (var1.liquid()) {
            return;
        }
        IBlockData var2 = ((World)this.level()).getBlockState(var0.above());
        SoundEffectType var3 = var1.getSoundType();
        if (var2.is(Blocks.SNOW)) {
            var3 = var2.getSoundType();
        }
        if (this.isVehicle() && this.canGallop) {
            ++this.gallopSoundCounter;
            if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                this.playGallopSound(var3);
            } else if (this.gallopSoundCounter <= 5) {
                this.playSound(SoundEffects.HORSE_STEP_WOOD, var3.getVolume() * 0.15f, var3.getPitch());
            }
        } else if (this.isWoodSoundType(var3)) {
            this.playSound(SoundEffects.HORSE_STEP_WOOD, var3.getVolume() * 0.15f, var3.getPitch());
        } else {
            this.playSound(SoundEffects.HORSE_STEP, var3.getVolume() * 0.15f, var3.getPitch());
        }
    }

    private boolean isWoodSoundType(SoundEffectType var0) {
        return var0 == SoundEffectType.WOOD || var0 == SoundEffectType.NETHER_WOOD || var0 == SoundEffectType.STEM || var0 == SoundEffectType.CHERRY_WOOD || var0 == SoundEffectType.BAMBOO_WOOD;
    }

    protected void playGallopSound(SoundEffectType var0) {
        this.playSound(SoundEffects.HORSE_GALLOP, var0.getVolume() * 0.15f, var0.getPitch());
    }

    public static AttributeProvider.Builder createBaseHorseAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.JUMP_STRENGTH, 0.7).add(GenericAttributes.MAX_HEALTH, 53.0).add(GenericAttributes.MOVEMENT_SPEED, 0.225f).add(GenericAttributes.STEP_HEIGHT, 1.0).add(GenericAttributes.SAFE_FALL_DISTANCE, 6.0).add(GenericAttributes.FALL_DAMAGE_MULTIPLIER, 0.5);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    @Override
    protected float getSoundVolume() {
        return 0.8f;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 400;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman var0) {
        if (!((World)this.level()).isClientSide && (!this.isVehicle() || this.hasPassenger(var0)) && this.isTamed()) {
            var0.openHorseInventory(this, this.inventory);
        }
    }

    public EnumInteractionResult fedFood(EntityHuman var0, ItemStack var1) {
        boolean var2 = this.handleEating(var0, var1);
        if (var2) {
            var1.consume(1, var0);
        }
        if (((World)this.level()).isClientSide) {
            return EnumInteractionResult.CONSUME;
        }
        return var2 ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
    }

    protected boolean handleEating(EntityHuman var0, ItemStack var1) {
        boolean var2 = false;
        float var3 = 0.0f;
        int var4 = 0;
        int var5 = 0;
        if (var1.is(Items.WHEAT)) {
            var3 = 2.0f;
            var4 = 20;
            var5 = 3;
        } else if (var1.is(Items.SUGAR)) {
            var3 = 1.0f;
            var4 = 30;
            var5 = 3;
        } else if (var1.is(Blocks.HAY_BLOCK.asItem())) {
            var3 = 20.0f;
            var4 = 180;
        } else if (var1.is(Items.APPLE)) {
            var3 = 3.0f;
            var4 = 60;
            var5 = 3;
        } else if (var1.is(Items.GOLDEN_CARROT)) {
            var3 = 4.0f;
            var4 = 60;
            var5 = 5;
            if (!((World)this.level()).isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                var2 = true;
                this.setInLove(var0);
            }
        } else if (var1.is(Items.GOLDEN_APPLE) || var1.is(Items.ENCHANTED_GOLDEN_APPLE)) {
            var3 = 10.0f;
            var4 = 240;
            var5 = 10;
            if (!((World)this.level()).isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                var2 = true;
                this.setInLove(var0);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && var3 > 0.0f) {
            this.heal(var3);
            var2 = true;
        }
        if (this.isBaby() && var4 > 0) {
            ((World)this.level()).addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!((World)this.level()).isClientSide) {
                this.ageUp(var4);
                var2 = true;
            }
        }
        if (!(var5 <= 0 || !var2 && this.isTamed() || this.getTemper() >= this.getMaxTemper() || ((World)this.level()).isClientSide)) {
            this.modifyTemper(var5);
            var2 = true;
        }
        if (var2) {
            this.eating();
            this.gameEvent(GameEvent.EAT);
        }
        return var2;
    }

    protected void doPlayerRide(EntityHuman var0) {
        this.setEating(false);
        this.setStanding(false);
        if (!((World)this.level()).isClientSide) {
            var0.setYRot(this.getYRot());
            var0.setXRot(this.getXRot());
            var0.startRiding(this);
        }
    }

    @Override
    public boolean isImmobile() {
        return super.isImmobile() && this.isVehicle() && this.isSaddled() || this.isEating() || this.isStanding();
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.HORSE_FOOD);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory == null) {
            return;
        }
        for (int var0 = 0; var0 < this.inventory.getContainerSize(); ++var0) {
            ItemStack var1 = this.inventory.getItem(var0);
            if (var1.isEmpty() || EnchantmentManager.has(var1, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(var1);
        }
    }

    @Override
    public void aiStep() {
        if (this.random.nextInt(200) == 0) {
            this.moveTail();
        }
        super.aiStep();
        if (((World)this.level()).isClientSide || !this.isAlive()) {
            return;
        }
        if (this.random.nextInt(900) == 0 && this.deathTime == 0) {
            this.heal(1.0f);
        }
        if (this.canEatGrass()) {
            if (!this.isEating() && !this.isVehicle() && this.random.nextInt(300) == 0 && ((World)this.level()).getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                this.setEating(true);
            }
            if (this.isEating() && ++this.eatingCounter > 50) {
                this.eatingCounter = 0;
                this.setEating(false);
            }
        }
        this.followMommy();
    }

    protected void followMommy() {
        EntityHorseAbstract var0;
        if (this.isBred() && this.isBaby() && !this.isEating() && (var0 = this.level().getNearestEntity(EntityHorseAbstract.class, MOMMY_TARGETING, this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(16.0))) != null && this.distanceToSqr(var0) > 4.0) {
            this.navigation.createPath(var0, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
            this.setFlag(64, false);
        }
        if (this.isEffectiveAi() && this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
            this.setStanding(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.eatAnimO = this.eatAnim;
        if (this.isEating()) {
            this.eatAnim += (1.0f - this.eatAnim) * 0.4f + 0.05f;
            if (this.eatAnim > 1.0f) {
                this.eatAnim = 1.0f;
            }
        } else {
            this.eatAnim += (0.0f - this.eatAnim) * 0.4f - 0.05f;
            if (this.eatAnim < 0.0f) {
                this.eatAnim = 0.0f;
            }
        }
        this.standAnimO = this.standAnim;
        if (this.isStanding()) {
            this.eatAnimO = this.eatAnim = 0.0f;
            this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
            if (this.standAnim > 1.0f) {
                this.standAnim = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
            if (this.standAnim < 0.0f) {
                this.standAnim = 0.0f;
            }
        }
        this.mouthAnimO = this.mouthAnim;
        if (this.getFlag(64)) {
            this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
            if (this.mouthAnim > 1.0f) {
                this.mouthAnim = 1.0f;
            }
        } else {
            this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
            if (this.mouthAnim < 0.0f) {
                this.mouthAnim = 0.0f;
            }
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        if (this.isVehicle() || this.isBaby()) {
            return super.mobInteract(var0, var1);
        }
        if (this.isTamed() && var0.isSecondaryUseActive()) {
            this.openCustomInventoryScreen(var0);
            return EnumInteractionResult.sidedSuccess(((World)this.level()).isClientSide);
        }
        ItemStack var2 = var0.getItemInHand(var1);
        if (!var2.isEmpty()) {
            EnumInteractionResult var3 = var2.interactLivingEntity(var0, this, var1);
            if (var3.consumesAction()) {
                return var3;
            }
            if (this.canUseSlot(EnumItemSlot.BODY) && this.isBodyArmorItem(var2) && !this.isWearingBodyArmor()) {
                this.equipBodyArmor(var0, var2);
                return EnumInteractionResult.sidedSuccess(((World)this.level()).isClientSide);
            }
        }
        this.doPlayerRide(var0);
        return EnumInteractionResult.sidedSuccess(((World)this.level()).isClientSide);
    }

    private void openMouth() {
        if (!((World)this.level()).isClientSide) {
            this.mouthCounter = 1;
            this.setFlag(64, true);
        }
    }

    public void setEating(boolean var0) {
        this.setFlag(16, var0);
    }

    public void setStanding(boolean var0) {
        if (var0) {
            this.setEating(false);
        }
        this.setFlag(32, var0);
    }

    @Nullable
    public SoundEffect getAmbientStandSound() {
        return this.getAmbientSound();
    }

    public void standIfPossible() {
        if (this.canPerformRearing() && this.isEffectiveAi()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    public void makeMad() {
        if (!this.isStanding()) {
            this.standIfPossible();
            this.makeSound(this.getAngrySound());
        }
    }

    public boolean tameWithName(EntityHuman var0) {
        this.setOwnerUUID(var0.getUUID());
        this.setTamed(true);
        if (var0 instanceof EntityPlayer) {
            CriterionTriggers.TAME_ANIMAL.trigger((EntityPlayer)var0, this);
        }
        ((World)this.level()).broadcastEntityEvent(this, (byte)7);
        return true;
    }

    @Override
    protected void tickRidden(EntityHuman var0, Vec3D var1) {
        super.tickRidden(var0, var1);
        Vec2F var2 = this.getRiddenRotation(var0);
        this.setRot(var2.y, var2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isControlledByLocalInstance()) {
            if (var1.z <= 0.0) {
                this.gallopSoundCounter = 0;
            }
            if (this.onGround()) {
                this.setIsJumping(false);
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                    this.executeRidersJump(this.playerJumpPendingScale, var1);
                }
                this.playerJumpPendingScale = 0.0f;
            }
        }
    }

    protected Vec2F getRiddenRotation(EntityLiving var0) {
        return new Vec2F(var0.getXRot() * 0.5f, var0.getYRot());
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        if (this.onGround() && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
            return Vec3D.ZERO;
        }
        float var2 = var0.xxa * 0.5f;
        float var3 = var0.zza;
        if (var3 <= 0.0f) {
            var3 *= 0.25f;
        }
        return new Vec3D(var2, 0.0, var3);
    }

    @Override
    protected float getRiddenSpeed(EntityHuman var0) {
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED);
    }

    protected void executeRidersJump(float var0, Vec3D var1) {
        double var2 = this.getJumpPower(var0);
        Vec3D var4 = this.getDeltaMovement();
        this.setDeltaMovement(var4.x, var2, var4.z);
        this.setIsJumping(true);
        this.hasImpulse = true;
        if (var1.z > 0.0) {
            float var5 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180));
            float var6 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180));
            this.setDeltaMovement(this.getDeltaMovement().add(-0.4f * var5 * var0, 0.0, 0.4f * var6 * var0));
        }
    }

    protected void playJumpSound() {
        this.playSound(SoundEffects.HORSE_JUMP, 0.4f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("EatingHaystack", this.isEating());
        var0.putBoolean("Bred", this.isBred());
        var0.putInt("Temper", this.getTemper());
        var0.putBoolean("Tame", this.isTamed());
        if (this.getOwnerUUID() != null) {
            var0.putUUID("Owner", this.getOwnerUUID());
        }
        if (!this.inventory.getItem(0).isEmpty()) {
            var0.put("SaddleItem", this.inventory.getItem(0).save(this.registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        Object var2;
        UUID var1;
        super.readAdditionalSaveData(var0);
        this.setEating(var0.getBoolean("EatingHaystack"));
        this.setBred(var0.getBoolean("Bred"));
        this.setTemper(var0.getInt("Temper"));
        this.setTamed(var0.getBoolean("Tame"));
        if (var0.hasUUID("Owner")) {
            var1 = var0.getUUID("Owner");
        } else {
            var2 = var0.getString("Owner");
            var1 = NameReferencingFileConverter.convertMobOwnerIfNecessary(this.getServer(), (String)var2);
        }
        if (var1 != null) {
            this.setOwnerUUID(var1);
        }
        if (var0.contains("SaddleItem", 10) && ((ItemStack)(var2 = ItemStack.parse(this.registryAccess(), var0.getCompound("SaddleItem")).orElse(ItemStack.EMPTY))).is(Items.SADDLE)) {
            this.inventory.setItem(0, (ItemStack)var2);
        }
        this.syncSaddleToClients();
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && this.isTamed() && !this.isBaby() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    protected void setOffspringAttributes(EntityAgeable var0, EntityHorseAbstract var1) {
        this.setOffspringAttribute(var0, var1, GenericAttributes.MAX_HEALTH, MIN_HEALTH, MAX_HEALTH);
        this.setOffspringAttribute(var0, var1, GenericAttributes.JUMP_STRENGTH, MIN_JUMP_STRENGTH, MAX_JUMP_STRENGTH);
        this.setOffspringAttribute(var0, var1, GenericAttributes.MOVEMENT_SPEED, MIN_MOVEMENT_SPEED, MAX_MOVEMENT_SPEED);
    }

    private void setOffspringAttribute(EntityAgeable var0, EntityHorseAbstract var1, Holder<AttributeBase> var2, double var3, double var5) {
        double var7 = EntityHorseAbstract.createOffspringAttribute(this.getAttributeBaseValue(var2), var0.getAttributeBaseValue(var2), var3, var5, this.random);
        var1.getAttribute(var2).setBaseValue(var7);
    }

    static double createOffspringAttribute(double var0, double var2, double var4, double var6, RandomSource var8) {
        double var15;
        if (var6 <= var4) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        var0 = MathHelper.clamp(var0, var4, var6);
        var2 = MathHelper.clamp(var2, var4, var6);
        double var9 = 0.15 * (var6 - var4);
        double var13 = (var0 + var2) / 2.0;
        double var11 = Math.abs(var0 - var2) + var9 * 2.0;
        double var17 = var13 + var11 * (var15 = (var8.nextDouble() + var8.nextDouble() + var8.nextDouble()) / 3.0 - 0.5);
        if (var17 > var6) {
            double var19 = var17 - var6;
            return var6 - var19;
        }
        if (var17 < var4) {
            double var19 = var4 - var17;
            return var4 + var19;
        }
        return var17;
    }

    public float getEatAnim(float var0) {
        return MathHelper.lerp(var0, this.eatAnimO, this.eatAnim);
    }

    public float getStandAnim(float var0) {
        return MathHelper.lerp(var0, this.standAnimO, this.standAnim);
    }

    public float getMouthAnim(float var0) {
        return MathHelper.lerp(var0, this.mouthAnimO, this.mouthAnim);
    }

    @Override
    public void onPlayerJump(int var0) {
        if (!this.isSaddled()) {
            return;
        }
        if (var0 < 0) {
            var0 = 0;
        } else {
            this.allowStandSliding = true;
            this.standIfPossible();
        }
        this.playerJumpPendingScale = var0 >= 90 ? 1.0f : 0.4f + 0.4f * (float)var0 / 90.0f;
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    @Override
    public void handleStartJump(int var0) {
        this.allowStandSliding = true;
        this.standIfPossible();
        this.playJumpSound();
    }

    @Override
    public void handleStopJump() {
    }

    protected void spawnTamingParticles(boolean var0) {
        ParticleType var1 = var0 ? Particles.HEART : Particles.SMOKE;
        for (int var2 = 0; var2 < 7; ++var2) {
            double var3 = this.random.nextGaussian() * 0.02;
            double var5 = this.random.nextGaussian() * 0.02;
            double var7 = this.random.nextGaussian() * 0.02;
            ((World)this.level()).addParticle(var1, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var3, var5, var7);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 7) {
            this.spawnTamingParticles(true);
        } else if (var0 == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    protected void positionRider(Entity var0, Entity.MoveFunction var1) {
        super.positionRider(var0, var1);
        if (var0 instanceof EntityLiving) {
            ((EntityLiving)var0).yBodyRot = this.yBodyRot;
        }
    }

    protected static float generateMaxHealth(IntUnaryOperator var0) {
        return 15.0f + (float)var0.applyAsInt(8) + (float)var0.applyAsInt(9);
    }

    protected static double generateJumpStrength(DoubleSupplier var0) {
        return (double)0.4f + var0.getAsDouble() * 0.2 + var0.getAsDouble() * 0.2 + var0.getAsDouble() * 0.2;
    }

    protected static double generateSpeed(DoubleSupplier var0) {
        return ((double)0.45f + var0.getAsDouble() * 0.3 + var0.getAsDouble() * 0.3 + var0.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        int var1 = var0 - 400;
        if (var1 == 0) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return EntityHorseAbstract.this.inventory.getItem(0);
                }

                @Override
                public boolean set(ItemStack var0) {
                    if (var0.isEmpty() || var0.is(Items.SADDLE)) {
                        EntityHorseAbstract.this.inventory.setItem(0, var0);
                        EntityHorseAbstract.this.syncSaddleToClients();
                        return true;
                    }
                    return false;
                }
            };
        }
        int var2 = var0 - 500 + 1;
        if (var2 >= 1 && var2 < this.inventory.getContainerSize()) {
            return SlotAccess.forContainer(this.inventory, var2);
        }
        return super.getSlot(var0);
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof EntityHuman) {
            EntityHuman var0 = (EntityHuman)entity;
            return var0;
        }
        return super.getControllingPassenger();
    }

    @Nullable
    private Vec3D getDismountLocationInDirection(Vec3D var0, EntityLiving var1) {
        double var2 = this.getX() + var0.x;
        double var4 = this.getBoundingBox().minY;
        double var6 = this.getZ() + var0.z;
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose var10 : var1.getDismountPoses()) {
            var8.set(var2, var4, var6);
            double var11 = this.getBoundingBox().maxY + 0.75;
            do {
                double var13 = this.level().getBlockFloorHeight(var8);
                if ((double)var8.getY() + var13 > var11) continue block0;
                if (DismountUtil.isBlockFloorValid(var13)) {
                    AxisAlignedBB var15 = var1.getLocalBoundsForPose(var10);
                    Vec3D var16 = new Vec3D(var2, (double)var8.getY() + var13, var6);
                    if (DismountUtil.canDismountTo((ICollisionAccess)((Object)this.level()), var1, var15.move(var16))) {
                        var1.setPose(var10);
                        return var16;
                    }
                }
                var8.move(EnumDirection.UP);
            } while ((double)var8.getY() < var11);
        }
        return null;
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        Vec3D var1 = EntityHorseAbstract.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), this.getYRot() + (var0.getMainArm() == EnumMainHand.RIGHT ? 90.0f : -90.0f));
        Vec3D var2 = this.getDismountLocationInDirection(var1, var0);
        if (var2 != null) {
            return var2;
        }
        Vec3D var3 = EntityHorseAbstract.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), this.getYRot() + (var0.getMainArm() == EnumMainHand.LEFT ? 90.0f : -90.0f));
        Vec3D var4 = this.getDismountLocationInDirection(var3, var0);
        if (var4 != null) {
            return var4;
        }
        return this.position();
    }

    protected void randomizeAttributes(RandomSource var0) {
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3) {
        if (var3 == null) {
            var3 = new EntityAgeable.a(0.2f);
        }
        this.randomizeAttributes(var0.getRandom());
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public boolean hasInventoryChanged(IInventory var0) {
        return this.inventory != var0;
    }

    public int getAmbientStandInterval() {
        return this.getAmbientSoundInterval();
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return super.getPassengerAttachmentPoint(var0, var1, var2).add(new Vec3D(0.0, 0.15 * (double)this.standAnimO * (double)var2, -0.7 * (double)this.standAnimO * (double)var2).yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }

    public final IInventory getBodyArmorAccess() {
        return this.bodyArmorAccess;
    }

    public int getInventoryColumns() {
        return 0;
    }

    @Override
    public /* synthetic */ IEntityAccess level() {
        return super.level();
    }
}

