/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.level.World;

public class EntityHorseDonkey
extends EntityHorseChestedAbstract {
    public EntityHorseDonkey(EntityTypes<? extends EntityHorseDonkey> var0, World var1) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)var0, var1);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.DONKEY_AMBIENT;
    }

    @Override
    protected SoundEffect getAngrySound() {
        return SoundEffects.DONKEY_ANGRY;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.DONKEY_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getEatingSound() {
        return SoundEffects.DONKEY_EAT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.DONKEY_HURT;
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0 instanceof EntityHorseDonkey || var0 instanceof EntityHorse) {
            return this.canParent() && ((EntityHorseAbstract)var0).canParent();
        }
        return false;
    }

    @Override
    protected void playJumpSound() {
        this.playSound(SoundEffects.DONKEY_JUMP, 0.4f, 1.0f);
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityTypes<EntityHorseChestedAbstract> var2 = var1 instanceof EntityHorse ? EntityTypes.MULE : EntityTypes.DONKEY;
        EntityHorseAbstract var3 = var2.create(var0);
        if (var3 != null) {
            this.setOffspringAttributes(var1, var3);
        }
        return var3;
    }
}

