/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> DATA_ITEM = DataWatcher.defineId(EntityItemFrame.class, DataWatcherRegistry.ITEM_STACK);
    public static final DataWatcherObject<Integer> DATA_ROTATION = DataWatcher.defineId(EntityItemFrame.class, DataWatcherRegistry.INT);
    public static final int NUM_ROTATIONS = 8;
    private static final float DEPTH = 0.0625f;
    private static final float WIDTH = 0.75f;
    private static final float HEIGHT = 0.75f;
    public float dropChance = 1.0f;
    public boolean fixed;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> var0, World var1) {
        super((EntityTypes<? extends EntityHanging>)var0, var1);
    }

    public EntityItemFrame(World var0, BlockPosition var1, EnumDirection var2) {
        this(EntityTypes.ITEM_FRAME, var0, var1, var2);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> var0, World var1, BlockPosition var2, EnumDirection var3) {
        super((EntityTypes<? extends EntityHanging>)var0, var1, var2);
        this.setDirection(var3);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ITEM, ItemStack.EMPTY);
        var0.define(DATA_ROTATION, 0);
    }

    @Override
    public void setDirection(EnumDirection var0) {
        Validate.notNull((Object)var0);
        this.direction = var0;
        if (var0.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * var0.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected AxisAlignedBB calculateBoundingBox(BlockPosition var0, EnumDirection var1) {
        float var2 = 0.46875f;
        Vec3D var3 = Vec3D.atCenterOf(var0).relative(var1, -0.46875);
        EnumDirection.EnumAxis var4 = var1.getAxis();
        double var5 = var4 == EnumDirection.EnumAxis.X ? 0.0625 : 0.75;
        double var7 = var4 == EnumDirection.EnumAxis.Y ? 0.0625 : 0.75;
        double var9 = var4 == EnumDirection.EnumAxis.Z ? 0.0625 : 0.75;
        return AxisAlignedBB.ofSize(var3, var5, var7, var9);
    }

    @Override
    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision(this)) {
            return false;
        }
        IBlockData var0 = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        if (!(var0.isSolid() || this.direction.getAxis().isHorizontal() && BlockDiodeAbstract.isDiode(var0))) {
            return false;
        }
        return this.level().getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        if (!this.fixed) {
            super.move(var0, var1);
        }
    }

    @Override
    public void push(double var0, double var2, double var4) {
        if (!this.fixed) {
            super.push(var0, var2, var4);
        }
    }

    @Override
    public void kill() {
        this.removeFramedMap(this.getItem());
        super.kill();
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.fixed) {
            if (var0.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || var0.isCreativePlayer()) {
                return super.hurt(var0, var1);
            }
            return false;
        }
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (!var0.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.dropItem(var0.getEntity(), false);
                this.gameEvent(GameEvent.BLOCK_CHANGE, var0.getEntity());
                this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.hurt(var0, var1);
    }

    public SoundEffect getRemoveItemSound() {
        return SoundEffects.ITEM_FRAME_REMOVE_ITEM;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = 16.0;
        return var0 < (var2 *= 64.0 * EntityItemFrame.getViewScale()) * var2;
    }

    @Override
    public void dropItem(@Nullable Entity var0) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(var0, true);
        this.gameEvent(GameEvent.BLOCK_CHANGE, var0);
    }

    public SoundEffect getBreakSound() {
        return SoundEffects.ITEM_FRAME_BREAK;
    }

    @Override
    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEffect getPlaceSound() {
        return SoundEffects.ITEM_FRAME_PLACE;
    }

    private void dropItem(@Nullable Entity var0, boolean var1) {
        EntityHuman var3;
        if (this.fixed) {
            return;
        }
        ItemStack var2 = this.getItem();
        this.setItem(ItemStack.EMPTY);
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            if (var0 == null) {
                this.removeFramedMap(var2);
            }
            return;
        }
        if (var0 instanceof EntityHuman && (var3 = (EntityHuman)var0).hasInfiniteMaterials()) {
            this.removeFramedMap(var2);
            return;
        }
        if (var1) {
            this.spawnAtLocation(this.getFrameItemStack());
        }
        if (!var2.isEmpty()) {
            var2 = var2.copy();
            this.removeFramedMap(var2);
            if (this.random.nextFloat() < this.dropChance) {
                this.spawnAtLocation(var2);
            }
        }
    }

    private void removeFramedMap(ItemStack var0) {
        WorldMap var2;
        MapId var1 = this.getFramedMapId(var0);
        if (var1 != null && (var2 = ItemWorldMap.getSavedData(var1, this.level())) != null) {
            var2.removedFromFrame(this.pos, this.getId());
            var2.setDirty(true);
        }
        var0.setEntityRepresentation(null);
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    @Nullable
    public MapId getFramedMapId(ItemStack var0) {
        return var0.get(DataComponents.MAP_ID);
    }

    public boolean hasFramedMap() {
        return this.getItem().has(DataComponents.MAP_ID);
    }

    public void setItem(ItemStack var0) {
        this.setItem(var0, true);
    }

    public void setItem(ItemStack var0, boolean var1) {
        if (!var0.isEmpty()) {
            var0 = var0.copyWithCount(1);
        }
        this.onItemChanged(var0);
        this.getEntityData().set(DATA_ITEM, var0);
        if (!var0.isEmpty()) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (var1 && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEffect getAddItemSound() {
        return SoundEffects.ITEM_FRAME_ADD_ITEM;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 0) {
            return SlotAccess.of(this::getItem, this::setItem);
        }
        return super.getSlot(var0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (var0.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(ItemStack var0) {
        if (!var0.isEmpty() && var0.getFrame() != this) {
            var0.setEntityRepresentation(this);
        }
        this.recalculateBoundingBox();
    }

    public int getRotation() {
        return this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int var0) {
        this.setRotation(var0, true);
    }

    private void setRotation(int var0, boolean var1) {
        this.getEntityData().set(DATA_ROTATION, var0 % 8);
        if (var1 && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (!this.getItem().isEmpty()) {
            var0.put("Item", this.getItem().save(this.registryAccess()));
            var0.putByte("ItemRotation", (byte)this.getRotation());
            var0.putFloat("ItemDropChance", this.dropChance);
        }
        var0.putByte("Facing", (byte)this.direction.get3DDataValue());
        var0.putBoolean("Invisible", this.isInvisible());
        var0.putBoolean("Fixed", this.fixed);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        ItemStack var1;
        Object var2;
        super.readAdditionalSaveData(var0);
        if (var0.contains("Item", 10)) {
            var2 = var0.getCompound("Item");
            var1 = ItemStack.parse(this.registryAccess(), (NBTBase)var2).orElse(ItemStack.EMPTY);
        } else {
            var1 = ItemStack.EMPTY;
        }
        var2 = this.getItem();
        if (!((ItemStack)var2).isEmpty() && !ItemStack.matches(var1, (ItemStack)var2)) {
            this.removeFramedMap((ItemStack)var2);
        }
        this.setItem(var1, false);
        if (!var1.isEmpty()) {
            this.setRotation(var0.getByte("ItemRotation"), false);
            if (var0.contains("ItemDropChance", 99)) {
                this.dropChance = var0.getFloat("ItemDropChance");
            }
        }
        this.setDirection(EnumDirection.from3DDataValue(var0.getByte("Facing")));
        this.setInvisible(var0.getBoolean("Invisible"));
        this.fixed = var0.getBoolean("Fixed");
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        boolean var4;
        ItemStack var2 = var0.getItemInHand(var1);
        boolean var3 = !this.getItem().isEmpty();
        boolean bl = var4 = !var2.isEmpty();
        if (this.fixed) {
            return EnumInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return var3 || var4 ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
        }
        if (!var3) {
            if (var4 && !this.isRemoved()) {
                WorldMap var5;
                if (var2.is(Items.FILLED_MAP) && (var5 = ItemWorldMap.getSavedData(var2, this.level())) != null && var5.isTrackedCountOverLimit(256)) {
                    return EnumInteractionResult.FAIL;
                }
                this.setItem(var2);
                this.gameEvent(GameEvent.BLOCK_CHANGE, var0);
                var2.consume(1, var0);
            }
        } else {
            this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
            this.setRotation(this.getRotation() + 1);
            this.gameEvent(GameEvent.BLOCK_CHANGE, var0);
        }
        return EnumInteractionResult.CONSUME;
    }

    public SoundEffect getRotateItemSound() {
        return SoundEffects.ITEM_FRAME_ROTATE_ITEM;
    }

    public int getAnalogOutput() {
        if (this.getItem().isEmpty()) {
            return 0;
        }
        return this.getRotation() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        this.setDirection(EnumDirection.from3DDataValue(var0.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack var0 = this.getItem();
        if (var0.isEmpty()) {
            return this.getFrameItemStack();
        }
        return var0.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack(Items.ITEM_FRAME);
    }

    @Override
    public float getVisualRotationYInDegrees() {
        EnumDirection var0 = this.getDirection();
        int var1 = var0.getAxis().isVertical() ? 90 * var0.getAxisDirection().getStep() : 0;
        return MathHelper.wrapDegrees(180 + var0.get2DDataValue() * 90 + this.getRotation() * 45 + var1);
    }
}

