/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class Bogged
extends EntitySkeletonAbstract
implements IShearable {
    private static final int HARD_ATTACK_INTERVAL = 50;
    private static final int NORMAL_ATTACK_INTERVAL = 70;
    private static final DataWatcherObject<Boolean> DATA_SHEARED = DataWatcher.defineId(Bogged.class, DataWatcherRegistry.BOOLEAN);
    public static final String SHEARED_TAG_NAME = "sheared";

    public static AttributeProvider.Builder createAttributes() {
        return EntitySkeletonAbstract.createAttributes().add(GenericAttributes.MAX_HEALTH, 16.0);
    }

    public Bogged(EntityTypes<? extends Bogged> var0, World var1) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_SHEARED, false);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean(SHEARED_TAG_NAME, this.isSheared());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setSheared(var0.getBoolean(SHEARED_TAG_NAME));
    }

    public boolean isSheared() {
        return this.entityData.get(DATA_SHEARED);
    }

    public void setSheared(boolean var0) {
        this.entityData.set(DATA_SHEARED, var0);
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.SHEARS) && this.readyForShearing()) {
            this.shear(SoundCategory.PLAYERS);
            this.gameEvent(GameEvent.SHEAR, var0);
            if (!this.level().isClientSide) {
                var2.hurtAndBreak(1, var0, Bogged.getSlotForHand(var1));
            }
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.BOGGED_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.BOGGED_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BOGGED_DEATH;
    }

    @Override
    protected SoundEffect getStepSound() {
        return SoundEffects.BOGGED_STEP;
    }

    @Override
    protected EntityArrow getArrow(ItemStack var0, float var1, @Nullable ItemStack var2) {
        EntityArrow var3 = super.getArrow(var0, var1, var2);
        if (var3 instanceof EntityTippedArrow) {
            EntityTippedArrow var4 = (EntityTippedArrow)var3;
            var4.addEffect(new MobEffect(MobEffects.POISON, 100));
        }
        return var3;
    }

    @Override
    protected int getHardAttackInterval() {
        return 50;
    }

    @Override
    protected int getAttackInterval() {
        return 70;
    }

    @Override
    public void shear(SoundCategory var0) {
        this.level().playSound(null, this, SoundEffects.BOGGED_SHEAR, var0, 1.0f, 1.0f);
        this.spawnShearedMushrooms();
        this.setSheared(true);
    }

    private void spawnShearedMushrooms() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            LootTable var1 = var0.getServer().reloadableRegistries().getLootTable(LootTables.BOGGED_SHEAR);
            LootParams var2 = new LootParams.a(var0).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.SHEARING);
            for (ItemStack var4 : var1.getRandomItems(var2)) {
                this.spawnAtLocation(var4, this.getBbHeight());
            }
        }
    }

    @Override
    public boolean readyForShearing() {
        return !this.isSheared() && this.isAlive();
    }
}

