/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep wololoTarget;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> var0, World var1) {
        super((EntityTypes<? extends EntityIllagerWizard>)var0, var1);
        this.xpReward = 10;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new b());
        this.goalSelector.addGoal(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(4, new c());
        this.goalSelector.addGoal(5, new a());
        this.goalSelector.addGoal(6, new d());
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.5).add(GenericAttributes.FOLLOW_RANGE, 12.0).add(GenericAttributes.MAX_HEALTH, 24.0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.EVOKER_CELEBRATE;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    @Override
    public boolean isAlliedTo(Entity var0) {
        if (var0 == null) {
            return false;
        }
        if (var0 == this) {
            return true;
        }
        if (super.isAlliedTo(var0)) {
            return true;
        }
        if (var0 instanceof EntityVex) {
            EntityVex var1 = (EntityVex)var0;
            return this.isAlliedTo(var1.getOwner());
        }
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.EVOKER_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.EVOKER_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.EVOKER_HURT;
    }

    void setWololoTarget(@Nullable EntitySheep var0) {
        this.wololoTarget = var0;
    }

    @Nullable
    EntitySheep getWololoTarget() {
        return this.wololoTarget;
    }

    @Override
    protected SoundEffect getCastingSoundEvent() {
        return SoundEffects.EVOKER_CAST_SPELL;
    }

    @Override
    public void applyRaidBuffs(WorldServer var0, int var1, boolean var2) {
    }

    class b
    extends EntityIllagerWizard.b {
        b() {
        }

        @Override
        public void tick() {
            if (EntityEvoker.this.getTarget() != null) {
                EntityEvoker.this.getLookControl().setLookAt(EntityEvoker.this.getTarget(), EntityEvoker.this.getMaxHeadYRot(), EntityEvoker.this.getMaxHeadXRot());
            } else if (EntityEvoker.this.getWololoTarget() != null) {
                EntityEvoker.this.getLookControl().setLookAt(EntityEvoker.this.getWololoTarget(), EntityEvoker.this.getMaxHeadYRot(), EntityEvoker.this.getMaxHeadXRot());
            }
        }
    }

    class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition vexCountTargeting = PathfinderTargetCondition.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        c() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int var0 = EntityEvoker.this.level().getNearbyEntities(EntityVex.class, this.vexCountTargeting, EntityEvoker.this, EntityEvoker.this.getBoundingBox().inflate(16.0)).size();
            return EntityEvoker.this.random.nextInt(8) + 1 > var0;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            WorldServer var0 = (WorldServer)EntityEvoker.this.level();
            ScoreboardTeam var1 = EntityEvoker.this.getTeam();
            for (int var2 = 0; var2 < 3; ++var2) {
                BlockPosition var3 = EntityEvoker.this.blockPosition().offset(-2 + EntityEvoker.this.random.nextInt(5), 1, -2 + EntityEvoker.this.random.nextInt(5));
                EntityVex var4 = EntityTypes.VEX.create(EntityEvoker.this.level());
                if (var4 == null) continue;
                var4.moveTo(var3, 0.0f, 0.0f);
                var4.finalizeSpawn(var0, EntityEvoker.this.level().getCurrentDifficultyAt(var3), EnumMobSpawn.MOB_SUMMONED, null);
                var4.setOwner(EntityEvoker.this);
                var4.setBoundOrigin(var3);
                var4.setLimitedLife(20 * (30 + EntityEvoker.this.random.nextInt(90)));
                if (var1 != null) {
                    var0.getScoreboard().addPlayerToTeam(var4.getScoreboardName(), var1);
                }
                var0.addFreshEntityWithPassengers(var4);
                var0.gameEvent(GameEvent.ENTITY_PLACE, var3, GameEvent.a.of(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.EVOKER_PREPARE_SUMMON;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.SUMMON_VEX;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected void performSpellCasting() {
            EntityLiving var0 = EntityEvoker.this.getTarget();
            double var1 = Math.min(var0.getY(), EntityEvoker.this.getY());
            double var3 = Math.max(var0.getY(), EntityEvoker.this.getY()) + 1.0;
            float var5 = (float)MathHelper.atan2(var0.getZ() - EntityEvoker.this.getZ(), var0.getX() - EntityEvoker.this.getX());
            if (EntityEvoker.this.distanceToSqr(var0) < 9.0) {
                float var7;
                int var6;
                for (var6 = 0; var6 < 5; ++var6) {
                    var7 = var5 + (float)var6 * (float)Math.PI * 0.4f;
                    this.createSpellEntity(EntityEvoker.this.getX() + (double)MathHelper.cos(var7) * 1.5, EntityEvoker.this.getZ() + (double)MathHelper.sin(var7) * 1.5, var1, var3, var7, 0);
                }
                for (var6 = 0; var6 < 8; ++var6) {
                    var7 = var5 + (float)var6 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(EntityEvoker.this.getX() + (double)MathHelper.cos(var7) * 2.5, EntityEvoker.this.getZ() + (double)MathHelper.sin(var7) * 2.5, var1, var3, var7, 3);
                }
            } else {
                for (int var6 = 0; var6 < 16; ++var6) {
                    double var7 = 1.25 * (double)(var6 + 1);
                    int var9 = 1 * var6;
                    this.createSpellEntity(EntityEvoker.this.getX() + (double)MathHelper.cos(var5) * var7, EntityEvoker.this.getZ() + (double)MathHelper.sin(var5) * var7, var1, var3, var5, var9);
                }
            }
        }

        private void createSpellEntity(double var0, double var2, double var4, double var6, float var8, int var9) {
            BlockPosition var10 = BlockPosition.containing(var0, var6, var2);
            boolean var11 = false;
            double var12 = 0.0;
            do {
                IBlockData var16;
                VoxelShape var17;
                BlockPosition var14 = var10.below();
                IBlockData var15 = EntityEvoker.this.level().getBlockState(var14);
                if (!var15.isFaceSturdy(EntityEvoker.this.level(), var14, EnumDirection.UP)) continue;
                if (!EntityEvoker.this.level().isEmptyBlock(var10) && !(var17 = (var16 = EntityEvoker.this.level().getBlockState(var10)).getCollisionShape(EntityEvoker.this.level(), var10)).isEmpty()) {
                    var12 = var17.max(EnumDirection.EnumAxis.Y);
                }
                var11 = true;
                break;
            } while ((var10 = var10.below()).getY() >= MathHelper.floor(var4) - 1);
            if (var11) {
                EntityEvoker.this.level().addFreshEntity(new EntityEvokerFangs(EntityEvoker.this.level(), var0, (double)var10.getY() + var12, var2, var8, var9, EntityEvoker.this));
                EntityEvoker.this.level().gameEvent(GameEvent.ENTITY_PLACE, new Vec3D(var0, (double)var10.getY() + var12, var2), GameEvent.a.of(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.EVOKER_PREPARE_ATTACK;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.FANGS;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition wololoTargeting = PathfinderTargetCondition.forNonCombat().range(16.0).selector(var0 -> ((EntitySheep)var0).getColor() == EnumColor.BLUE);

        @Override
        public boolean canUse() {
            if (EntityEvoker.this.getTarget() != null) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            if (EntityEvoker.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!EntityEvoker.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            List<EntitySheep> var0 = EntityEvoker.this.level().getNearbyEntities(EntitySheep.class, this.wololoTargeting, EntityEvoker.this, EntityEvoker.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (var0.isEmpty()) {
                return false;
            }
            EntityEvoker.this.setWololoTarget(var0.get(EntityEvoker.this.random.nextInt(var0.size())));
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return EntityEvoker.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        @Override
        public void stop() {
            super.stop();
            EntityEvoker.this.setWololoTarget(null);
        }

        @Override
        protected void performSpellCasting() {
            EntitySheep var0 = EntityEvoker.this.getWololoTarget();
            if (var0 != null && var0.isAlive()) {
                var0.setColor(EnumColor.RED);
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 140;
        }

        @Override
        protected SoundEffect getSpellPrepareSound() {
            return SoundEffects.EVOKER_PREPARE_WOLOLO;
        }

        @Override
        protected EntityIllagerWizard.Spell getSpell() {
            return EntityIllagerWizard.Spell.WOLOLO;
        }
    }
}

